/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.ethereum.wallet.service;

import java.util.Collections;
import java.util.Set;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.addon.ethereum.wallet.model.AddressLabel;
import org.exoplatform.addon.ethereum.wallet.model.Wallet;
import org.exoplatform.addon.ethereum.wallet.model.WalletInitializationState;
import org.exoplatform.addon.ethereum.wallet.model.WalletType;
import org.exoplatform.addon.ethereum.wallet.service.WalletAccountService;
import org.exoplatform.addon.ethereum.wallet.storage.AccountStorage;
import org.exoplatform.addon.ethereum.wallet.storage.AddressLabelStorage;
import org.exoplatform.addon.ethereum.wallet.utils.Utils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;

public class EthereumWalletAccountService
implements WalletAccountService {
    private static final String USER_MESSAGE_PREFIX = "User ";
    private static final String CAN_T_FIND_WALLET_ASSOCIATED_TO_ADDRESS = "Can't find wallet associated to address ";
    private static final String ADDRESS_PARAMTER_IS_MANDATORY = "address paramter is mandatory";
    private static final Log LOG = ExoLogger.getLogger(EthereumWalletAccountService.class);
    private AccountStorage accountStorage;
    private AddressLabelStorage labelStorage;
    private ListenerService listenerService;

    public EthereumWalletAccountService(AccountStorage walletAccountStorage, AddressLabelStorage labelStorage) {
        this.accountStorage = walletAccountStorage;
        this.labelStorage = labelStorage;
    }

    public Set<Wallet> listWallets() {
        Set<Wallet> wallets = this.accountStorage.listWallets();
        wallets.forEach(wallet -> Utils.hideWalletOwnerPrivateInformation((Wallet)wallet));
        return wallets;
    }

    public long getWalletsCount() {
        return this.accountStorage.getWalletsCount();
    }

    public Wallet getWalletByIdentityId(long identityId) {
        if (identityId == 0L) {
            throw new IllegalArgumentException("identityId is mandatory");
        }
        Identity identity = Utils.getIdentityById((long)identityId);
        if (identity == null) {
            throw new IllegalArgumentException("Can't find identity with id " + identityId);
        }
        return this.getWalletOfIdentity(identity);
    }

    public Wallet getWalletByTypeAndId(String type, String remoteId, String currentUser) {
        Wallet wallet = this.getWalletByTypeAndId(type, remoteId);
        if (wallet != null) {
            if (WalletType.isSpace((String)wallet.getType())) {
                wallet.setSpaceAdministrator(Utils.isUserSpaceManager((String)wallet.getId(), (String)currentUser));
                if (!wallet.isSpaceAdministrator()) {
                    Utils.hideWalletOwnerPrivateInformation((Wallet)wallet);
                }
            } else if (!StringUtils.equals((String)wallet.getId(), (String)currentUser)) {
                Utils.hideWalletOwnerPrivateInformation((Wallet)wallet);
            }
        }
        return wallet;
    }

    public Wallet getWalletByTypeAndId(String type, String remoteId) {
        Identity identity;
        if (StringUtils.isBlank((String)remoteId)) {
            throw new IllegalArgumentException("id parameter is mandatory");
        }
        WalletType accountType = WalletType.getType((String)type);
        if (accountType.isSpace()) {
            remoteId = Utils.getSpacePrettyName((String)remoteId);
        }
        if ((identity = Utils.getIdentityByTypeAndId((WalletType)accountType, (String)remoteId)) == null) {
            throw new IllegalArgumentException("Can't find identity with id " + remoteId + " and type " + accountType.getId());
        }
        return this.getWalletOfIdentity(identity);
    }

    public void savePrivateKeyByTypeAndId(String type, String remoteId, String content, String currentUser) throws IllegalAccessException {
        Wallet wallet = this.getWalletByTypeAndId(type, remoteId);
        if (wallet == null || wallet.getTechnicalId() < 1L) {
            throw new IllegalStateException("Can't find " + type + " with remote id " + remoteId + ". Wallet private key will not be created.");
        }
        this.checkIsWalletOwner(wallet, currentUser);
        this.accountStorage.saveWalletPrivateKey(wallet.getTechnicalId(), content);
    }

    public String getPrivateKeyByTypeAndId(String type, String remoteId, String currentUser) throws IllegalAccessException {
        Wallet wallet = this.getWalletByTypeAndId(type, remoteId);
        if (wallet == null || wallet.getTechnicalId() < 1L) {
            return null;
        }
        this.checkIsWalletOwner(wallet, currentUser);
        return this.accountStorage.getWalletPrivateKey(wallet.getTechnicalId());
    }

    public void removePrivateKeyByTypeAndId(String type, String remoteId, String currentUser) throws IllegalAccessException {
        Wallet wallet = this.getWalletByTypeAndId(type, remoteId);
        if (wallet == null || wallet.getTechnicalId() < 1L) {
            return;
        }
        this.checkIsWalletOwner(wallet, currentUser);
        this.accountStorage.removeWalletPrivateKey(wallet.getTechnicalId());
    }

    public Wallet getWalletByAddress(String address) {
        if (address == null) {
            throw new IllegalArgumentException("address is mandatory");
        }
        Wallet wallet = this.accountStorage.getWalletByAddress(address);
        if (wallet != null) {
            Identity identity = Utils.getIdentityById((long)wallet.getTechnicalId());
            Utils.computeWalletFromIdentity((Wallet)wallet, (Identity)identity);
        }
        return wallet;
    }

    public void saveWalletAddress(Wallet wallet, String currentUser, boolean broadcast) throws IllegalAccessException {
        if (wallet == null) {
            throw new IllegalArgumentException("Wallet is mandatory");
        }
        if (StringUtils.isBlank((String)wallet.getAddress())) {
            throw new IllegalArgumentException("Wallet address is empty, thus it can't be saved");
        }
        Utils.computeWalletIdentity((Wallet)wallet);
        Wallet oldWallet = this.accountStorage.getWalletByIdentityId(wallet.getTechnicalId());
        boolean isNew = oldWallet == null;
        this.checkCanSaveWallet(wallet, oldWallet, currentUser);
        if (isNew) {
            wallet.setInitializationState(WalletInitializationState.PENDING.name());
        } else if (!StringUtils.equalsIgnoreCase((String)oldWallet.getAddress(), (String)wallet.getAddress())) {
            wallet.setInitializationState(WalletInitializationState.PENDING_REINIT.name());
        } else {
            wallet.setInitializationState(oldWallet.getInitializationState());
        }
        wallet.setEnabled(isNew || oldWallet.isEnabled());
        this.setWalletPassPhrase(wallet, oldWallet);
        this.accountStorage.saveWallet(wallet, isNew);
        if (!isNew) {
            this.accountStorage.removeWalletPrivateKey(wallet.getTechnicalId());
        }
        if (broadcast) {
            String eventName = isNew ? "exo.addon.wallet.addressAssociation.new" : "exo.addon.wallet.addressAssociation.modification";
            wallet = wallet.clone();
            try {
                this.getListenerService().broadcast(eventName, (Object)(oldWallet == null ? null : oldWallet.clone()), (Object)wallet);
            }
            catch (Exception e) {
                LOG.error("Error broadcasting event {} for wallet {}", new Object[]{eventName, wallet, e});
            }
        }
    }

    public void removeWalletByAddress(String address, String currentUser) throws IllegalAccessException {
        if (address == null) {
            throw new IllegalArgumentException(ADDRESS_PARAMTER_IS_MANDATORY);
        }
        Wallet wallet = this.accountStorage.getWalletByAddress(address);
        if (wallet == null) {
            throw new IllegalStateException(CAN_T_FIND_WALLET_ASSOCIATED_TO_ADDRESS + address);
        }
        if (!Utils.isUserAdmin((String)currentUser)) {
            throw new IllegalAccessException("Current user " + currentUser + " attempts to delete wallet with address " + address + " of " + wallet.getType() + " " + wallet.getId());
        }
        this.accountStorage.removeWallet(wallet.getTechnicalId());
    }

    public void enableWalletByAddress(String address, boolean enable, String currentUser) throws IllegalAccessException {
        if (address == null) {
            throw new IllegalArgumentException(ADDRESS_PARAMTER_IS_MANDATORY);
        }
        Wallet wallet = this.accountStorage.getWalletByAddress(address);
        if (wallet == null) {
            throw new IllegalStateException(CAN_T_FIND_WALLET_ASSOCIATED_TO_ADDRESS + address);
        }
        if (!Utils.isUserAdmin((String)currentUser)) {
            throw new IllegalAccessException(USER_MESSAGE_PREFIX + currentUser + " attempts to disable wallet with address " + address + " of " + wallet.getType() + " " + wallet.getId());
        }
        wallet.setEnabled(enable);
        this.accountStorage.saveWallet(wallet, false);
    }

    public void setInitializationStatus(String address, WalletInitializationState initializationState, String currentUser) throws IllegalAccessException {
        if (address == null) {
            throw new IllegalArgumentException(ADDRESS_PARAMTER_IS_MANDATORY);
        }
        if (initializationState == null) {
            throw new IllegalArgumentException("Initialization stte is mandatory");
        }
        Wallet wallet = this.accountStorage.getWalletByAddress(address);
        if (wallet == null) {
            throw new IllegalStateException(CAN_T_FIND_WALLET_ASSOCIATED_TO_ADDRESS + address);
        }
        WalletInitializationState oldInitializationState = WalletInitializationState.valueOf((String)wallet.getInitializationState());
        if (!(oldInitializationState == WalletInitializationState.DENIED && initializationState == WalletInitializationState.PENDING_REINIT && this.isWalletOwner(wallet, currentUser) || Utils.isUserAdmin((String)currentUser) || Utils.isUserRewardingAdmin((String)currentUser))) {
            throw new IllegalAccessException(USER_MESSAGE_PREFIX + currentUser + " attempts to change wallet status with address " + address + " to " + initializationState.name());
        }
        if (oldInitializationState == WalletInitializationState.INITIALIZED) {
            throw new IllegalAccessException("Wallet was already marked as initialized, thus the status for address " + address + " can't change to status " + initializationState.name());
        }
        wallet.setInitializationState(initializationState.name());
        this.accountStorage.saveWallet(wallet, false);
    }

    public void checkCanSaveWallet(Wallet wallet, Wallet storedWallet, String currentUser) throws IllegalAccessException {
        if (Utils.isUserAdmin((String)currentUser)) {
            return;
        }
        this.checkIsWalletOwner(wallet, currentUser);
        if (storedWallet != null && !storedWallet.isEnabled()) {
            LOG.error("User '{}' attempts to modify his wallet while it's disabled", new Object[]{currentUser});
            throw new IllegalAccessException();
        }
        Wallet walletByAddress = this.accountStorage.getWalletByAddress(wallet.getAddress());
        if (walletByAddress != null && walletByAddress.getId() != wallet.getId()) {
            throw new IllegalStateException(USER_MESSAGE_PREFIX + currentUser + " attempts to assign address of wallet of " + walletByAddress);
        }
    }

    public boolean isWalletOwner(Wallet wallet, String currentUser) {
        if (wallet == null) {
            return false;
        }
        String remoteId = wallet.getId();
        WalletType type = WalletType.getType((String)wallet.getType());
        if (type.isSpace()) {
            try {
                return Utils.checkUserIsSpaceManager((String)remoteId, (String)currentUser, (boolean)false);
            }
            catch (IllegalAccessException e) {
                return false;
            }
        }
        return StringUtils.equals((String)currentUser, (String)remoteId);
    }

    public AddressLabel saveOrDeleteAddressLabel(AddressLabel label, String currentUser) {
        if (label == null) {
            throw new IllegalArgumentException("Label is empty");
        }
        long labelId = label.getId();
        if (labelId > 0L) {
            Identity identity = Utils.getIdentityByTypeAndId((WalletType)WalletType.USER, (String)currentUser);
            if (identity == null) {
                throw new IllegalStateException("Can't find identity of user " + currentUser);
            }
            AddressLabel storedLabel = this.labelStorage.getLabel(labelId);
            if (storedLabel == null) {
                label.setId(0L);
            } else if (!StringUtils.equals((String)identity.getId(), (String)String.valueOf(storedLabel.getIdentityId()))) {
                LOG.info("{} user modified address {} label from '{}' to '{}'", new Object[]{currentUser, label.getAddress(), storedLabel.getLabel(), label.getLabel()});
            }
        }
        if (StringUtils.isBlank((String)label.getLabel())) {
            if (labelId > 0L) {
                this.labelStorage.removeLabel(label);
            }
        } else {
            label = this.labelStorage.saveLabel(label);
        }
        return label;
    }

    public Set<AddressLabel> getAddressesLabelsVisibleBy(String currentUser) {
        if (!Utils.isUserAdmin((String)currentUser)) {
            return Collections.emptySet();
        }
        return this.labelStorage.getAllLabels();
    }

    private void checkIsWalletOwner(Wallet wallet, String currentUser) throws IllegalAccessException {
        String remoteId = wallet.getId();
        WalletType type = WalletType.getType((String)wallet.getType());
        if (type.isSpace()) {
            Utils.checkUserIsSpaceManager((String)remoteId, (String)currentUser, (boolean)true);
        } else if (!StringUtils.equals((String)currentUser, (String)remoteId)) {
            throw new IllegalAccessException("User '" + currentUser + "' attempts to modify wallet address of user '" + remoteId + "'");
        }
    }

    private Wallet getWalletOfIdentity(Identity identity) {
        long identityId = Long.parseLong(identity.getId());
        Wallet wallet = this.accountStorage.getWalletByIdentityId(identityId);
        if (wallet == null) {
            wallet = new Wallet();
            wallet.setEnabled(true);
        }
        Utils.computeWalletFromIdentity((Wallet)wallet, (Identity)identity);
        return wallet;
    }

    private void setWalletPassPhrase(Wallet wallet, Wallet oldWallet) {
        if (StringUtils.isBlank((String)wallet.getPassPhrase())) {
            if (oldWallet == null || StringUtils.isBlank((String)oldWallet.getPassPhrase())) {
                wallet.setPassPhrase(this.generateSecurityPhrase());
            } else {
                wallet.setPassPhrase(oldWallet.getPassPhrase());
            }
        }
    }

    private String generateSecurityPhrase() {
        return RandomStringUtils.random((int)20, (char[])Utils.SIMPLE_CHARS);
    }

    private ListenerService getListenerService() {
        if (this.listenerService == null) {
            this.listenerService = (ListenerService)CommonsUtils.getService(ListenerService.class);
        }
        return this.listenerService;
    }
}

