// Generated by delombok at Mon Nov 12 14:09:03 UTC 2018
package org.exoplatform.addon.ethereum.wallet.model;

import java.io.Serializable;
import java.net.URLDecoder;
import java.net.URLEncoder;
import org.apache.commons.lang.StringUtils;
import org.json.JSONException;
import org.json.JSONObject;
import lombok.*;

public class TransactionMessage implements Serializable {
  private static final long serialVersionUID = 658273092293607458L;
  private String hash;
  private String label;
  private String message;
  private String sender;

  public TransactionMessage(String transactionDetails) {
    if (StringUtils.isNotBlank(transactionDetails)) {
      String[] transactionDetailsArray = transactionDetails.split(";");
      this.hash = transactionDetailsArray[0];
      this.label = transactionDetailsArray.length > 1 ? decode(transactionDetailsArray[1]) : null;
      this.message = transactionDetailsArray.length > 2 ? decode(transactionDetailsArray[2]) : null;
    }
  }

  public String toJSONString() {
    return toJSONObject().toString();
  }

  public JSONObject toJSONObject() {
    JSONObject jsonObject = new JSONObject();
    try {
      jsonObject.put("hash", hash);
      jsonObject.put("label", label);
      jsonObject.put("message", message);
      jsonObject.put("sender", sender);
    } catch (JSONException e) {
      throw new RuntimeException("Error while converting Object to JSON", e);
    }
    return jsonObject;
  }

  @Override
  public String toString() {
    return hash + ";" + encode(label) + ";" + encode(message);
  }

  private static String encode(String content) {
    try {
      return StringUtils.isBlank(content) ? "" : URLEncoder.encode(content.trim(), "UTF-8");
    } catch (Exception e) {
      return content;
    }
  }

  private static String decode(String content) {
    try {
      return StringUtils.isBlank(content) ? "" : URLDecoder.decode(content.trim(), "UTF-8");
    } catch (Exception e) {
      return content;
    }
  }

  @java.lang.SuppressWarnings("all")
  public String getHash() {
    return this.hash;
  }

  @java.lang.SuppressWarnings("all")
  public String getLabel() {
    return this.label;
  }

  @java.lang.SuppressWarnings("all")
  public String getMessage() {
    return this.message;
  }

  @java.lang.SuppressWarnings("all")
  public String getSender() {
    return this.sender;
  }

  @java.lang.SuppressWarnings("all")
  public void setHash(final String hash) {
    this.hash = hash;
  }

  @java.lang.SuppressWarnings("all")
  public void setLabel(final String label) {
    this.label = label;
  }

  @java.lang.SuppressWarnings("all")
  public void setMessage(final String message) {
    this.message = message;
  }

  @java.lang.SuppressWarnings("all")
  public void setSender(final String sender) {
    this.sender = sender;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof TransactionMessage)) return false;
    final TransactionMessage other = (TransactionMessage) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$hash = this.getHash();
    final java.lang.Object other$hash = other.getHash();
    if (this$hash == null ? other$hash != null : !this$hash.equals(other$hash)) return false;
    final java.lang.Object this$label = this.getLabel();
    final java.lang.Object other$label = other.getLabel();
    if (this$label == null ? other$label != null : !this$label.equals(other$label)) return false;
    final java.lang.Object this$message = this.getMessage();
    final java.lang.Object other$message = other.getMessage();
    if (this$message == null ? other$message != null : !this$message.equals(other$message)) return false;
    final java.lang.Object this$sender = this.getSender();
    final java.lang.Object other$sender = other.getSender();
    if (this$sender == null ? other$sender != null : !this$sender.equals(other$sender)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof TransactionMessage;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $hash = this.getHash();
    result = result * PRIME + ($hash == null ? 43 : $hash.hashCode());
    final java.lang.Object $label = this.getLabel();
    result = result * PRIME + ($label == null ? 43 : $label.hashCode());
    final java.lang.Object $message = this.getMessage();
    result = result * PRIME + ($message == null ? 43 : $message.hashCode());
    final java.lang.Object $sender = this.getSender();
    result = result * PRIME + ($sender == null ? 43 : $sender.hashCode());
    return result;
  }

  @java.lang.SuppressWarnings("all")
  public TransactionMessage(final String hash, final String label, final String message, final String sender) {
    this.hash = hash;
    this.label = label;
    this.message = message;
    this.sender = sender;
  }

  @java.lang.SuppressWarnings("all")
  public TransactionMessage() {
  }
}
