// Generated by delombok at Mon Dec 10 15:15:40 UTC 2018
package org.exoplatform.addon.ethereum.wallet.model;

import static org.exoplatform.addon.ethereum.wallet.service.utils.Utils.USER_ACCOUNT_TYPE;
import static org.exoplatform.addon.ethereum.wallet.service.utils.Utils.jsonArrayToList;
import java.io.Serializable;
import java.util.*;
import org.apache.commons.lang3.StringUtils;
import org.json.*;

public class GlobalSettings implements Serializable {
  private static final long serialVersionUID = -4672745644323864680L;
  private Integer dataVersion = 0;
  private boolean walletEnabled = true;
  private boolean enableDelegation = true;
  private boolean isAdmin = false;
  private String accessPermission = null;
  private String fundsHolder = null;
  private String initialFundsRequestMessage = null;
  private String fundsHolderType = USER_ACCOUNT_TYPE;
  private String providerURL = null;
  private String websocketProviderURL = null;
  private Long defaultNetworkId = 0L;
  private Long defaultGas = 0L;
  private Long minGasPrice = 4000000000L;
  private Long normalGasPrice = 8000000000L;
  private Long maxGasPrice = 15000000000L;
  private String principalContractAdminName = "Admin";
  private String principalContractAdminAddress = null;
  private String defaultPrincipalAccount = null;
  private List<String> defaultOverviewAccounts = null;
  private Map<String, Double> initialFunds;
  private UserPreferences userPreferences;
  /**
   * Managed in other storage location
   */
  private transient Set<String> defaultContractsToDisplay;
  /**
   * Managed by code
   */
  private transient JSONArray contractAbi = null;
  /**
   * Managed by code
   */
  private transient String contractBin = null;

  public String toJSONString(boolean includeTransient) {
    return toJSONObject(includeTransient).toString();
  }

  public JSONObject toJSONObject(boolean includeTransient) {
    JSONObject jsonObject = new JSONObject();
    try {
      jsonObject.put("enableDelegation", enableDelegation);
      if (StringUtils.isNotBlank(accessPermission)) {
        jsonObject.put("accessPermission", accessPermission);
      }
      if (StringUtils.isNotBlank(initialFundsRequestMessage)) {
        jsonObject.put("initialFundsRequestMessage", initialFundsRequestMessage);
      }
      if (StringUtils.isNotBlank(fundsHolder)) {
        jsonObject.put("fundsHolder", fundsHolder);
      }
      if (StringUtils.isNotBlank(fundsHolderType)) {
        jsonObject.put("fundsHolderType", fundsHolderType);
      }
      if (StringUtils.isNotBlank(providerURL)) {
        jsonObject.put("providerURL", providerURL);
      }
      if (StringUtils.isNotBlank(websocketProviderURL)) {
        jsonObject.put("websocketProviderURL", websocketProviderURL);
      }
      if (defaultNetworkId != null && defaultNetworkId != 0) {
        jsonObject.put("defaultNetworkId", defaultNetworkId);
      }
      if (defaultGas != null && defaultGas != 0) {
        jsonObject.put("defaultGas", defaultGas);
      }
      if (minGasPrice != null && minGasPrice != 0) {
        jsonObject.put("minGasPrice", minGasPrice);
      }
      if (normalGasPrice != null && normalGasPrice != 0) {
        jsonObject.put("normalGasPrice", normalGasPrice);
      }
      if (maxGasPrice != null && maxGasPrice != 0) {
        jsonObject.put("maxGasPrice", maxGasPrice);
      }
      if (dataVersion != null && dataVersion != 0) {
        jsonObject.put("dataVersion", dataVersion);
      }
      if (initialFunds != null && !initialFunds.isEmpty()) {
        JSONArray array = new JSONArray();
        Set<String> addresses = initialFunds.keySet();
        for (String address : addresses) {
          JSONObject obj = new JSONObject();
          obj.put("address", address);
          obj.put("amount", initialFunds.get(address));
          array.put(obj);
        }
        jsonObject.put("initialFunds", array);
      }
      if (StringUtils.isNotBlank(defaultPrincipalAccount)) {
        jsonObject.put("defaultPrincipalAccount", defaultPrincipalAccount);
      }
      if (defaultOverviewAccounts != null && !defaultOverviewAccounts.isEmpty()) {
        jsonObject.put("defaultOverviewAccounts", new JSONArray(defaultOverviewAccounts));
      }
      if (includeTransient) {
        jsonObject.put("isAdmin", isAdmin);
        jsonObject.put("isWalletEnabled", walletEnabled);
        if (userPreferences != null) {
          jsonObject.put("userPreferences", userPreferences.toJSONObject());
        }
        if (StringUtils.isNotBlank(principalContractAdminName)) {
          jsonObject.put("principalContractAdminName", principalContractAdminName);
        }
        if (StringUtils.isNotBlank(principalContractAdminAddress)) {
          jsonObject.put("principalContractAdminAddress", principalContractAdminAddress);
        }
        if (defaultContractsToDisplay != null && !defaultContractsToDisplay.isEmpty()) {
          jsonObject.put("defaultContractsToDisplay", new JSONArray(defaultContractsToDisplay));
        }
        if (contractAbi != null && contractAbi.length() > 0) {
          jsonObject.put("contractAbi", contractAbi);
        }
        if (StringUtils.isNotBlank(contractBin)) {
          jsonObject.put("contractBin", contractBin);
        }
      }
    } catch (JSONException e) {
      throw new RuntimeException("Error while converting Object to JSON", e);
    }
    return jsonObject;
  }

  @Override
  public String toString() {
    return toJSONString(false);
  }

  public static final GlobalSettings parseStringToObject(GlobalSettings defaultSettings, String jsonString) {
    if (defaultSettings == null) {
      defaultSettings = new GlobalSettings();
    }
    if (StringUtils.isBlank(jsonString)) {
      try {
        return (GlobalSettings) defaultSettings.clone();
      } catch (CloneNotSupportedException e) {
        return null;
      }
    }
    try {
      JSONObject jsonObject = new JSONObject(jsonString);
      GlobalSettings globalSettings = new GlobalSettings();
      String storedFundsHolder = jsonObject.has("fundsHolder") ? jsonObject.getString("fundsHolder") : defaultSettings.getFundsHolder();
      globalSettings.setFundsHolder(storedFundsHolder);
      String storedFundsHolderType = jsonObject.has("fundsHolderType") ? jsonObject.getString("fundsHolderType") : defaultSettings.getFundsHolderType();
      globalSettings.setFundsHolderType(storedFundsHolderType);
      Map<String, Double> storedInitialFunds = jsonObject.has("initialFunds") ? toMap(jsonObject.getJSONArray("initialFunds")) : defaultSettings.getInitialFunds();
      globalSettings.setInitialFunds(storedInitialFunds);
      String storedAccessPermission = jsonObject.has("accessPermission") ? jsonObject.getString("accessPermission") : defaultSettings.getAccessPermission();
      globalSettings.setAccessPermission(storedAccessPermission);
      String storedInitialfundsRequestMessage = jsonObject.has("initialFundsRequestMessage") ? jsonObject.getString("initialFundsRequestMessage") : defaultSettings.getInitialFundsRequestMessage();
      globalSettings.setInitialFundsRequestMessage(storedInitialfundsRequestMessage);
      String storedProviderURL = jsonObject.has("providerURL") ? jsonObject.getString("providerURL") : defaultSettings.getProviderURL();
      globalSettings.setProviderURL(storedProviderURL);
      String storedWebsocketProviderURL = jsonObject.has("websocketProviderURL") ? jsonObject.getString("websocketProviderURL") : defaultSettings.getWebsocketProviderURL();
      globalSettings.setWebsocketProviderURL(storedWebsocketProviderURL);
      long storedDefaultNetworkId = jsonObject.has("defaultNetworkId") ? jsonObject.getLong("defaultNetworkId") : defaultSettings.getDefaultNetworkId();
      globalSettings.setDefaultNetworkId(storedDefaultNetworkId);
      long storedDefaultGas = jsonObject.has("defaultGas") ? jsonObject.getLong("defaultGas") : defaultSettings.getDefaultGas();
      globalSettings.setDefaultGas(storedDefaultGas);
      long storedMinGasPrice = jsonObject.has("minGasPrice") ? jsonObject.getLong("minGasPrice") : defaultSettings.getMinGasPrice();
      globalSettings.setMinGasPrice(storedMinGasPrice);
      long storedNormalGasPrice = jsonObject.has("normalGasPrice") ? jsonObject.getLong("normalGasPrice") : defaultSettings.getNormalGasPrice();
      globalSettings.setNormalGasPrice(storedNormalGasPrice);
      long storedMaxGasPrice = jsonObject.has("maxGasPrice") ? jsonObject.getLong("maxGasPrice") : defaultSettings.getMaxGasPrice();
      globalSettings.setMaxGasPrice(storedMaxGasPrice);
      boolean storedEnableDelegation = jsonObject.has("enableDelegation") ? jsonObject.getBoolean("enableDelegation") : defaultSettings.isEnableDelegation();
      globalSettings.setEnableDelegation(storedEnableDelegation);
      String storedDefaultPrincipalAccount = jsonObject.has("defaultPrincipalAccount") ? jsonObject.getString("defaultPrincipalAccount") : defaultSettings.getDefaultPrincipalAccount();
      globalSettings.setDefaultPrincipalAccount(storedDefaultPrincipalAccount);
      globalSettings.setDefaultOverviewAccounts(jsonArrayToList(jsonObject, "defaultOverviewAccounts"));
      globalSettings.setDataVersion(jsonObject.has("dataVersion") ? jsonObject.getInt("dataVersion") : 0);
      return globalSettings;
    } catch (JSONException e) {
      throw new RuntimeException("Error while converting JSON String to Object", e);
    }
  }

  public static final GlobalSettings parseStringToObject(String jsonString) {
    return parseStringToObject(null, jsonString);
  }

  private static Map<String, Double> toMap(JSONArray storedInitialFunds) throws JSONException {
    HashMap<String, Double> map = new HashMap<>();
    if (storedInitialFunds == null || storedInitialFunds.length() == 0) {
      return map;
    }
    for (int i = 0; i < storedInitialFunds.length(); i++) {
      JSONObject obj = storedInitialFunds.getJSONObject(i);
      map.put(obj.getString("address"), obj.getDouble("amount"));
    }
    return map;
  }

  @java.lang.SuppressWarnings("all")
  public Integer getDataVersion() {
    return this.dataVersion;
  }

  @java.lang.SuppressWarnings("all")
  public boolean isWalletEnabled() {
    return this.walletEnabled;
  }

  @java.lang.SuppressWarnings("all")
  public boolean isEnableDelegation() {
    return this.enableDelegation;
  }

  @java.lang.SuppressWarnings("all")
  public boolean isAdmin() {
    return this.isAdmin;
  }

  @java.lang.SuppressWarnings("all")
  public String getAccessPermission() {
    return this.accessPermission;
  }

  @java.lang.SuppressWarnings("all")
  public String getFundsHolder() {
    return this.fundsHolder;
  }

  @java.lang.SuppressWarnings("all")
  public String getInitialFundsRequestMessage() {
    return this.initialFundsRequestMessage;
  }

  @java.lang.SuppressWarnings("all")
  public String getFundsHolderType() {
    return this.fundsHolderType;
  }

  @java.lang.SuppressWarnings("all")
  public String getProviderURL() {
    return this.providerURL;
  }

  @java.lang.SuppressWarnings("all")
  public String getWebsocketProviderURL() {
    return this.websocketProviderURL;
  }

  @java.lang.SuppressWarnings("all")
  public Long getDefaultNetworkId() {
    return this.defaultNetworkId;
  }

  @java.lang.SuppressWarnings("all")
  public Long getDefaultGas() {
    return this.defaultGas;
  }

  @java.lang.SuppressWarnings("all")
  public Long getMinGasPrice() {
    return this.minGasPrice;
  }

  @java.lang.SuppressWarnings("all")
  public Long getNormalGasPrice() {
    return this.normalGasPrice;
  }

  @java.lang.SuppressWarnings("all")
  public Long getMaxGasPrice() {
    return this.maxGasPrice;
  }

  @java.lang.SuppressWarnings("all")
  public String getPrincipalContractAdminName() {
    return this.principalContractAdminName;
  }

  @java.lang.SuppressWarnings("all")
  public String getPrincipalContractAdminAddress() {
    return this.principalContractAdminAddress;
  }

  @java.lang.SuppressWarnings("all")
  public String getDefaultPrincipalAccount() {
    return this.defaultPrincipalAccount;
  }

  @java.lang.SuppressWarnings("all")
  public List<String> getDefaultOverviewAccounts() {
    return this.defaultOverviewAccounts;
  }

  @java.lang.SuppressWarnings("all")
  public Map<String, Double> getInitialFunds() {
    return this.initialFunds;
  }

  @java.lang.SuppressWarnings("all")
  public UserPreferences getUserPreferences() {
    return this.userPreferences;
  }

  /**
   * Managed in other storage location
   */
  @java.lang.SuppressWarnings("all")
  public Set<String> getDefaultContractsToDisplay() {
    return this.defaultContractsToDisplay;
  }

  /**
   * Managed by code
   */
  @java.lang.SuppressWarnings("all")
  public JSONArray getContractAbi() {
    return this.contractAbi;
  }

  /**
   * Managed by code
   */
  @java.lang.SuppressWarnings("all")
  public String getContractBin() {
    return this.contractBin;
  }

  @java.lang.SuppressWarnings("all")
  public void setDataVersion(final Integer dataVersion) {
    this.dataVersion = dataVersion;
  }

  @java.lang.SuppressWarnings("all")
  public void setWalletEnabled(final boolean walletEnabled) {
    this.walletEnabled = walletEnabled;
  }

  @java.lang.SuppressWarnings("all")
  public void setEnableDelegation(final boolean enableDelegation) {
    this.enableDelegation = enableDelegation;
  }

  @java.lang.SuppressWarnings("all")
  public void setAdmin(final boolean isAdmin) {
    this.isAdmin = isAdmin;
  }

  @java.lang.SuppressWarnings("all")
  public void setAccessPermission(final String accessPermission) {
    this.accessPermission = accessPermission;
  }

  @java.lang.SuppressWarnings("all")
  public void setFundsHolder(final String fundsHolder) {
    this.fundsHolder = fundsHolder;
  }

  @java.lang.SuppressWarnings("all")
  public void setInitialFundsRequestMessage(final String initialFundsRequestMessage) {
    this.initialFundsRequestMessage = initialFundsRequestMessage;
  }

  @java.lang.SuppressWarnings("all")
  public void setFundsHolderType(final String fundsHolderType) {
    this.fundsHolderType = fundsHolderType;
  }

  @java.lang.SuppressWarnings("all")
  public void setProviderURL(final String providerURL) {
    this.providerURL = providerURL;
  }

  @java.lang.SuppressWarnings("all")
  public void setWebsocketProviderURL(final String websocketProviderURL) {
    this.websocketProviderURL = websocketProviderURL;
  }

  @java.lang.SuppressWarnings("all")
  public void setDefaultNetworkId(final Long defaultNetworkId) {
    this.defaultNetworkId = defaultNetworkId;
  }

  @java.lang.SuppressWarnings("all")
  public void setDefaultGas(final Long defaultGas) {
    this.defaultGas = defaultGas;
  }

  @java.lang.SuppressWarnings("all")
  public void setMinGasPrice(final Long minGasPrice) {
    this.minGasPrice = minGasPrice;
  }

  @java.lang.SuppressWarnings("all")
  public void setNormalGasPrice(final Long normalGasPrice) {
    this.normalGasPrice = normalGasPrice;
  }

  @java.lang.SuppressWarnings("all")
  public void setMaxGasPrice(final Long maxGasPrice) {
    this.maxGasPrice = maxGasPrice;
  }

  @java.lang.SuppressWarnings("all")
  public void setPrincipalContractAdminName(final String principalContractAdminName) {
    this.principalContractAdminName = principalContractAdminName;
  }

  @java.lang.SuppressWarnings("all")
  public void setPrincipalContractAdminAddress(final String principalContractAdminAddress) {
    this.principalContractAdminAddress = principalContractAdminAddress;
  }

  @java.lang.SuppressWarnings("all")
  public void setDefaultPrincipalAccount(final String defaultPrincipalAccount) {
    this.defaultPrincipalAccount = defaultPrincipalAccount;
  }

  @java.lang.SuppressWarnings("all")
  public void setDefaultOverviewAccounts(final List<String> defaultOverviewAccounts) {
    this.defaultOverviewAccounts = defaultOverviewAccounts;
  }

  @java.lang.SuppressWarnings("all")
  public void setInitialFunds(final Map<String, Double> initialFunds) {
    this.initialFunds = initialFunds;
  }

  @java.lang.SuppressWarnings("all")
  public void setUserPreferences(final UserPreferences userPreferences) {
    this.userPreferences = userPreferences;
  }

  /**
   * Managed in other storage location
   */
  @java.lang.SuppressWarnings("all")
  public void setDefaultContractsToDisplay(final Set<String> defaultContractsToDisplay) {
    this.defaultContractsToDisplay = defaultContractsToDisplay;
  }

  /**
   * Managed by code
   */
  @java.lang.SuppressWarnings("all")
  public void setContractAbi(final JSONArray contractAbi) {
    this.contractAbi = contractAbi;
  }

  /**
   * Managed by code
   */
  @java.lang.SuppressWarnings("all")
  public void setContractBin(final String contractBin) {
    this.contractBin = contractBin;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof GlobalSettings)) return false;
    final GlobalSettings other = (GlobalSettings) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$dataVersion = this.getDataVersion();
    final java.lang.Object other$dataVersion = other.getDataVersion();
    if (this$dataVersion == null ? other$dataVersion != null : !this$dataVersion.equals(other$dataVersion)) return false;
    if (this.isWalletEnabled() != other.isWalletEnabled()) return false;
    if (this.isEnableDelegation() != other.isEnableDelegation()) return false;
    if (this.isAdmin() != other.isAdmin()) return false;
    final java.lang.Object this$accessPermission = this.getAccessPermission();
    final java.lang.Object other$accessPermission = other.getAccessPermission();
    if (this$accessPermission == null ? other$accessPermission != null : !this$accessPermission.equals(other$accessPermission)) return false;
    final java.lang.Object this$fundsHolder = this.getFundsHolder();
    final java.lang.Object other$fundsHolder = other.getFundsHolder();
    if (this$fundsHolder == null ? other$fundsHolder != null : !this$fundsHolder.equals(other$fundsHolder)) return false;
    final java.lang.Object this$initialFundsRequestMessage = this.getInitialFundsRequestMessage();
    final java.lang.Object other$initialFundsRequestMessage = other.getInitialFundsRequestMessage();
    if (this$initialFundsRequestMessage == null ? other$initialFundsRequestMessage != null : !this$initialFundsRequestMessage.equals(other$initialFundsRequestMessage)) return false;
    final java.lang.Object this$fundsHolderType = this.getFundsHolderType();
    final java.lang.Object other$fundsHolderType = other.getFundsHolderType();
    if (this$fundsHolderType == null ? other$fundsHolderType != null : !this$fundsHolderType.equals(other$fundsHolderType)) return false;
    final java.lang.Object this$providerURL = this.getProviderURL();
    final java.lang.Object other$providerURL = other.getProviderURL();
    if (this$providerURL == null ? other$providerURL != null : !this$providerURL.equals(other$providerURL)) return false;
    final java.lang.Object this$websocketProviderURL = this.getWebsocketProviderURL();
    final java.lang.Object other$websocketProviderURL = other.getWebsocketProviderURL();
    if (this$websocketProviderURL == null ? other$websocketProviderURL != null : !this$websocketProviderURL.equals(other$websocketProviderURL)) return false;
    final java.lang.Object this$defaultNetworkId = this.getDefaultNetworkId();
    final java.lang.Object other$defaultNetworkId = other.getDefaultNetworkId();
    if (this$defaultNetworkId == null ? other$defaultNetworkId != null : !this$defaultNetworkId.equals(other$defaultNetworkId)) return false;
    final java.lang.Object this$defaultGas = this.getDefaultGas();
    final java.lang.Object other$defaultGas = other.getDefaultGas();
    if (this$defaultGas == null ? other$defaultGas != null : !this$defaultGas.equals(other$defaultGas)) return false;
    final java.lang.Object this$minGasPrice = this.getMinGasPrice();
    final java.lang.Object other$minGasPrice = other.getMinGasPrice();
    if (this$minGasPrice == null ? other$minGasPrice != null : !this$minGasPrice.equals(other$minGasPrice)) return false;
    final java.lang.Object this$normalGasPrice = this.getNormalGasPrice();
    final java.lang.Object other$normalGasPrice = other.getNormalGasPrice();
    if (this$normalGasPrice == null ? other$normalGasPrice != null : !this$normalGasPrice.equals(other$normalGasPrice)) return false;
    final java.lang.Object this$maxGasPrice = this.getMaxGasPrice();
    final java.lang.Object other$maxGasPrice = other.getMaxGasPrice();
    if (this$maxGasPrice == null ? other$maxGasPrice != null : !this$maxGasPrice.equals(other$maxGasPrice)) return false;
    final java.lang.Object this$principalContractAdminName = this.getPrincipalContractAdminName();
    final java.lang.Object other$principalContractAdminName = other.getPrincipalContractAdminName();
    if (this$principalContractAdminName == null ? other$principalContractAdminName != null : !this$principalContractAdminName.equals(other$principalContractAdminName)) return false;
    final java.lang.Object this$principalContractAdminAddress = this.getPrincipalContractAdminAddress();
    final java.lang.Object other$principalContractAdminAddress = other.getPrincipalContractAdminAddress();
    if (this$principalContractAdminAddress == null ? other$principalContractAdminAddress != null : !this$principalContractAdminAddress.equals(other$principalContractAdminAddress)) return false;
    final java.lang.Object this$defaultPrincipalAccount = this.getDefaultPrincipalAccount();
    final java.lang.Object other$defaultPrincipalAccount = other.getDefaultPrincipalAccount();
    if (this$defaultPrincipalAccount == null ? other$defaultPrincipalAccount != null : !this$defaultPrincipalAccount.equals(other$defaultPrincipalAccount)) return false;
    final java.lang.Object this$defaultOverviewAccounts = this.getDefaultOverviewAccounts();
    final java.lang.Object other$defaultOverviewAccounts = other.getDefaultOverviewAccounts();
    if (this$defaultOverviewAccounts == null ? other$defaultOverviewAccounts != null : !this$defaultOverviewAccounts.equals(other$defaultOverviewAccounts)) return false;
    final java.lang.Object this$initialFunds = this.getInitialFunds();
    final java.lang.Object other$initialFunds = other.getInitialFunds();
    if (this$initialFunds == null ? other$initialFunds != null : !this$initialFunds.equals(other$initialFunds)) return false;
    final java.lang.Object this$userPreferences = this.getUserPreferences();
    final java.lang.Object other$userPreferences = other.getUserPreferences();
    if (this$userPreferences == null ? other$userPreferences != null : !this$userPreferences.equals(other$userPreferences)) return false;
    final java.lang.Object this$defaultContractsToDisplay = this.getDefaultContractsToDisplay();
    final java.lang.Object other$defaultContractsToDisplay = other.getDefaultContractsToDisplay();
    if (this$defaultContractsToDisplay == null ? other$defaultContractsToDisplay != null : !this$defaultContractsToDisplay.equals(other$defaultContractsToDisplay)) return false;
    final java.lang.Object this$contractAbi = this.getContractAbi();
    final java.lang.Object other$contractAbi = other.getContractAbi();
    if (this$contractAbi == null ? other$contractAbi != null : !this$contractAbi.equals(other$contractAbi)) return false;
    final java.lang.Object this$contractBin = this.getContractBin();
    final java.lang.Object other$contractBin = other.getContractBin();
    if (this$contractBin == null ? other$contractBin != null : !this$contractBin.equals(other$contractBin)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof GlobalSettings;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $dataVersion = this.getDataVersion();
    result = result * PRIME + ($dataVersion == null ? 43 : $dataVersion.hashCode());
    result = result * PRIME + (this.isWalletEnabled() ? 79 : 97);
    result = result * PRIME + (this.isEnableDelegation() ? 79 : 97);
    result = result * PRIME + (this.isAdmin() ? 79 : 97);
    final java.lang.Object $accessPermission = this.getAccessPermission();
    result = result * PRIME + ($accessPermission == null ? 43 : $accessPermission.hashCode());
    final java.lang.Object $fundsHolder = this.getFundsHolder();
    result = result * PRIME + ($fundsHolder == null ? 43 : $fundsHolder.hashCode());
    final java.lang.Object $initialFundsRequestMessage = this.getInitialFundsRequestMessage();
    result = result * PRIME + ($initialFundsRequestMessage == null ? 43 : $initialFundsRequestMessage.hashCode());
    final java.lang.Object $fundsHolderType = this.getFundsHolderType();
    result = result * PRIME + ($fundsHolderType == null ? 43 : $fundsHolderType.hashCode());
    final java.lang.Object $providerURL = this.getProviderURL();
    result = result * PRIME + ($providerURL == null ? 43 : $providerURL.hashCode());
    final java.lang.Object $websocketProviderURL = this.getWebsocketProviderURL();
    result = result * PRIME + ($websocketProviderURL == null ? 43 : $websocketProviderURL.hashCode());
    final java.lang.Object $defaultNetworkId = this.getDefaultNetworkId();
    result = result * PRIME + ($defaultNetworkId == null ? 43 : $defaultNetworkId.hashCode());
    final java.lang.Object $defaultGas = this.getDefaultGas();
    result = result * PRIME + ($defaultGas == null ? 43 : $defaultGas.hashCode());
    final java.lang.Object $minGasPrice = this.getMinGasPrice();
    result = result * PRIME + ($minGasPrice == null ? 43 : $minGasPrice.hashCode());
    final java.lang.Object $normalGasPrice = this.getNormalGasPrice();
    result = result * PRIME + ($normalGasPrice == null ? 43 : $normalGasPrice.hashCode());
    final java.lang.Object $maxGasPrice = this.getMaxGasPrice();
    result = result * PRIME + ($maxGasPrice == null ? 43 : $maxGasPrice.hashCode());
    final java.lang.Object $principalContractAdminName = this.getPrincipalContractAdminName();
    result = result * PRIME + ($principalContractAdminName == null ? 43 : $principalContractAdminName.hashCode());
    final java.lang.Object $principalContractAdminAddress = this.getPrincipalContractAdminAddress();
    result = result * PRIME + ($principalContractAdminAddress == null ? 43 : $principalContractAdminAddress.hashCode());
    final java.lang.Object $defaultPrincipalAccount = this.getDefaultPrincipalAccount();
    result = result * PRIME + ($defaultPrincipalAccount == null ? 43 : $defaultPrincipalAccount.hashCode());
    final java.lang.Object $defaultOverviewAccounts = this.getDefaultOverviewAccounts();
    result = result * PRIME + ($defaultOverviewAccounts == null ? 43 : $defaultOverviewAccounts.hashCode());
    final java.lang.Object $initialFunds = this.getInitialFunds();
    result = result * PRIME + ($initialFunds == null ? 43 : $initialFunds.hashCode());
    final java.lang.Object $userPreferences = this.getUserPreferences();
    result = result * PRIME + ($userPreferences == null ? 43 : $userPreferences.hashCode());
    final java.lang.Object $defaultContractsToDisplay = this.getDefaultContractsToDisplay();
    result = result * PRIME + ($defaultContractsToDisplay == null ? 43 : $defaultContractsToDisplay.hashCode());
    final java.lang.Object $contractAbi = this.getContractAbi();
    result = result * PRIME + ($contractAbi == null ? 43 : $contractAbi.hashCode());
    final java.lang.Object $contractBin = this.getContractBin();
    result = result * PRIME + ($contractBin == null ? 43 : $contractBin.hashCode());
    return result;
  }

  @java.lang.SuppressWarnings("all")
  public GlobalSettings() {
  }
}
