/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.ethereum.wallet.rest;

import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.addon.ethereum.wallet.ext.kudos.model.KudosTransaction;
import org.exoplatform.addon.ethereum.wallet.service.WalletKudosService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.json.JSONArray;
import org.json.JSONObject;

@Path(value="/wallet/api/kudos")
public class WalletKudosREST
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(WalletKudosREST.class);
    private WalletKudosService extendedWalletService;

    public WalletKudosREST(WalletKudosService extendedWalletService) {
        this.extendedWalletService = extendedWalletService;
    }

    @Path(value="getKudosBudget")
    @GET
    @RolesAllowed(value={"administrators"})
    public Response getKudosBudget() {
        return Response.ok((Object)String.valueOf(this.extendedWalletService.getKudosBudget())).build();
    }

    @Path(value="getKudosContract")
    @GET
    @RolesAllowed(value={"administrators"})
    public Response getKudosContract() {
        return Response.ok((Object)String.valueOf(this.extendedWalletService.getKudosContract())).build();
    }

    @POST
    @Path(value="saveKudosTotalBudget")
    @RolesAllowed(value={"administrators"})
    public Response saveKudosTotalBudget(@FormParam(value="budget") double budget) {
        this.extendedWalletService.saveKudosTotalBudget(budget);
        return Response.ok().build();
    }

    @POST
    @Path(value="saveKudosContract")
    @RolesAllowed(value={"administrators"})
    public Response saveKudosContract(@FormParam(value="kudosContract") String kudosContractAddress) {
        this.extendedWalletService.saveKudosContract(kudosContractAddress);
        return Response.ok().build();
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="getPeriodTransactions")
    @RolesAllowed(value={"users"})
    public Response getPeriodTransactions(@QueryParam(value="networkId") long networkId, @QueryParam(value="periodType") String periodType, @QueryParam(value="startDateInSeconds") long startDateInSeconds) {
        if (networkId == 0L) {
            LOG.warn("Bad request sent to server with empty networkId {}", new Object[]{networkId});
            return Response.status((int)400).build();
        }
        if (StringUtils.isBlank((String)periodType)) {
            LOG.warn("Bad request sent to server with empty periodType {}", new Object[]{periodType});
            return Response.status((int)400).build();
        }
        if (startDateInSeconds == 0L) {
            LOG.warn("Bad request sent to server with empty startDateInSeconds {}", new Object[]{startDateInSeconds});
            return Response.status((int)400).build();
        }
        List<JSONObject> periodTransactions = this.extendedWalletService.getPeriodTransactions(networkId, periodType, startDateInSeconds);
        JSONArray array = new JSONArray(periodTransactions);
        return Response.ok((Object)array.toString()).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="savePeriodKudosTransactions")
    @RolesAllowed(value={"users"})
    public Response savePeriodKudosTransactions(List<KudosTransaction> kudosTransactions) {
        if (kudosTransactions == null || kudosTransactions.isEmpty()) {
            LOG.warn("Bad request sent to server with empty transactions to save: {}", new Object[]{kudosTransactions});
            return Response.status((int)400).build();
        }
        try {
            for (KudosTransaction kudosTransaction : kudosTransactions) {
                this.extendedWalletService.savePeriodKudosTransaction(kudosTransaction);
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Error saving transaction", (Throwable)e);
            return Response.serverError().build();
        }
        return Response.ok().build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="savePeriodKudosTransaction")
    @RolesAllowed(value={"users"})
    public Response savePeriodKudosTransaction(KudosTransaction kudosTransaction) {
        if (kudosTransaction == null) {
            LOG.warn("Bad request sent to server with empty transaction to save: {}", new Object[]{kudosTransaction});
            return Response.status((int)400).build();
        }
        try {
            this.extendedWalletService.savePeriodKudosTransaction(kudosTransaction);
        }
        catch (Exception e) {
            LOG.warn((Object)"Error saving transaction", (Throwable)e);
            return Response.serverError().build();
        }
        return Response.ok().build();
    }
}

