/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.ethereum.wallet.service;

import java.util.List;
import java.util.stream.Collectors;
import org.exoplatform.addon.ethereum.wallet.dao.GamificationTeamDAO;
import org.exoplatform.addon.ethereum.wallet.ext.gamification.entity.GamificationTeamEntity;
import org.exoplatform.addon.ethereum.wallet.ext.gamification.model.GamificationSettings;
import org.exoplatform.addon.ethereum.wallet.ext.gamification.model.GamificationTeam;
import org.exoplatform.addon.ethereum.wallet.service.utils.GamificationUtils;
import org.exoplatform.addon.ethereum.wallet.service.utils.Utils;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.impl.ResourceBinder;
import org.exoplatform.services.rest.resource.AbstractResourceDescriptor;

public class WalletGamificationService {
    private static final Log LOG = ExoLogger.getLogger(WalletGamificationService.class);
    GamificationTeamDAO gamificationTeamDAO = null;
    private SettingService settingService = null;
    private ResourceBinder restResourceBinder = null;
    private GamificationSettings gamificationSettings = null;
    private AbstractResourceDescriptor gamificationRestResource = null;
    private boolean gamificationRestSearched = false;

    public WalletGamificationService(GamificationTeamDAO gamificationTeamDAO, ResourceBinder restResourceBinder, SettingService settingService) {
        this.gamificationTeamDAO = gamificationTeamDAO;
        this.settingService = settingService;
        this.restResourceBinder = restResourceBinder;
    }

    public GamificationSettings getSettings() throws Exception {
        if (this.gamificationRestResource == null && !this.gamificationRestSearched) {
            try {
                List resources = this.restResourceBinder.getResources();
                this.gamificationRestResource = resources.stream().map(resource -> (AbstractResourceDescriptor)resource.getObjectModel()).filter(resource -> resource.getPathValue() != null && resource.getPathValue().getPath() != null && resource.getPathValue().getPath().contains("gamification/api")).findFirst().get();
            }
            catch (Exception e) {
                LOG.warn((Object)"Error getting gamification REST resource", (Throwable)e);
            }
            this.gamificationRestSearched = true;
        }
        if (this.gamificationRestResource != null) {
            SettingValue value;
            if (this.gamificationSettings == null && (value = this.settingService.get(Utils.EXT_WALLET_CONTEXT, Utils.EXT_WALLET_SCOPE, "GAMIFICATION_SETTINGS")) != null && value.getValue() != null) {
                this.gamificationSettings = value == null || value.getValue() == null ? this.gamificationSettings : GamificationSettings.fromString(value.getValue().toString());
            }
            return this.gamificationSettings;
        }
        return null;
    }

    public GamificationSettings saveSettings(GamificationSettings gamificationSettings) {
        if (gamificationSettings == null) {
            throw new IllegalArgumentException("settings are empty");
        }
        this.settingService.set(Utils.EXT_WALLET_CONTEXT, Utils.EXT_WALLET_SCOPE, "GAMIFICATION_SETTINGS", SettingValue.create((String)gamificationSettings.toStringToStore()));
        this.gamificationSettings = null;
        return gamificationSettings;
    }

    public List<GamificationTeam> getTeams() {
        List teamEntities = this.gamificationTeamDAO.findAll();
        return teamEntities.stream().map(teamEntity -> GamificationUtils.toDTO(teamEntity)).collect(Collectors.toList());
    }

    public GamificationTeam saveTeam(GamificationTeam gamificationTeam) {
        if (gamificationTeam == null) {
            throw new IllegalArgumentException("Empty team to save");
        }
        GamificationTeamEntity teamEntity = GamificationUtils.fromDTO(gamificationTeam);
        teamEntity = teamEntity.getId() == null || teamEntity.getId() == 0L ? (GamificationTeamEntity)this.gamificationTeamDAO.create(teamEntity) : (GamificationTeamEntity)this.gamificationTeamDAO.update(teamEntity);
        return GamificationUtils.toDTO((GamificationTeamEntity)this.gamificationTeamDAO.find(teamEntity.getId()));
    }

    public GamificationTeam removeTeam(Long id) {
        if (id == null || id == 0L) {
            throw new IllegalArgumentException("Team id is required");
        }
        GamificationTeamEntity entity = (GamificationTeamEntity)this.gamificationTeamDAO.find(id);
        if (entity != null) {
            this.gamificationTeamDAO.delete(entity);
        }
        return GamificationUtils.toDTO(entity);
    }
}

