/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.ethereum.wallet.service;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.net.URI;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.addon.ethereum.wallet.model.GlobalSettings;
import org.exoplatform.addon.ethereum.wallet.service.EthereumWalletService;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.Web3jService;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.DefaultBlockParameterNumber;
import org.web3j.protocol.core.methods.response.EthGetTransactionReceipt;
import org.web3j.protocol.core.methods.response.Transaction;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.protocol.websocket.WebSocketClient;
import org.web3j.protocol.websocket.WebSocketListener;
import org.web3j.protocol.websocket.WebSocketService;
import rx.Subscription;

public class EthereumClientConnector
implements Startable {
    private static final String ERROR_CLOSING_WEB_SOCKET_MESSAGE = "Error closing web socket";
    private static final Log LOG = ExoLogger.getLogger(EthereumClientConnector.class);
    private ExoContainer container;
    private EthereumWalletService ethereumWalletService;
    private ListenerService listenerService;
    private GlobalSettings globalSettings = null;
    private Web3j web3j = null;
    private WebSocketClient webSocketClient = null;
    private WebSocketService web3jService = null;
    private Subscription transactionSubscription = null;
    private Queue<Transaction> queue = new ConcurrentLinkedQueue<Transaction>();
    private ScheduledExecutorService scheduledExecutorService = null;
    private long lastWatchedBlockNumber = 0L;
    private boolean initializing = false;

    public EthereumClientConnector(EthereumWalletService ethereumWalletService, ListenerService listenerService, ExoContainer container) {
        this.ethereumWalletService = ethereumWalletService;
        this.listenerService = listenerService;
        this.container = container;
    }

    public void start() {
        RequestLifeCycle.begin((ExoContainer)this.container);
        try {
            GlobalSettings storedSettings = this.ethereumWalletService.getSettings();
            if (storedSettings != null && StringUtils.isNotBlank((CharSequence)storedSettings.getWebsocketProviderURL())) {
                this.globalSettings = storedSettings;
                this.lastWatchedBlockNumber = this.ethereumWalletService.getLastWatchedBlockNumber(storedSettings.getDefaultNetworkId());
            }
        }
        catch (Throwable e) {
            LOG.error((Object)"Error retrieving global settings", e);
        }
        finally {
            RequestLifeCycle.end();
        }
        ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("Ethereum-websocket-connector-%d").build();
        this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(namedThreadFactory);
        this.scheduledExecutorService.scheduleWithFixedDelay(() -> {
            try {
                if (StringUtils.isBlank((CharSequence)this.getWebsocketProviderURL())) {
                    this.closeConnection();
                    return;
                }
                if (!this.initWeb3Connection()) {
                    LOG.info((Object)"Web3 connection initialization in progress, skip transaction processing until it's initialized");
                    return;
                }
            }
            catch (Throwable e) {
                LOG.warn("Error while checking connection status to Etherreum Websocket endpoint: {}", new Object[]{e.getMessage()});
                this.closeConnection();
                return;
            }
            Transaction transaction = this.queue.poll();
            while (transaction != null) {
                try {
                    this.listenerService.broadcast("exo.addon.wallet.transaction.loaded", (Object)transaction, null);
                    if (transaction.getBlockNumber() != null && transaction.getBlockNumber().longValue() > this.lastWatchedBlockNumber) {
                        this.lastWatchedBlockNumber = transaction.getBlockNumber().longValue();
                    }
                }
                catch (Throwable e) {
                    LOG.warn((Object)"Error while handling transaction", e);
                }
                transaction = this.queue.poll();
            }
            try {
                this.listenerService.broadcast("exo.addon.wallet.block.loaded", (Object)this.lastWatchedBlockNumber, null);
            }
            catch (Throwable e) {
                LOG.warn((Object)"Error while broadcasting last watched block number event", e);
            }
        }, 10L, 10L, TimeUnit.SECONDS);
    }

    public void stop() {
        this.scheduledExecutorService.shutdown();
        this.closeConnection();
    }

    public void startListeninigToTransactions() {
        if (this.lastWatchedBlockNumber == 0L) {
            LOG.info((Object)"Initiate subscription to Ethereum transaction events starting from latest block");
            this.transactionSubscription = this.web3j.transactionObservable().subscribe(tx -> this.queue.add((Transaction)tx));
        } else {
            LOG.info("Initiate subscription to Ethereum transaction events starting from block {}", new Object[]{this.lastWatchedBlockNumber});
            DefaultBlockParameterNumber startBlock = new DefaultBlockParameterNumber(this.lastWatchedBlockNumber);
            this.transactionSubscription = this.web3j.catchUpToLatestAndSubscribeToNewTransactionsObservable((DefaultBlockParameter)startBlock).subscribe(tx -> this.queue.add((Transaction)tx));
        }
    }

    public void stopListeninigToTransactions() {
        if (this.transactionSubscription != null) {
            LOG.info("unsubscribe to Ethereum transaction listener on url {}", new Object[]{this.getWebsocketProviderURL()});
            try {
                this.transactionSubscription.unsubscribe();
            }
            catch (Throwable e) {
                LOG.warn("Error occurred while unsubscribing to Ethereum transaction events: {}", new Object[]{e.getMessage()});
            }
            this.transactionSubscription = null;
        }
    }

    public TransactionReceipt getTransactionReceipt(String transactionHash) throws InterruptedException, ExecutionException {
        EthGetTransactionReceipt ethGetTransactionReceipt = (EthGetTransactionReceipt)this.web3j.ethGetTransactionReceipt(transactionHash).sendAsync().get();
        if (ethGetTransactionReceipt != null && ethGetTransactionReceipt.getResult() != null) {
            return (TransactionReceipt)ethGetTransactionReceipt.getResult();
        }
        return null;
    }

    public String getWebsocketProviderURL() {
        GlobalSettings settings = this.ethereumWalletService.getSettings();
        return settings == null ? null : settings.getWebsocketProviderURL();
    }

    public void changeSettings(GlobalSettings newGlobalSettings) {
        if (newGlobalSettings == null) {
            throw new IllegalArgumentException("GlobalSettings argument is mandatory");
        }
        if (this.globalSettings == null) {
            return;
        }
        GlobalSettings oldGlobalSettings = this.globalSettings;
        this.globalSettings = newGlobalSettings;
        if (newGlobalSettings.getDefaultNetworkId() != null && !newGlobalSettings.getDefaultNetworkId().equals(oldGlobalSettings.getDefaultNetworkId())) {
            this.lastWatchedBlockNumber = this.ethereumWalletService.getLastWatchedBlockNumber(newGlobalSettings.getDefaultNetworkId());
        }
        if (StringUtils.isBlank((CharSequence)newGlobalSettings.getWebsocketProviderURL()) || !StringUtils.equals((CharSequence)newGlobalSettings.getWebsocketProviderURL(), (CharSequence)oldGlobalSettings.getWebsocketProviderURL())) {
            this.closeConnection();
        }
    }

    public long getLastWatchedBlockNumber() {
        return this.lastWatchedBlockNumber;
    }

    public void setLastWatchedBlockNumber(long lastWatchedBlockNumber) {
        this.lastWatchedBlockNumber = lastWatchedBlockNumber;
    }

    private void closeConnection() {
        this.stopListeninigToTransactions();
        if (this.web3j != null) {
            block8: {
                try {
                    this.web3j.shutdown();
                }
                catch (Throwable e) {
                    LOG.warn("Error closing old web3j connection: {}", new Object[]{e.getMessage()});
                    if (this.web3jService != null && this.webSocketClient != null && this.webSocketClient.isOpen()) {
                        try {
                            this.web3jService.close();
                        }
                        catch (Throwable e1) {
                            LOG.warn("Error closing old websocket connection: {}", new Object[]{e1.getMessage()});
                        }
                    }
                    if (this.webSocketClient == null || !this.webSocketClient.isOpen()) break block8;
                    try {
                        this.webSocketClient.close();
                    }
                    catch (Throwable e1) {
                        LOG.warn("Error closing old websocket connection: {}", new Object[]{e1.getMessage()});
                    }
                }
            }
            this.web3j = null;
            this.web3jService = null;
            this.webSocketClient = null;
        }
    }

    private boolean initWeb3Connection() {
        if (this.initializing) {
            return false;
        }
        this.initializing = true;
        try {
            if (this.getWebsocketProviderURL() == null) {
                throw new IllegalStateException("No configured URL for Ethereum Websocket connection");
            }
            if (this.web3j == null || this.webSocketClient == null || this.webSocketClient.isClosed() || this.transactionSubscription == null || this.transactionSubscription.isUnsubscribed()) {
                if (this.getWebsocketProviderURL().startsWith("ws:") || this.getWebsocketProviderURL().startsWith("wss:")) {
                    this.stopListeninigToTransactions();
                    this.establishConnection();
                    this.startListeninigToTransactions();
                } else {
                    throw new IllegalStateException("Bad format for configured URL " + this.getWebsocketProviderURL() + " for Ethereum Websocket connection");
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.initializing = false;
        }
    }

    private void establishConnection() {
        this.closeConnection();
        LOG.info("Connecting to Ethereum network endpoint {}", new Object[]{this.getWebsocketProviderURL()});
        this.web3jService = this.testConnection();
        this.web3j = Web3j.build((Web3jService)this.web3jService);
        LOG.info("Connection established to Ethereum network endpoint {}", new Object[]{this.getWebsocketProviderURL()});
    }

    private WebSocketService testConnection() {
        try {
            this.webSocketClient = new WebSocketClient(new URI(this.getWebsocketProviderURL()));
            this.webSocketClient.setConnectionLostTimeout(10);
            this.web3jService = new WebSocketService(this.webSocketClient, true);
            this.webSocketClient.setListener(new WebSocketListener(){

                public void onMessage(String message) throws IOException {
                    LOG.debug((Object)"A new message is received in testConnection method");
                }

                public void onError(Exception e) {
                    LOG.warn((Object)EthereumClientConnector.this.getConnectionFailedMessage());
                }

                public void onClose() {
                    LOG.debug((Object)"Websocket connection closed for testConnection method");
                }
            });
            this.web3jService.connect();
            Thread.sleep(10000L);
            if (!this.webSocketClient.isOpen()) {
                this.closeConnectionAndThrowError(null);
            }
        }
        catch (Throwable e) {
            this.closeConnectionAndThrowError(e);
        }
        return this.web3jService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeConnectionAndThrowError(Throwable e) {
        if (this.web3j != null) {
            try {
                this.web3j.shutdown();
            }
            catch (Exception e1) {
                LOG.debug((Object)ERROR_CLOSING_WEB_SOCKET_MESSAGE, (Throwable)e1);
            }
            finally {
                this.web3j = null;
                this.webSocketClient = null;
                this.web3jService = null;
            }
        }
        if (this.web3jService != null) {
            try {
                this.web3jService.close();
            }
            catch (Exception e1) {
                LOG.debug((Object)ERROR_CLOSING_WEB_SOCKET_MESSAGE, (Throwable)e1);
            }
            finally {
                this.web3jService = null;
                this.webSocketClient = null;
            }
        }
        if (this.webSocketClient != null && this.webSocketClient.isOpen()) {
            try {
                this.webSocketClient.close();
            }
            catch (Exception e1) {
                LOG.debug((Object)ERROR_CLOSING_WEB_SOCKET_MESSAGE, (Throwable)e1);
            }
            finally {
                this.web3j = null;
                this.webSocketClient = null;
                this.web3jService = null;
            }
        }
        if (e == null) {
            throw new IllegalStateException(this.getConnectionFailedMessage());
        }
        throw new IllegalStateException(this.getConnectionFailedMessage(), e);
    }

    protected String getConnectionFailedMessage() {
        return "Connection failed to " + this.getWebsocketProviderURL();
    }
}

