/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.ethereum.wallet.listener;

import org.exoplatform.addon.ethereum.wallet.model.GlobalSettings;
import org.exoplatform.addon.ethereum.wallet.service.EthereumWalletService;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;

@Asynchronous
public class EthereumLastWatchedBlockListener
extends Listener<Long, Object> {
    private EthereumWalletService ethereumWalletService;
    private ExoContainer container;
    private long blockNumberToSave = 0L;
    private long networkId = 0L;

    public EthereumLastWatchedBlockListener(ExoContainer container) {
        this.container = container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(Event<Long, Object> event) throws Exception {
        Long blockNumber = (Long)event.getSource();
        if (blockNumber == null) {
            return;
        }
        RequestLifeCycle.begin((ExoContainer)this.container);
        try {
            GlobalSettings globalSettings = this.getEthereumWalletService().getSettings();
            long defaultNetworkId = globalSettings.getDefaultNetworkId();
            if (defaultNetworkId != this.networkId || blockNumber > this.blockNumberToSave) {
                this.networkId = defaultNetworkId;
                if (this.blockNumberToSave > 0L) {
                    this.getEthereumWalletService().saveLastWatchedBlockNumber(defaultNetworkId, this.blockNumberToSave);
                }
                this.blockNumberToSave = blockNumber;
            }
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    public EthereumWalletService getEthereumWalletService() {
        if (this.ethereumWalletService == null) {
            this.ethereumWalletService = (EthereumWalletService)CommonsUtils.getService(EthereumWalletService.class);
        }
        return this.ethereumWalletService;
    }
}

