/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.ethereum.wallet.service;

import org.exoplatform.addon.ethereum.wallet.service.EthereumClientConnector;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;

@Managed
@NameTemplate(value={@Property(key="service", value="ethereum"), @Property(key="view", value="connector")})
@ManagedDescription(value="Ethereum blockchain client connector")
public class EthereumClientConnectorManaged {
    private EthereumClientConnector ethereumClientConnector;

    public EthereumClientConnectorManaged(EthereumClientConnector ethereumClientConnector) {
        this.ethereumClientConnector = ethereumClientConnector;
    }

    @Managed
    @ManagedDescription(value="Get ethereum blockchain connection interruption count")
    public int getConnectionInterruptionCount() {
        return this.ethereumClientConnector.getConnectionInterruptionCount();
    }

    @Managed
    @ManagedDescription(value="Get ethereum blockchain transactions queue size")
    public int getTransactionQueueSize() {
        return this.ethereumClientConnector.getTransactionQueueSize();
    }

    @Managed
    @ManagedDescription(value="Get ethereum blockchain max transactions queue size since startup")
    public int getTransactionQueueMaxSize() {
        return this.ethereumClientConnector.getTransactionQueueMaxSize();
    }

    @Managed
    @ManagedDescription(value="Get last watched block from ethereum blockchain")
    public long getLastWatchedBlockNumber() {
        return this.ethereumClientConnector.getLastWatchedBlockNumber();
    }

    @Managed
    @ManagedDescription(value="Get ethereum blockchain watching start time in minutes")
    public String getWatchingBlockchainStartTime() {
        long watchingBlockchainStartTime = this.ethereumClientConnector.getWatchingBlockchainStartTime();
        return "Since " + (System.currentTimeMillis() - watchingBlockchainStartTime) / 1000L / 60L + " minutes";
    }

    @Managed
    @ManagedDescription(value="Get ethereum blockchain watched transactions")
    public int getWatchedTransactionCount() {
        return this.ethereumClientConnector.getWatchedTransactionCount();
    }

    @Managed
    @ManagedDescription(value="Get ethereum blockchain watching transactions rate per minute")
    public int getWatchingTransactionRatePerMinute() {
        int watchedTransactionCount = this.ethereumClientConnector.getWatchedTransactionCount();
        double diffTime = (double)System.currentTimeMillis() - (double)this.ethereumClientConnector.getWatchingBlockchainStartTime();
        diffTime = diffTime / 1000.0 / 60.0;
        return (int)((double)watchedTransactionCount / diffTime);
    }

    @Managed
    @ManagedDescription(value="Get ethereum blockchain treating transactions rate per minute")
    public int getTreatingTransactionRatePerMinute() {
        int watchedTransactionCount = this.ethereumClientConnector.getWatchedTransactionCount();
        int queueSize = this.ethereumClientConnector.getTransactionQueueSize();
        double diffTime = (double)System.currentTimeMillis() - (double)this.ethereumClientConnector.getWatchingBlockchainStartTime();
        diffTime = diffTime / 1000.0 / 60.0;
        return (int)((double)(watchedTransactionCount - queueSize) / diffTime);
    }

    @Managed
    @ManagedDescription(value="Get ethereum blockchain transactions treatment percentage")
    public String getTransactionTreatmentSpeedPercentage() {
        return this.getTreatingTransactionRatePerMinute() * 100 / this.getWatchingTransactionRatePerMinute() + "%";
    }

    @Managed
    @ManagedDescription(value="Get last block number on startup time")
    public long getLastBlockNumberOnStartupTime() {
        return this.ethereumClientConnector.getLastBlockNumberOnStartupTime();
    }

    @Managed
    @ManagedDescription(value="Get transactions count per block")
    public int getTransactionsCountPerBlock() {
        return this.ethereumClientConnector.getTransactionsCountPerBlock();
    }

    @Managed
    @ManagedDescription(value="Clear all transactions in queue")
    public void clearTransactionQueue() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Managed
    @ManagedDescription(value="Set last watched block on ethereum blockchain")
    public void setLastWatchedBlockNumber(long lastWatchedBlockNumber) {
        throw new UnsupportedOperationException("Not yet implemented");
    }
}

