/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.ethereum.wallet.listener;

import org.apache.commons.lang.StringUtils;
import org.exoplatform.addon.ethereum.wallet.model.ContractDetail;
import org.exoplatform.addon.ethereum.wallet.model.TransactionDetail;
import org.exoplatform.addon.ethereum.wallet.model.TransactionStatus;
import org.exoplatform.addon.ethereum.wallet.model.Wallet;
import org.exoplatform.addon.ethereum.wallet.service.EthereumWalletAccountService;
import org.exoplatform.addon.ethereum.wallet.service.EthereumWalletContractService;
import org.exoplatform.addon.ethereum.wallet.service.EthereumWalletService;
import org.exoplatform.addon.ethereum.wallet.service.EthereumWalletTransactionService;
import org.exoplatform.addon.ethereum.wallet.service.utils.Utils;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.json.JSONObject;

@Asynchronous
public class TransactionMinedListener
extends Listener<Object, JSONObject> {
    private ExoContainer container;
    private EthereumWalletService walletService;
    private EthereumWalletTransactionService transactionService;
    private EthereumWalletAccountService walletAccountService;
    private EthereumWalletContractService contractService;

    public TransactionMinedListener(ExoContainer container) {
        this.container = container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(Event<Object, JSONObject> event) throws Exception {
        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
        RequestLifeCycle.begin((ExoContainer)this.container);
        try {
            String transactionHash = ((JSONObject)event.getData()).getString("hash");
            if (StringUtils.isBlank((String)transactionHash)) {
                return;
            }
            TransactionDetail transactionDetail = this.getTransactionService().getTransactionByHash(transactionHash, false);
            Wallet senderWallet = null;
            String senderAddress = transactionDetail.getFrom();
            String principalContractAdminAddress = this.getWalletService().getSettings().getPrincipalContractAdminAddress();
            if (StringUtils.isNotBlank((String)senderAddress) && (senderWallet = this.getWalletAccountService().getWalletByAddress(senderAddress)) == null) {
                senderWallet = new Wallet();
                senderWallet.setAddress(senderAddress);
                if (StringUtils.isNotBlank((String)principalContractAdminAddress) && StringUtils.equalsIgnoreCase((String)principalContractAdminAddress, (String)senderAddress)) {
                    senderWallet.setName("Admin");
                } else {
                    senderWallet.setName(senderAddress);
                }
            }
            Wallet receiverWallet = null;
            String receiverAddress = transactionDetail.getTo();
            if (StringUtils.isNotBlank((String)receiverAddress) && (receiverWallet = this.getWalletAccountService().getWalletByAddress(receiverAddress)) == null) {
                receiverWallet = new Wallet();
                receiverWallet.setAddress(receiverAddress);
                if (StringUtils.isNotBlank((String)principalContractAdminAddress) && StringUtils.equalsIgnoreCase((String)principalContractAdminAddress, (String)receiverAddress)) {
                    receiverWallet.setName("Admin");
                } else {
                    receiverWallet.setName(receiverAddress);
                }
            }
            if (senderWallet != null && senderWallet.getTechnicalId() > 0L) {
                this.sendNotification(transactionDetail, TransactionStatus.SENDER, senderWallet, receiverWallet);
            }
            if (receiverWallet != null && receiverWallet.getTechnicalId() > 0L) {
                this.sendNotification(transactionDetail, TransactionStatus.RECEIVER, senderWallet, receiverWallet);
            }
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    private void sendNotification(TransactionDetail transactionDetail, TransactionStatus transactionStatus, Wallet senderWallet, Wallet receiverWallet) {
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        ctx.append(Utils.HASH_PARAMETER, (Object)transactionDetail.getHash());
        ctx.append(Utils.SENDER_ACCOUNT_DETAIL_PARAMETER, (Object)senderWallet);
        ctx.append(Utils.RECEIVER_ACCOUNT_DETAIL_PARAMETER, (Object)receiverWallet);
        ctx.append(Utils.MESSAGE_PARAMETER, (Object)(transactionDetail.getMessage() == null ? "" : transactionDetail.getMessage()));
        if (StringUtils.isBlank((String)transactionDetail.getContractAddress())) {
            ctx.append(Utils.SYMBOL_PARAMETER, (Object)"ether");
            ctx.append(Utils.CONTRACT_ADDRESS_PARAMETER, (Object)"");
            ctx.append(Utils.AMOUNT_PARAMETER, (Object)(transactionDetail.getValue() / Math.pow(10.0, 18.0)));
        } else {
            ContractDetail contractDetails = this.getContractService().getContractDetail(transactionDetail.getContractAddress(), transactionDetail.getNetworkId());
            ctx.append(Utils.SYMBOL_PARAMETER, (Object)contractDetails.getSymbol());
            ctx.append(Utils.CONTRACT_ADDRESS_PARAMETER, (Object)contractDetails.getAddress());
            ctx.append(Utils.AMOUNT_PARAMETER, (Object)transactionDetail.getContractAmount());
        }
        ctx.getNotificationExecutor().with(ctx.makeCommand(PluginKey.key((String)transactionStatus.getNotificationId()))).execute(ctx);
    }

    private EthereumWalletService getWalletService() {
        if (this.walletService == null) {
            this.walletService = (EthereumWalletService)CommonsUtils.getService(EthereumWalletService.class);
        }
        return this.walletService;
    }

    private EthereumWalletTransactionService getTransactionService() {
        if (this.transactionService == null) {
            this.transactionService = (EthereumWalletTransactionService)CommonsUtils.getService(EthereumWalletTransactionService.class);
        }
        return this.transactionService;
    }

    private EthereumWalletAccountService getWalletAccountService() {
        if (this.walletAccountService == null) {
            this.walletAccountService = (EthereumWalletAccountService)CommonsUtils.getService(EthereumWalletAccountService.class);
        }
        return this.walletAccountService;
    }

    private EthereumWalletContractService getContractService() {
        if (this.contractService == null) {
            this.contractService = (EthereumWalletContractService)CommonsUtils.getService(EthereumWalletContractService.class);
        }
        return this.contractService;
    }
}

