/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.ethereum.wallet.migration;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.addon.ethereum.wallet.contract.ERTTokenV1;
import org.exoplatform.addon.ethereum.wallet.fork.ContractUtils;
import org.exoplatform.addon.ethereum.wallet.fork.EventEncoder;
import org.exoplatform.addon.ethereum.wallet.model.ContractDetail;
import org.exoplatform.addon.ethereum.wallet.model.GlobalSettings;
import org.exoplatform.addon.ethereum.wallet.model.TransactionDetail;
import org.exoplatform.addon.ethereum.wallet.model.Wallet;
import org.exoplatform.addon.ethereum.wallet.service.EthereumClientConnector;
import org.exoplatform.addon.ethereum.wallet.service.EthereumWalletAccountService;
import org.exoplatform.addon.ethereum.wallet.service.EthereumWalletContractService;
import org.exoplatform.addon.ethereum.wallet.service.EthereumWalletService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.web3j.abi.EventValues;
import org.web3j.abi.datatypes.Type;
import org.web3j.protocol.core.methods.response.EthBlock;
import org.web3j.protocol.core.methods.response.Transaction;
import org.web3j.protocol.core.methods.response.TransactionReceipt;

public class EthereumTransactionDecoder {
    private static final Log LOG = ExoLogger.getLogger(EthereumTransactionDecoder.class);
    private static final String TRANSFER_SIGNATURE = EventEncoder.encode(ERTTokenV1.TRANSFER_EVENT);
    private static final String APPROVAL_SIGNATURE = EventEncoder.encode(ERTTokenV1.APPROVAL_EVENT);
    private static final String ADDEDADMIN_METHOD_SIGNATURE = EventEncoder.encode(ERTTokenV1.ADDEDADMIN_EVENT);
    private static final String REMOVEDADMIN_SIGNATURE = EventEncoder.encode(ERTTokenV1.REMOVEDADMIN_EVENT);
    private static final String APPROVEDACCOUNT_SIGNATURE = EventEncoder.encode(ERTTokenV1.APPROVEDACCOUNT_EVENT);
    private static final String DISAPPROVEDACCOUNT_SIGNATURE = EventEncoder.encode(ERTTokenV1.DISAPPROVEDACCOUNT_EVENT);
    private static final String CONTRACTPAUSED_SIGNATURE = EventEncoder.encode(ERTTokenV1.CONTRACTPAUSED_EVENT);
    private static final String CONTRACTUNPAUSED_SIGNATURE = EventEncoder.encode(ERTTokenV1.CONTRACTUNPAUSED_EVENT);
    private static final String DEPOSITRECEIVED_SIGNATURE = EventEncoder.encode(ERTTokenV1.DEPOSITRECEIVED_EVENT);
    private static final String TOKENPRICECHANGED_SIGNATURE = EventEncoder.encode(ERTTokenV1.TOKENPRICECHANGED_EVENT);
    private static final String TRANSFEROWNERSHIP_SIGNATURE = EventEncoder.encode(ERTTokenV1.TRANSFEROWNERSHIP_EVENT);
    private static final Map<String, String> CONTRACT_METHODS_BY_SIG = new HashMap<String, String>();
    private EthereumWalletContractService contractService;
    private EthereumWalletAccountService accountService;
    private EthereumWalletService ethereumWalletService;
    private EthereumClientConnector ethereumClientConnector;

    public EthereumTransactionDecoder(EthereumWalletService ethereumWalletService, EthereumClientConnector ethereumClientConnector, EthereumWalletAccountService accountService, EthereumWalletContractService contractService) {
        this.ethereumWalletService = ethereumWalletService;
        this.ethereumClientConnector = ethereumClientConnector;
        this.contractService = contractService;
        this.accountService = accountService;
    }

    public TransactionDetail computeTransactionDetail(TransactionDetail transactionDetail) throws InterruptedException, ExecutionException {
        GlobalSettings settings = this.ethereumWalletService.getSettings();
        long networkId = settings.getDefaultNetworkId();
        transactionDetail.setNetworkId(networkId);
        String hash = transactionDetail.getHash();
        Transaction transaction = this.ethereumClientConnector.getTransaction(hash);
        EthBlock.Block block = this.ethereumClientConnector.getBlock(transaction.getBlockHash());
        transactionDetail.setTimestamp(block.getTimestamp().longValue());
        String senderAddress = transaction.getFrom();
        transactionDetail.setFrom(senderAddress);
        transactionDetail.setValue(transaction.getValue() == null ? 0.0 : (double)transaction.getValue().longValue());
        TransactionReceipt transactionReceipt = this.ethereumClientConnector.getTransactionReceipt(hash);
        transactionDetail.setPending(transactionReceipt == null);
        transactionDetail.setSucceeded(transactionReceipt != null && transactionReceipt.isStatusOK());
        String receiverAddress = transaction.getTo();
        transactionDetail.setTo(receiverAddress);
        Wallet receiver = null;
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{receiverAddress})) {
            receiver = this.accountService.getWalletByAddress(receiverAddress);
        }
        ContractDetail contractDetail = null;
        if (receiver == null) {
            contractDetail = this.contractService.getContractDetail(receiverAddress, networkId);
            if (contractDetail == null) {
                LOG.warn("Can't find contract with address {}", new Object[]{receiverAddress});
            } else {
                transactionDetail.setContractAddress(contractDetail.getAddress());
                EthereumTransactionDecoder.computeTransactionDetail(transactionDetail, transactionReceipt);
            }
        } else {
            transactionDetail.setTo(receiverAddress);
        }
        return transactionDetail;
    }

    public static void computeTransactionDetail(TransactionDetail transactionDetail, TransactionReceipt transactionReceipt) {
        List logs = transactionReceipt.getLogs();
        String hash = transactionDetail.getHash();
        if (logs == null || logs.isEmpty()) {
            if (transactionDetail.getValue() == 0.0) {
                LOG.debug("Retrieving information from blockchain for transaction {} with NO LOGS, set it as failed", new Object[]{hash});
                transactionDetail.setSucceeded(false);
            }
        } else {
            LOG.debug("Retrieving information from blockchain for transaction {} with {} LOGS", new Object[]{hash, logs.size()});
            transactionDetail.setSucceeded(true);
            boolean transactionLogTreated = false;
            for (int i = 0; i < logs.size(); ++i) {
                BigInteger amount;
                EventValues parameters;
                org.web3j.protocol.core.methods.response.Log log = (org.web3j.protocol.core.methods.response.Log)logs.get(i);
                List topics = log.getTopics();
                if (topics == null || topics.isEmpty()) {
                    LOG.warn("Migrating transaction {} with NO topics", new Object[]{hash});
                    transactionDetail.setSucceeded(false);
                    continue;
                }
                String topic = (String)topics.get(0);
                LOG.debug("Migrating transaction {} with {} topics", new Object[]{hash, topics.size()});
                String methodName = CONTRACT_METHODS_BY_SIG.get(topic);
                transactionDetail.setContractMethodName(methodName);
                if (StringUtils.equals((CharSequence)methodName, (CharSequence)"transfer")) {
                    transactionLogTreated = true;
                    parameters = ContractUtils.staticExtractEventParameters(ERTTokenV1.TRANSFER_EVENT, log);
                    transactionDetail.setFrom(((Type)parameters.getIndexedValues().get(0)).getValue().toString());
                    transactionDetail.setTo(((Type)parameters.getIndexedValues().get(1)).getValue().toString());
                    amount = (BigInteger)((Type)parameters.getNonIndexedValues().get(0)).getValue();
                    transactionDetail.setContractAmount(amount.doubleValue());
                    if (StringUtils.equals((CharSequence)transactionReceipt.getFrom(), (CharSequence)transactionDetail.getFrom())) continue;
                    transactionDetail.setBy(transactionReceipt.getFrom());
                    transactionDetail.setContractMethodName("transferFrom");
                    continue;
                }
                if (StringUtils.equals((CharSequence)methodName, (CharSequence)"approve")) {
                    transactionLogTreated = true;
                    parameters = ContractUtils.staticExtractEventParameters(ERTTokenV1.APPROVAL_EVENT, log);
                    transactionDetail.setFrom(((Type)parameters.getIndexedValues().get(0)).getValue().toString());
                    transactionDetail.setTo(((Type)parameters.getIndexedValues().get(1)).getValue().toString());
                    amount = (BigInteger)((Type)parameters.getNonIndexedValues().get(0)).getValue();
                    transactionDetail.setContractAmount(amount.doubleValue());
                    continue;
                }
                if (StringUtils.equals((CharSequence)methodName, (CharSequence)"approveAccount")) {
                    if (logs.size() > 1) continue;
                    transactionLogTreated = true;
                    parameters = ContractUtils.staticExtractEventParameters(ERTTokenV1.APPROVEDACCOUNT_EVENT, log);
                    transactionDetail.setFrom(transactionReceipt.getFrom());
                    transactionDetail.setTo(((Type)parameters.getNonIndexedValues().get(0)).getValue().toString());
                    transactionDetail.setAdminOperation(true);
                    continue;
                }
                if (StringUtils.equals((CharSequence)methodName, (CharSequence)"disapproveAccount")) {
                    transactionLogTreated = true;
                    parameters = ContractUtils.staticExtractEventParameters(ERTTokenV1.DISAPPROVEDACCOUNT_EVENT, log);
                    transactionDetail.setFrom(transactionReceipt.getFrom());
                    transactionDetail.setTo(((Type)parameters.getNonIndexedValues().get(0)).getValue().toString());
                    transactionDetail.setAdminOperation(true);
                    continue;
                }
                if (StringUtils.equals((CharSequence)methodName, (CharSequence)"addAdmin")) {
                    transactionLogTreated = true;
                    parameters = ContractUtils.staticExtractEventParameters(ERTTokenV1.ADDEDADMIN_EVENT, log);
                    transactionDetail.setFrom(transactionReceipt.getFrom());
                    transactionDetail.setTo(((Type)parameters.getNonIndexedValues().get(0)).getValue().toString());
                    transactionDetail.setAdminOperation(true);
                    continue;
                }
                if (StringUtils.equals((CharSequence)methodName, (CharSequence)"removeAdmin")) {
                    transactionLogTreated = true;
                    parameters = ContractUtils.staticExtractEventParameters(ERTTokenV1.REMOVEDADMIN_EVENT, log);
                    transactionDetail.setFrom(transactionReceipt.getFrom());
                    transactionDetail.setTo(((Type)parameters.getNonIndexedValues().get(0)).getValue().toString());
                    transactionDetail.setAdminOperation(true);
                    continue;
                }
                if (transactionLogTreated || i + 1 != logs.size()) continue;
                LOG.info("Can't find contract method name of transaction {}", new Object[]{transactionDetail});
            }
        }
    }

    static {
        CONTRACT_METHODS_BY_SIG.put(TRANSFER_SIGNATURE, "transfer");
        CONTRACT_METHODS_BY_SIG.put(APPROVAL_SIGNATURE, "approve");
        CONTRACT_METHODS_BY_SIG.put(ADDEDADMIN_METHOD_SIGNATURE, "addAdmin");
        CONTRACT_METHODS_BY_SIG.put(REMOVEDADMIN_SIGNATURE, "removeAdmin");
        CONTRACT_METHODS_BY_SIG.put(APPROVEDACCOUNT_SIGNATURE, "approveAccount");
        CONTRACT_METHODS_BY_SIG.put(DISAPPROVEDACCOUNT_SIGNATURE, "disapproveAccount");
        CONTRACT_METHODS_BY_SIG.put(CONTRACTPAUSED_SIGNATURE, "pause");
        CONTRACT_METHODS_BY_SIG.put(CONTRACTUNPAUSED_SIGNATURE, "unPause");
        CONTRACT_METHODS_BY_SIG.put(DEPOSITRECEIVED_SIGNATURE, "depositFunds");
        CONTRACT_METHODS_BY_SIG.put(TOKENPRICECHANGED_SIGNATURE, "setSellPrice");
        CONTRACT_METHODS_BY_SIG.put(TRANSFEROWNERSHIP_SIGNATURE, "transferOwnership");
    }
}

