/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.ethereum.wallet.rest;

import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.addon.ethereum.wallet.model.FundsRequest;
import org.exoplatform.addon.ethereum.wallet.model.Wallet;
import org.exoplatform.addon.ethereum.wallet.model.WalletPreferences;
import org.exoplatform.addon.ethereum.wallet.model.WalletType;
import org.exoplatform.addon.ethereum.wallet.service.EthereumWalletAccountService;
import org.exoplatform.addon.ethereum.wallet.service.EthereumWalletService;
import org.exoplatform.addon.ethereum.wallet.service.utils.Utils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="/wallet/api/account")
@RolesAllowed(value={"users"})
public class EthereumWalletAccountREST
implements ResourceContainer {
    private static final String EMPTY_ADDRESS_ERROR = "Bad request sent to server with empty address {}";
    private static final Log LOG = ExoLogger.getLogger(EthereumWalletAccountREST.class);
    private EthereumWalletService ethereumWalletService;
    private EthereumWalletAccountService accountService;

    public EthereumWalletAccountREST(EthereumWalletService ethereumWalletService, EthereumWalletAccountService accountService) {
        this.ethereumWalletService = ethereumWalletService;
        this.accountService = accountService;
    }

    @Path(value="detailsById")
    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    public Response getWalletByTypeAndID(@QueryParam(value="id") String remoteId, @QueryParam(value="type") String type) {
        if (StringUtils.isBlank((String)remoteId) || StringUtils.isBlank((String)type)) {
            LOG.warn("Bad request sent to server with id '{}' and type '{}'", new Object[]{remoteId, type});
            return Response.status((int)400).build();
        }
        try {
            Wallet wallet = this.accountService.getWallet(type, remoteId);
            if (wallet != null) {
                if (WalletType.isSpace(wallet.getType())) {
                    wallet.setSpaceAdministrator(Utils.isUserSpaceManager(wallet.getId(), Utils.getCurrentUserId()));
                }
                wallet.setPassPhrase(null);
                return Response.ok((Object)wallet).build();
            }
            return Response.ok((Object)"{}").build();
        }
        catch (Exception e) {
            LOG.error("Error getting wallet by id {} and type {}", new Object[]{remoteId, type});
            return Response.serverError().build();
        }
    }

    @Path(value="detailsByAddress")
    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    public Response getWalletByAddress(@QueryParam(value="address") String address) {
        try {
            if (StringUtils.isBlank((String)address)) {
                LOG.warn(EMPTY_ADDRESS_ERROR, new Object[]{address});
                return Response.status((int)400).build();
            }
            Wallet wallet = this.accountService.getWalletByAddress(address);
            if (wallet != null) {
                if (WalletType.isSpace(wallet.getType())) {
                    wallet.setSpaceAdministrator(Utils.isUserSpaceManager(wallet.getId(), Utils.getCurrentUserId()));
                }
                wallet.setPassPhrase(null);
                return Response.ok((Object)wallet).build();
            }
            return Response.ok((Object)"{}").build();
        }
        catch (Exception e) {
            LOG.error("Error getting wallet by address {}", new Object[]{address});
            return Response.serverError().build();
        }
    }

    @Path(value="remove")
    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"administrators"})
    public Response removeAccountByAddress(@QueryParam(value="address") String address) {
        if (StringUtils.isBlank((String)address)) {
            LOG.warn(EMPTY_ADDRESS_ERROR, new Object[]{address});
            return Response.status((int)400).build();
        }
        try {
            this.accountService.removeWalletByAddress(address, Utils.getCurrentUserId());
            return Response.ok().build();
        }
        catch (Exception e) {
            LOG.warn("Can't delete address '{}' association", new Object[]{address, e});
            return Response.serverError().build();
        }
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="saveAddress")
    @RolesAllowed(value={"users"})
    public Response saveAddress(Wallet wallet) {
        if (wallet == null) {
            LOG.warn((Object)"Bad request sent to server with empty data");
            return Response.status((int)400).build();
        }
        String currentUserId = Utils.getCurrentUserId();
        LOG.info("User '{}' is saving new wallet address for {} '{}' with address '{}'", new Object[]{currentUserId, wallet.getType(), wallet.getId(), wallet.getAddress()});
        try {
            Wallet storedWallet = this.accountService.getWallet(wallet.getType(), wallet.getId());
            if (storedWallet == null) {
                wallet.setEnabled(true);
                this.accountService.saveWallet(wallet, currentUserId, true);
            } else {
                storedWallet.setAddress(wallet.getAddress());
                storedWallet.setEnabled(wallet.isEnabled());
                this.accountService.saveWallet(storedWallet, currentUserId, true);
            }
            return Response.ok((Object)wallet.getPassPhrase()).build();
        }
        catch (IllegalAccessException | IllegalStateException e) {
            return Response.status((int)403).build();
        }
        catch (Exception e) {
            LOG.error((Object)("Unknown error occurred while saving address: User " + currentUserId + " attempts to save address of " + wallet.getType() + " '" + wallet.getId() + "' using address " + wallet.getAddress()), (Throwable)e);
            return Response.status((int)500).build();
        }
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="savePreferences")
    @RolesAllowed(value={"users"})
    public Response savePreferences(WalletPreferences preferences) {
        if (preferences == null) {
            LOG.warn((Object)"Bad request sent to server with empty preferenes");
            return Response.status((int)400).build();
        }
        Long defaultGas = preferences.getDefaultGas();
        if (defaultGas == null || defaultGas == 0L) {
            LOG.warn("Bad request sent to server with invalid preferenes defaultGas '{}'", new Object[]{defaultGas});
            return Response.status((int)400).build();
        }
        LOG.info("Saving user preferences '{}'", new Object[]{Utils.getCurrentUserId()});
        try {
            this.ethereumWalletService.saveUserPreferences(Utils.getCurrentUserId(), preferences);
            return Response.ok().build();
        }
        catch (Exception e) {
            LOG.error((Object)("Unknown error occurred while saving user preferences '" + Utils.getCurrentUserId() + "'"), (Throwable)e);
            return Response.status((int)500).build();
        }
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="requestFunds")
    @RolesAllowed(value={"users"})
    public Response requestFunds(FundsRequest fundsRequest) {
        if (fundsRequest == null) {
            LOG.warn((Object)"Bad request sent to server with empty funds request");
            return Response.status((int)400).build();
        }
        if (StringUtils.isBlank((String)fundsRequest.getAddress())) {
            LOG.warn((Object)"Bad request sent to server with empty sender address");
            return Response.status((int)400).build();
        }
        String receipientRemoteId = fundsRequest.getReceipient();
        String receipientType = fundsRequest.getReceipientType();
        if (StringUtils.isBlank((String)receipientRemoteId) || StringUtils.isBlank((String)receipientType)) {
            LOG.warn((Object)"Bad request sent to server with empty receipient");
            return Response.status((int)400).build();
        }
        try {
            this.ethereumWalletService.requestFunds(fundsRequest);
            return Response.ok().build();
        }
        catch (IllegalAccessException e) {
            return Response.status((int)403).build();
        }
        catch (IllegalStateException e) {
            return Response.status((int)400).build();
        }
        catch (Exception e) {
            LOG.error((Object)("Unknown error occurred while user '" + Utils.getCurrentUserId() + "' requesting funds for wallet  '" + fundsRequest.getAddress() + "'"), (Throwable)e);
            return Response.status((int)500).build();
        }
    }

    @GET
    @Path(value="markFundRequestAsSent")
    @RolesAllowed(value={"users"})
    public Response markFundRequestAsSent(@QueryParam(value="notificationId") String notificationId) {
        if (StringUtils.isBlank((String)notificationId)) {
            LOG.warn((Object)"Bad request sent to server with empty notificationId");
            return Response.status((int)400).build();
        }
        String currentUser = Utils.getCurrentUserId();
        try {
            this.ethereumWalletService.markFundRequestAsSent(notificationId, currentUser);
            return Response.ok().build();
        }
        catch (IllegalAccessException e) {
            return Response.status((int)403).build();
        }
        catch (IllegalStateException e) {
            return Response.status((int)400).build();
        }
        catch (Exception e) {
            LOG.error((Object)("Unknown error occurred while marking fund request with id '" + notificationId + "' for user '" + Utils.getCurrentUserId() + "'"), (Throwable)e);
            return Response.status((int)500).build();
        }
    }

    @GET
    @Path(value="fundRequestSent")
    @Produces(value={"text/plain"})
    @RolesAllowed(value={"users"})
    public Response isFundRequestSent(@QueryParam(value="notificationId") String notificationId) {
        if (StringUtils.isBlank((String)notificationId)) {
            LOG.warn((Object)"Bad request sent to server with empty notificationId");
            return Response.status((int)400).build();
        }
        String currentUser = Utils.getCurrentUserId();
        try {
            boolean fundRequestSent = this.ethereumWalletService.isFundRequestSent(notificationId, currentUser);
            return Response.ok((Object)String.valueOf(fundRequestSent)).build();
        }
        catch (IllegalAccessException e) {
            return Response.status((int)403).build();
        }
        catch (IllegalStateException e) {
            return Response.status((int)400).build();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error retrieving fund request status", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="list")
    @RolesAllowed(value={"administrators"})
    public Response getWallets() {
        try {
            return Response.ok(this.accountService.listWallets()).build();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error retrieving list of wallets", (Throwable)e);
            return Response.serverError().build();
        }
    }
}

