/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.ethereum.wallet.rest;

import java.util.List;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.addon.ethereum.wallet.ext.reward.model.RewardPeriod;
import org.exoplatform.addon.ethereum.wallet.ext.reward.model.RewardPeriodType;
import org.exoplatform.addon.ethereum.wallet.ext.reward.model.RewardTransaction;
import org.exoplatform.addon.ethereum.wallet.service.WalletRewardService;
import org.exoplatform.addon.ethereum.wallet.service.utils.GamificationUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.json.JSONArray;
import org.json.JSONObject;

@Path(value="/wallet/api/reward")
public class WalletRewardREST
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(WalletRewardREST.class);
    private WalletRewardService rewardService;

    public WalletRewardREST(WalletRewardService walletRewardService) {
        this.rewardService = walletRewardService;
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="getPeriodRewardTransactions")
    @RolesAllowed(value={"users"})
    public Response getPeriodRewardTransactions(@QueryParam(value="networkId") long networkId, @QueryParam(value="periodType") String periodType, @QueryParam(value="startDateInSeconds") long startDateInSeconds, @QueryParam(value="walletRewardType") String walletRewardType) {
        if (networkId == 0L) {
            LOG.warn("Bad request sent to server with empty networkId {}", new Object[]{networkId});
            return Response.status((int)400).build();
        }
        if (StringUtils.isBlank((String)periodType)) {
            LOG.warn("Bad request sent to server with empty periodType {}", new Object[]{periodType});
            return Response.status((int)400).build();
        }
        if (startDateInSeconds == 0L) {
            LOG.warn("Bad request sent to server with empty startDateInSeconds {}", new Object[]{startDateInSeconds});
            return Response.status((int)400).build();
        }
        List<JSONObject> periodTransactions = this.rewardService.getPeriodRewardTransactions(networkId, periodType, startDateInSeconds, walletRewardType);
        JSONArray array = new JSONArray(periodTransactions);
        return Response.ok((Object)array.toString()).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="savePeriodRewardTransactions")
    @RolesAllowed(value={"users"})
    public Response savePeriodRewardTransactions(List<RewardTransaction> rewardTransactions) {
        if (rewardTransactions == null || rewardTransactions.isEmpty()) {
            LOG.warn("Bad request sent to server with empty transactions to save: {}", new Object[]{rewardTransactions});
            return Response.status((int)400).build();
        }
        try {
            for (RewardTransaction rewardTransaction : rewardTransactions) {
                this.rewardService.savePeriodRewardTransaction(rewardTransaction);
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Error saving transaction", (Throwable)e);
            return Response.serverError().build();
        }
        return Response.ok().build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="savePeriodRewardTransaction")
    @RolesAllowed(value={"users"})
    public Response savePeriodRewardTransaction(RewardTransaction rewardTransaction) {
        if (rewardTransaction == null) {
            LOG.warn("Bad request sent to server with empty transaction to save: {}", new Object[]{rewardTransaction});
            return Response.status((int)400).build();
        }
        try {
            this.rewardService.savePeriodRewardTransaction(rewardTransaction);
        }
        catch (Exception e) {
            LOG.warn((Object)"Error saving transaction", (Throwable)e);
            return Response.serverError().build();
        }
        return Response.ok().build();
    }

    @Path(value="getPeriodRewardDates")
    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    public Response getPeriodRewardDates(@QueryParam(value="periodType") String periodType, @QueryParam(value="dateInSeconds") long dateInSeconds) {
        if (dateInSeconds == 0L) {
            LOG.warn((Object)"Bad request sent to server with empty 'dateInSeconds' parameter");
            return Response.status((int)400).build();
        }
        if (StringUtils.isBlank((String)periodType)) {
            LOG.warn((Object)"Bad request sent to server with empty 'periodType' parameter");
            return Response.status((int)400).build();
        }
        RewardPeriodType gamificationPeriodType = RewardPeriodType.valueOf(periodType);
        RewardPeriod gamificationPeriod = gamificationPeriodType.getPeriodOfTime(GamificationUtils.timeFromSeconds(dateInSeconds));
        return Response.ok((Object)gamificationPeriod.toString()).build();
    }
}

