/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.ethereum.wallet.service;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.addon.ethereum.wallet.model.TransactionDetail;
import org.exoplatform.addon.ethereum.wallet.service.EthereumClientConnector;
import org.exoplatform.addon.ethereum.wallet.service.EthereumWalletTransactionService;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.picocontainer.Startable;
import org.web3j.protocol.core.methods.response.Transaction;

public class EthereumTransactionVerifier
implements Startable {
    private static final Log LOG = ExoLogger.getLogger(EthereumTransactionVerifier.class);
    private ExoContainer container;
    private EthereumClientConnector ethereumClientConnector;
    private EthereumWalletTransactionService transactionService;
    private ListenerService listenerService;
    private ScheduledExecutorService scheduledExecutorService = null;

    public EthereumTransactionVerifier(ExoContainer container, EthereumClientConnector ethereumClientConnector, EthereumWalletTransactionService transactionService) {
        this.container = container;
        this.ethereumClientConnector = ethereumClientConnector;
        this.transactionService = transactionService;
    }

    public void start() {
        ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("Ethereum-transaction-verifier-%d").build();
        this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(namedThreadFactory);
        this.scheduledExecutorService.scheduleWithFixedDelay(() -> {
            ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
            RequestLifeCycle.begin((ExoContainer)this.container);
            try {
                LOG.debug((Object)"Checking transactions with not sent notifications");
                List<TransactionDetail> pendingTransactions = this.transactionService.getPendingTransactions();
                if (pendingTransactions != null && !pendingTransactions.isEmpty()) {
                    LOG.info("Checking {} pending transactions if it has not been notified to users", new Object[]{pendingTransactions.size()});
                    for (TransactionDetail transactionDetail : pendingTransactions) {
                        String hash = transactionDetail.getHash();
                        try {
                            Transaction transaction = this.ethereumClientConnector.getTransaction(hash);
                            if (transaction == null || StringUtils.isBlank((String)transaction.getBlockHash()) || StringUtils.equals((String)"0x0000000000000000000000000000000000000000000000000000000000000000", (String)transaction.getBlockHash()) || transaction.getBlockNumber() == null || transaction.getBlockNumber().longValue() >= this.ethereumClientConnector.getLastWatchedBlockNumber() || !transactionDetail.isPending()) continue;
                            LOG.info("Treating transaction {} that is still marked pending while it has been already mined.", new Object[]{hash});
                            this.getListenerService().broadcast("exo.addon.wallet.transaction.loaded", (Object)transaction, null);
                        }
                        catch (Exception e) {
                            LOG.warn("Error treating pending transaction: {}", new Object[]{hash, e});
                        }
                    }
                }
            }
            catch (Exception e) {
                LOG.error((Object)"Error while checking pending transactions", (Throwable)e);
            }
            finally {
                RequestLifeCycle.end();
            }
        }, 1L, 5L, TimeUnit.MINUTES);
    }

    public void stop() {
        this.scheduledExecutorService.shutdownNow();
    }

    private ListenerService getListenerService() {
        if (this.listenerService == null) {
            this.listenerService = (ListenerService)CommonsUtils.getService(ListenerService.class);
        }
        return this.listenerService;
    }
}

