/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.ethereum.wallet.service;

import java.util.Set;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.addon.ethereum.wallet.model.Wallet;
import org.exoplatform.addon.ethereum.wallet.model.WalletType;
import org.exoplatform.addon.ethereum.wallet.service.utils.Utils;
import org.exoplatform.addon.ethereum.wallet.storage.AccountStorage;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;

public class EthereumWalletAccountService {
    private static final Log LOG = ExoLogger.getLogger(EthereumWalletAccountService.class);
    private AccountStorage accountStorage;
    private ListenerService listenerService;

    public EthereumWalletAccountService(AccountStorage walletAccountStorage) {
        this.accountStorage = walletAccountStorage;
    }

    public Set<Wallet> listWallets() {
        Set<Wallet> wallets = this.accountStorage.listWallets();
        wallets.forEach(wallet -> wallet.setPassPhrase(null));
        return wallets;
    }

    public long getWalletsCount() {
        return this.accountStorage.getWalletsCount();
    }

    public Wallet getWalletByTypeAndID(String type, String remoteId) {
        Identity identity;
        if (StringUtils.isBlank((String)remoteId)) {
            throw new IllegalArgumentException("id parameter is mandatory");
        }
        WalletType accountType = WalletType.getType(type);
        if (accountType.isSpace()) {
            remoteId = Utils.getSpacePrettyName(remoteId);
        }
        if ((identity = Utils.getIdentityByTypeAndId(accountType, remoteId)) == null) {
            throw new IllegalArgumentException("Can't find identity with id " + remoteId + " and type " + accountType.getId());
        }
        Wallet wallet = this.accountStorage.getWalletByIdentityId(Long.parseLong(identity.getId()));
        if (wallet == null) {
            wallet = new Wallet();
            Utils.computeWalletFromIdentity(wallet, identity);
        } else {
            wallet.setEnabled(wallet.isEnabled() && identity.isEnable() && !identity.isDeleted());
        }
        wallet.setDisabledUser(!identity.isEnable());
        wallet.setDeletedUser(identity.isDeleted());
        return wallet;
    }

    public Wallet getWalletByAddress(String address) {
        if (address == null) {
            throw new IllegalArgumentException("address is mandatory");
        }
        Wallet wallet = this.accountStorage.getWalletByAddress(address);
        if (wallet != null) {
            Identity identity = Utils.getIdentityById(wallet.getTechnicalId());
            wallet.setEnabled(wallet.isEnabled() && identity.isEnable() && !identity.isDeleted());
            wallet.setDisabledUser(!identity.isEnable());
            wallet.setDeletedUser(identity.isDeleted());
        }
        return wallet;
    }

    public void saveWallet(Wallet wallet, String modifierUsername, boolean broadcast) throws Exception {
        if (wallet == null) {
            throw new IllegalArgumentException("Wallet is mandatory");
        }
        if (StringUtils.isBlank((String)wallet.getAddress())) {
            throw new IllegalArgumentException("Wallet address is empty, thus it can't be saved");
        }
        Utils.computeWalletIdentity(wallet);
        Wallet oldWallet = this.accountStorage.getWalletByIdentityId(wallet.getTechnicalId());
        this.checkCanSaveWallet(wallet, oldWallet, modifierUsername);
        boolean isNew = oldWallet == null;
        wallet.setEnabled(isNew || wallet.isEnabled());
        this.setWalletPassPhrase(wallet, oldWallet, isNew);
        this.accountStorage.saveWallet(wallet, isNew);
        if (broadcast) {
            this.getListenerService().broadcast(isNew ? "exo.addon.wallet.addressAssociation.new" : "exo.addon.wallet.addressAssociation.modification", (Object)oldWallet, (Object)wallet);
        }
    }

    public void removeWalletByAddress(String address, String username) throws IllegalAccessException {
        if (address == null) {
            throw new IllegalArgumentException("address paramter is mandatory");
        }
        Wallet wallet = this.accountStorage.getWalletByAddress(address);
        if (wallet == null) {
            throw new IllegalStateException("Can't find wallet associated to address " + address);
        }
        if (!Utils.isUserAdmin(username)) {
            throw new IllegalAccessException("Current user " + username + " attempts to delete wallet with address " + address + " of " + wallet.getType() + " " + wallet.getId());
        }
        this.accountStorage.removeWallet(wallet.getTechnicalId());
    }

    public void enableWalletByAddress(String address, boolean enable, String username) throws IllegalAccessException {
        if (address == null) {
            throw new IllegalArgumentException("address paramter is mandatory");
        }
        Wallet wallet = this.accountStorage.getWalletByAddress(address);
        if (wallet == null) {
            throw new IllegalStateException("Can't find wallet associated to address " + address);
        }
        if (!Utils.isUserAdmin(username)) {
            throw new IllegalAccessException("User " + username + " attempts to disable wallet with address " + address + " of " + wallet.getType() + " " + wallet.getId());
        }
        wallet.setEnabled(enable);
        this.accountStorage.saveWallet(wallet, false);
    }

    public boolean canAccessWallet(Wallet wallet, String username) {
        String remoteId = wallet.getId();
        WalletType type = WalletType.getType(wallet.getType());
        boolean isUserAdmin = Utils.isUserAdmin(username);
        if (isUserAdmin) {
            return true;
        }
        return type.isUser() && StringUtils.equals((String)username, (String)remoteId) || type.isSpace() && Utils.isUserSpaceMember(wallet.getId(), username);
    }

    public void checkCanSaveWallet(Wallet wallet, Wallet oldWallet, String modifierUsername) throws IllegalAccessException {
        Wallet walletByAddress;
        if (Utils.isUserAdmin(modifierUsername)) {
            return;
        }
        String remoteId = wallet.getId();
        WalletType type = WalletType.getType(wallet.getType());
        if (type.isUser()) {
            if (!StringUtils.equals((String)modifierUsername, (String)remoteId)) {
                LOG.error("User '{}' attempts to modify wallet address of user '{}'", new Object[]{modifierUsername, remoteId});
                throw new IllegalAccessException();
            }
            if (oldWallet != null && !oldWallet.isEnabled()) {
                LOG.error("User '{}' attempts to modify his wallet while it's disabled", new Object[]{modifierUsername});
                throw new IllegalAccessException();
            }
        } else {
            Utils.checkUserIsSpaceManager(remoteId, modifierUsername, true);
        }
        if ((walletByAddress = this.accountStorage.getWalletByAddress(wallet.getAddress())) != null && walletByAddress.getId() != wallet.getId()) {
            throw new IllegalStateException("User " + modifierUsername + " attempts to assign address of wallet of " + walletByAddress);
        }
    }

    private void setWalletPassPhrase(Wallet wallet, Wallet oldWallet, boolean isNew) {
        if (isNew) {
            wallet.setPassPhrase(this.generateSecurityPhrase());
        } else {
            wallet.setPassPhrase(oldWallet.getPassPhrase());
            if (StringUtils.isBlank((String)wallet.getPassPhrase())) {
                LOG.warn("Wallet of type {} and id {} hasn't a generated passPhrase while it's not new, generating a new one", new Object[]{wallet.getType(), wallet.getId()});
                wallet.setPassPhrase(this.generateSecurityPhrase());
            }
        }
    }

    private String generateSecurityPhrase() {
        return RandomStringUtils.random((int)20, (char[])Utils.SIMPLE_CHARS);
    }

    private ListenerService getListenerService() {
        if (this.listenerService == null) {
            this.listenerService = (ListenerService)CommonsUtils.getService(ListenerService.class);
        }
        return this.listenerService;
    }
}

