/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.ethereum.wallet.notification.plugin;

import java.util.List;
import org.exoplatform.addon.ethereum.wallet.model.TransactionNotificationType;
import org.exoplatform.addon.ethereum.wallet.model.Wallet;
import org.exoplatform.addon.ethereum.wallet.service.utils.Utils;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.plugin.BaseNotificationPlugin;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.xml.InitParams;

public class WalletSenderNotificationPlugin
extends BaseNotificationPlugin {
    public WalletSenderNotificationPlugin(InitParams initParams) {
        super(initParams);
    }

    public String getId() {
        return TransactionNotificationType.SENDER.getNotificationId();
    }

    public boolean isValid(NotificationContext ctx) {
        return true;
    }

    protected NotificationInfo makeNotification(NotificationContext ctx) {
        Wallet senderAccountDetail = (Wallet)ctx.value(Utils.SENDER_ACCOUNT_DETAIL_PARAMETER);
        Wallet receiverAccountDetail = (Wallet)ctx.value(Utils.RECEIVER_ACCOUNT_DETAIL_PARAMETER);
        String symbol = (String)ctx.value(Utils.SYMBOL_PARAMETER);
        String contractAddress = (String)ctx.value(Utils.CONTRACT_ADDRESS_PARAMETER);
        double amount = (Double)ctx.value(Utils.AMOUNT_PARAMETER);
        String message = (String)ctx.value(Utils.MESSAGE_PARAMETER);
        String hash = (String)ctx.value(Utils.HASH_PARAMETER);
        List<String> toList = Utils.getNotificationReceiversUsers(senderAccountDetail, receiverAccountDetail.getId());
        if (toList == null || toList.isEmpty()) {
            return null;
        }
        String avatar = CommonsUtils.getCurrentDomain() + receiverAccountDetail.getAvatar();
        return NotificationInfo.instance().to(toList).with("contractAddress", contractAddress).with("amount", String.valueOf(amount)).with("account_type", senderAccountDetail.getType()).with("receiver_type", receiverAccountDetail.getType()).with("symbol", symbol).with("message", message).with("hash", hash).with("avatar", avatar).with("senderUrl", Utils.getPermanentLink(senderAccountDetail)).with("receiverUrl", Utils.getPermanentLink(receiverAccountDetail)).with("sender", senderAccountDetail.getName()).with("receiver", receiverAccountDetail.getName()).key(this.getKey()).end();
    }
}

