/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.ethereum.wallet.service.managed;

import java.util.Set;
import org.exoplatform.addon.ethereum.wallet.service.EthereumTransactionVerifier;
import org.exoplatform.addon.ethereum.wallet.service.EthereumWalletAccountService;
import org.exoplatform.addon.ethereum.wallet.service.EthereumWalletService;
import org.exoplatform.addon.ethereum.wallet.service.EthereumWalletTransactionService;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.management.annotations.Managed;
import org.exoplatform.management.annotations.ManagedDescription;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;

@Managed
@NameTemplate(value={@Property(key="service", value="ethereum"), @Property(key="view", value="wallet")})
@ManagedDescription(value="Ethereum blockchain wallet service")
public class EthereumWalletServiceManaged {
    private EthereumWalletAccountService accountService;
    private EthereumWalletTransactionService transactionService;
    private EthereumTransactionVerifier transactionVerifier;

    public EthereumWalletServiceManaged(EthereumWalletService ethereumWalletService) {
    }

    @Managed
    @ManagedDescription(value="Get ethereum blockchain known treated transactions")
    public long getKnownTreatedTransactionsCount() {
        return this.getTransactionService().getWatchedTreatedTransactionsCount();
    }

    @Managed
    @ManagedDescription(value="Get ethereum wallets count")
    public long getWalletsCount() {
        return this.getAccountService().getWalletsCount();
    }

    @Managed
    @ManagedDescription(value="Run ethereum transaction verifier")
    public void runTransactionVerifier() {
        this.getTransactionVerifier().runNow();
    }

    @Managed
    @ManagedDescription(value="Get pending transactions")
    public Set<String> getPendingTransactionHashes() {
        return this.getTransactionVerifier().getPendingTransactionHashes();
    }

    public EthereumWalletTransactionService getTransactionService() {
        if (this.transactionService == null) {
            this.transactionService = (EthereumWalletTransactionService)CommonsUtils.getService(EthereumWalletTransactionService.class);
        }
        return this.transactionService;
    }

    public EthereumWalletAccountService getAccountService() {
        if (this.accountService == null) {
            this.accountService = (EthereumWalletAccountService)CommonsUtils.getService(EthereumWalletAccountService.class);
        }
        return this.accountService;
    }

    public EthereumTransactionVerifier getTransactionVerifier() {
        if (this.transactionVerifier == null) {
            this.transactionVerifier = (EthereumTransactionVerifier)CommonsUtils.getService(EthereumTransactionVerifier.class);
        }
        return this.transactionVerifier;
    }
}

