import {getWalletApp, initApp, expectCountElement, expectObjectValueEqual, initiateBrowserWallet} from '../TestUtils.js';

import WalletBackupModal from '../../main/webapp/vue-app/components/WalletBackupModal.vue';

import {mount} from '@vue/test-utils';

import flushPromises from 'flush-promises';

jest.setTimeout(30000);

describe('WalletBackupModal.test.js', () => {
  const app = getWalletApp();

  beforeAll(() => {
    return initApp(app);
  });

  const defaultAttributesValues = {
    displayCompleteMessage: false,
    dialog: false,
    error: false,
    walletPassword: '',
    walletPasswordShow: false,
    walletPrivateKey: false,
    autoGeneratedPassword: false,
    backedUp: false,
  };

  it('WalletBackupModal default data', () => {
    console.log('-- WalletBackupModal default data');

    const walletBackupModal = mount(WalletBackupModal, {
      attachToDocument: true,
    });

    expectObjectValueEqual(walletBackupModal.vm, defaultAttributesValues, 'WalletBackupModal default data');
  });

  it('WalletBackupModal test when browserWallet is not backedup', (done) => {
    console.log('-- Test WalletBackupModal test when browserWallet is not backedup');

    let walletSetup, walletBackupModal;

    return initiateBrowserWallet(global.walletAddress, 'testpassword', /* Not space*/ false, /* generated */ true, /* not backedup */ false)
      .then(() => initApp(app))
      .then(() => app.vm.$nextTick())
      .then(() => {
        walletSetup = app.vm.$refs.walletSetup;
        expect(walletSetup).toBeTruthy();

        expect(app.findAll('#walletSetup #walletBackupModal')).toHaveLength(1);

        const expectedData = Object.assign({}, defaultAttributesValues);

        expectedData.displayCompleteMessage = true;
        expectedData.autoGeneratedPassword = true;

        walletBackupModal = walletSetup.$refs.walletBackupModal;
        expect(walletBackupModal).toBeTruthy();

        expectCountElement(app, 'walletBackupWarning', 1);

        expectObjectValueEqual(walletBackupModal, expectedData, 'test when browserWallet is not backedup default data');

        return flushPromises();
      })

      .then(() => app.vm.$nextTick())
      .then(() => {
        expectCountElement(app, 'walletBackupWarningOne', 1);
        expectCountElement(app, 'walletBackupWarningTwo', 1);

        return flushPromises();
      })

      .then(() => {
        window.walletSettings.userPreferences.autoGeneratedPassword = true;

        walletBackupModal.dialog = true;

        walletBackupModal.walletBackedUp();

        walletBackupModal.showPrivateKey();

        return flushPromises();
      })

      .then(() => app.vm.$nextTick())
      .then(() => {
        expectCountElement(app, 'walletBackupWarningOne', 0);
        expectCountElement(app, 'walletBackupWarningTwo', 1);

        return flushPromises();
      })

      .then(() => {
        const expectedData = Object.assign({}, defaultAttributesValues);

        expectedData.displayCompleteMessage = true;
        expectedData.autoGeneratedPassword = true;

        expectedData.backedUp = true;

        expectObjectValueEqual(walletBackupModal, expectedData, 'when browserWallet is backedup default data');

        return flushPromises();
      })

      .then(() => done())
      .catch((e) => done(e));
  });

  it('WalletBackupModal test when browser wallet is backedup', (done) => {
    console.log('-- Test WalletBackupModal test when browser wallet is backedup');

    let walletSetup;

    return initiateBrowserWallet(global.walletAddress, 'testpassword', /* Not space*/ false, /* generated */ true, /* backedup */ true)
      .then(() => initApp(app))
      .then(() => app.vm.$nextTick())
      .then(() => {
        walletSetup = app.vm.$refs.walletSetup;
        expect(walletSetup).toBeTruthy();

        expect(app.findAll('#walletSetup #walletBackupModal')).toHaveLength(0);

        expectCountElement(app, 'walletBackupWarning', 0);

        return flushPromises();
      })

      .then(() => app.vm.$nextTick())
      .then(() => {
        expectCountElement(app, 'walletBackupWarningOne', 0);
        expectCountElement(app, 'walletBackupWarningTwo', 1);

        return flushPromises();
      })

      .then(() => done())
      .catch((e) => done(e));
  });

  it('WalletBackupModal test when walletBackedUp event', () => {
    console.log('-- WalletBackupModal test when walletBackedUp event');

    const walletBackupModal = mount(WalletBackupModal, {
      attachToDocument: true,
    });

    walletBackupModal.vm.walletBackedUp();
    expect(walletBackupModal.emitted()['copied']).toBeTruthy();
  });
});
