// Generated by delombok at Mon Sep 16 21:31:52 UTC 2019
package org.exoplatform.addon.wallet.model.reward;

import java.io.Serializable;
import java.util.Set;
import org.exoplatform.addon.wallet.model.Wallet;
import lombok.*;
import lombok.EqualsAndHashCode.Exclude;

public class WalletReward implements Serializable {
  private static final long serialVersionUID = -4328398843364453949L;
  private Wallet wallet;
  private Set<WalletPluginReward> rewards;
  private RewardTransaction transaction;
  private String poolName;
  private boolean enabled;

  public double getTokensSent() {
    if (transaction == null || transaction.getTokensSent() == 0) {
      return 0;
    } else {
      return transaction.getTokensSent();
    }
  }

  public double getTokensToSend() {
    if (rewards == null || rewards.isEmpty()) {
      return 0;
    } else {
      return rewards.stream().mapToDouble(reward -> reward.getAmount()).sum();
    }
  }

  public double getPoolTokensToSend() {
    if (rewards == null || rewards.isEmpty()) {
      return 0;
    } else {
      return rewards.stream().filter(WalletPluginReward::isPoolsUsed).mapToDouble(reward -> reward.getAmount()).sum();
    }
  }

  @java.lang.SuppressWarnings("all")
  public Wallet getWallet() {
    return this.wallet;
  }

  @java.lang.SuppressWarnings("all")
  public Set<WalletPluginReward> getRewards() {
    return this.rewards;
  }

  @java.lang.SuppressWarnings("all")
  public RewardTransaction getTransaction() {
    return this.transaction;
  }

  @java.lang.SuppressWarnings("all")
  public String getPoolName() {
    return this.poolName;
  }

  @java.lang.SuppressWarnings("all")
  public boolean isEnabled() {
    return this.enabled;
  }

  @java.lang.SuppressWarnings("all")
  public void setWallet(final Wallet wallet) {
    this.wallet = wallet;
  }

  @java.lang.SuppressWarnings("all")
  public void setRewards(final Set<WalletPluginReward> rewards) {
    this.rewards = rewards;
  }

  @java.lang.SuppressWarnings("all")
  public void setTransaction(final RewardTransaction transaction) {
    this.transaction = transaction;
  }

  @java.lang.SuppressWarnings("all")
  public void setPoolName(final String poolName) {
    this.poolName = poolName;
  }

  @java.lang.SuppressWarnings("all")
  public void setEnabled(final boolean enabled) {
    this.enabled = enabled;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof WalletReward)) return false;
    final WalletReward other = (WalletReward) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$wallet = this.getWallet();
    final java.lang.Object other$wallet = other.getWallet();
    if (this$wallet == null ? other$wallet != null : !this$wallet.equals(other$wallet)) return false;
    if (this.isEnabled() != other.isEnabled()) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof WalletReward;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $wallet = this.getWallet();
    result = result * PRIME + ($wallet == null ? 43 : $wallet.hashCode());
    result = result * PRIME + (this.isEnabled() ? 79 : 97);
    return result;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  public java.lang.String toString() {
    return "WalletReward(wallet=" + this.getWallet() + ", rewards=" + this.getRewards() + ", transaction=" + this.getTransaction() + ", poolName=" + this.getPoolName() + ", enabled=" + this.isEnabled() + ")";
  }

  @java.lang.SuppressWarnings("all")
  public WalletReward(final Wallet wallet, final Set<WalletPluginReward> rewards, final RewardTransaction transaction, final String poolName, final boolean enabled) {
    this.wallet = wallet;
    this.rewards = rewards;
    this.transaction = transaction;
    this.poolName = poolName;
    this.enabled = enabled;
  }

  @java.lang.SuppressWarnings("all")
  public WalletReward() {
  }
}
