/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.wallet.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Set;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.addon.wallet.model.Wallet;
import org.exoplatform.addon.wallet.model.WalletAddressLabel;
import org.exoplatform.addon.wallet.model.WalletInitializationState;
import org.exoplatform.addon.wallet.model.WalletType;
import org.exoplatform.addon.wallet.model.transaction.FundsRequest;
import org.exoplatform.addon.wallet.service.WalletAccountService;
import org.exoplatform.addon.wallet.service.WalletService;
import org.exoplatform.addon.wallet.utils.WalletUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="/wallet/api/account")
@Api(value="/wallet/api/account", description="Manages wallets objects associated to users, spaces and admin")
@RolesAllowed(value={"users"})
public class WalletAccountREST
implements ResourceContainer {
    private static final String WALLET_NOT_FOUND_MESSAGE = "Wallet was not found with address {}";
    private static final String EMPTY_ADDRESS_MESSAGE = "Bad request sent to server with empty address";
    private static final Log LOG = ExoLogger.getLogger(WalletAccountREST.class);
    private WalletService walletService;
    private WalletAccountService accountService;

    public WalletAccountREST(WalletService walletService, WalletAccountService accountService) {
        this.walletService = walletService;
        this.accountService = accountService;
    }

    @Path(value="detailsById")
    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Retrieves the user or space wallet identified by username or space pretty name", httpMethod="GET", response=Response.class, produces="application/json", notes="returns the associated Wallet object, if not found it will return an empty object")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response getWalletByTypeAndID(@ApiParam(value="username or space pretty name", required=true) @QueryParam(value="id") String remoteId, @ApiParam(value="'user' or 'space'", required=true) @QueryParam(value="type") String type) {
        if (StringUtils.isBlank((String)remoteId) || StringUtils.isBlank((String)type)) {
            LOG.warn("Bad request sent to server with id '{}' and type '{}'", new Object[]{remoteId, type});
            return Response.status((int)400).build();
        }
        try {
            Wallet wallet = this.accountService.getWalletByTypeAndId(type, remoteId, WalletUtils.getCurrentUserId());
            if (wallet != null) {
                return Response.ok((Object)wallet).build();
            }
            return Response.ok((Object)"{}").build();
        }
        catch (Exception e) {
            LOG.error("Error getting wallet by id {} and type {}", new Object[]{remoteId, type});
            return Response.serverError().build();
        }
    }

    @Path(value="detailsByAddress")
    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Retrieves the user or space wallet identified by an address", httpMethod="GET", response=Response.class, produces="application/json", notes="returns the associated Wallet object, if not found it will return an empty object")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response getWalletByAddress(@ApiParam(value="wallet address", required=true) @QueryParam(value="address") String address) {
        try {
            if (StringUtils.isBlank((String)address)) {
                LOG.warn((Object)EMPTY_ADDRESS_MESSAGE);
                return Response.status((int)400).build();
            }
            String currentUser = WalletUtils.getCurrentUserId();
            Wallet wallet = this.accountService.getWalletByAddress(address, currentUser);
            if (wallet != null) {
                if (WalletType.isSpace(wallet.getType())) {
                    wallet.setSpaceAdministrator(WalletUtils.isUserSpaceManager(wallet.getId(), currentUser));
                }
                WalletUtils.hideWalletOwnerPrivateInformation(wallet);
                return Response.ok((Object)wallet).build();
            }
            return Response.ok((Object)"{}").build();
        }
        catch (Exception e) {
            LOG.error("Error getting wallet by address {}", new Object[]{address});
            return Response.serverError().build();
        }
    }

    @Path(value="enable")
    @GET
    @RolesAllowed(value={"rewarding"})
    @ApiOperation(value="Enable or disable a wallet identified by its address", httpMethod="GET", response=Response.class, notes="returns empty response")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response enableWalletByAddress(@ApiParam(value="wallet address", required=true) @QueryParam(value="address") String address, @ApiParam(value="true to enable wallet, else false", required=true) @QueryParam(value="enable") boolean enable) {
        if (StringUtils.isBlank((String)address)) {
            LOG.warn((Object)EMPTY_ADDRESS_MESSAGE);
            return Response.status((int)400).build();
        }
        try {
            this.accountService.enableWalletByAddress(address, enable, WalletUtils.getCurrentUserId());
            return Response.ok().build();
        }
        catch (Exception e) {
            LOG.error("Can't delete address '{}' association", new Object[]{address, e});
            return Response.serverError().build();
        }
    }

    @Path(value="setInitializationStatus")
    @GET
    @RolesAllowed(value={"rewarding"})
    @ApiOperation(value="Modify initialization status of wallet", httpMethod="GET", response=Response.class, notes="returns empty response")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response setInitializationStatus(@ApiParam(value="wallet address", required=true) @QueryParam(value="address") String address, @ApiParam(value="intialization status: new, modified, pending, initialized or denied", required=true) @QueryParam(value="status") String status) {
        if (StringUtils.isBlank((String)address)) {
            LOG.warn((Object)EMPTY_ADDRESS_MESSAGE);
            return Response.status((int)400).build();
        }
        if (StringUtils.isBlank((String)status)) {
            LOG.warn((Object)"Bad request sent to server with empty 'status' parameter");
            return Response.status((int)400).build();
        }
        try {
            this.accountService.setInitializationStatus(address, WalletInitializationState.valueOf(status.toUpperCase()), WalletUtils.getCurrentUserId());
            return Response.ok().build();
        }
        catch (Exception e) {
            LOG.error("Can't set wallet initialized status '{}'", new Object[]{status, e});
            return Response.serverError().build();
        }
    }

    @Path(value="requestAuthorization")
    @GET
    @ApiOperation(value="Modify initialization status from DENIED to MODIFIED. This is used in case when a wallet has been denied access, in that case, a new authorization request can be done", httpMethod="GET", response=Response.class, notes="returns empty response")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response requestAuthorization(@ApiParam(value="wallet address to change its status", required=true) @QueryParam(value="address") String address) {
        if (StringUtils.isBlank((String)address)) {
            LOG.warn((Object)EMPTY_ADDRESS_MESSAGE);
            return Response.status((int)400).build();
        }
        try {
            this.accountService.setInitializationStatus(address, WalletInitializationState.MODIFIED, WalletUtils.getCurrentUserId());
            return Response.ok().build();
        }
        catch (Exception e) {
            LOG.error("Can't request authorization for wallet {}", new Object[]{address, e});
            return Response.serverError().build();
        }
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="saveBackupState")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Saves wallet backup state", httpMethod="POST", consumes="application/json", response=Response.class, notes="returns the modified wallet")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response saveWalletBackupState(@ApiParam(value="wallet technical id", required=true) @FormParam(value="walletId") long walletId, @ApiParam(value="whether wallet backedUp or not", required=true) @FormParam(value="backedUp") boolean backedUp) {
        if (walletId <= 0L) {
            LOG.warn((Object)"Bad request sent to server with wrong wallet technical id");
            return Response.status((int)400).build();
        }
        String currentUserId = WalletUtils.getCurrentUserId();
        LOG.debug("User '{}' is saving wallet with id {} backup state {}", new Object[]{currentUserId, walletId, backedUp});
        try {
            Wallet wallet = this.accountService.saveWalletBackupState(currentUserId, walletId, backedUp);
            return Response.ok((Object)wallet).build();
        }
        catch (IllegalAccessException e) {
            LOG.warn("User '{}' is not allowed to change backup state of wallet with id {}", new Object[]{currentUserId, walletId, e});
            return Response.status((int)401).build();
        }
        catch (Exception e) {
            LOG.error("Unknown error occurred while saving wallet backup state: User {} attempts to change backup state wallet with id {}", new Object[]{currentUserId, walletId, e});
            return Response.status((int)500).build();
        }
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="saveAddress")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Associates a wallet address to a user or a space", httpMethod="POST", consumes="application/json", response=Response.class, notes="returns the generated password for newly saved wallet")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response saveWallet(@ApiParam(value="wallet details to save", required=true) Wallet wallet) {
        if (wallet == null) {
            LOG.warn((Object)"Bad request sent to server with empty data");
            return Response.status((int)400).build();
        }
        String currentUserId = WalletUtils.getCurrentUserId();
        LOG.debug("User '{}' is saving new wallet address for {} '{}' with address '{}'", new Object[]{currentUserId, wallet.getType(), wallet.getId(), wallet.getAddress()});
        try {
            Wallet storedWallet = this.accountService.getWalletByTypeAndId(wallet.getType(), wallet.getId(), currentUserId);
            if (storedWallet == null || StringUtils.isBlank((String)storedWallet.getAddress())) {
                this.accountService.saveWalletAddress(wallet, currentUserId);
                return Response.ok((Object)wallet.getPassPhrase()).build();
            }
            storedWallet.setAddress(wallet.getAddress());
            this.accountService.saveWalletAddress(storedWallet, currentUserId);
            return Response.ok((Object)storedWallet.getPassPhrase()).build();
        }
        catch (IllegalAccessException e) {
            LOG.warn("User '{}' is not allowed to save wallet {}", new Object[]{currentUserId, wallet, e});
            return Response.status((int)401).build();
        }
        catch (Exception e) {
            LOG.error((Object)("Unknown error occurred while saving address: User " + currentUserId + " attempts to save address of " + wallet.getType() + " '" + wallet.getId() + "' using address " + wallet.getAddress()), (Throwable)e);
            return Response.status((int)500).build();
        }
    }

    @POST
    @Path(value="savePrivateKey")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Save encrypted private key of a wallet", httpMethod="POST", response=Response.class, notes="returns empty response")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response savePrivateKey(@ApiParam(value="wallet address to save its encrypted private key", required=true) @FormParam(value="address") String address, @ApiParam(value="encrypted wallet private key", required=true) @FormParam(value="privateKey") String privateKey) {
        if (StringUtils.isBlank((String)address)) {
            LOG.warn((Object)EMPTY_ADDRESS_MESSAGE);
            return Response.status((int)400).build();
        }
        if (StringUtils.isBlank((String)privateKey)) {
            LOG.warn((Object)"Empty private key content");
            return Response.status((int)400).build();
        }
        String currentUserId = WalletUtils.getCurrentUserId();
        LOG.info("User '{}' is saving new wallet private key for address {}", new Object[]{currentUserId, address});
        try {
            Wallet wallet = this.accountService.getWalletByAddress(address);
            if (wallet == null) {
                LOG.debug(WALLET_NOT_FOUND_MESSAGE, new Object[]{address});
                return Response.status((int)400).build();
            }
            this.accountService.savePrivateKeyByTypeAndId(wallet.getType(), wallet.getId(), privateKey, currentUserId);
            return Response.ok().build();
        }
        catch (IllegalAccessException e) {
            LOG.warn("Error saving wallet private key by user '{}' for address {}", new Object[]{currentUserId, address, e});
            return Response.status((int)401).build();
        }
        catch (Exception e) {
            LOG.error("Unknown error occurred while saving wallet private key: User {} attempts to save wallet private key of address '{}'", new Object[]{currentUserId, address, e});
            return Response.status((int)500).build();
        }
    }

    @GET
    @Path(value="getPrivateKey")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Get encrypted private key of a wallet", httpMethod="GET", response=Response.class, notes="returns encoded wallet private key in String format")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response getPrivateKey(@ApiParam(value="wallet address", required=true) @QueryParam(value="address") String address) {
        if (StringUtils.isBlank((String)address)) {
            LOG.warn((Object)EMPTY_ADDRESS_MESSAGE);
            return Response.status((int)400).build();
        }
        String currentUserId = WalletUtils.getCurrentUserId();
        try {
            Wallet wallet = this.accountService.getWalletByAddress(address);
            if (wallet == null) {
                LOG.debug(WALLET_NOT_FOUND_MESSAGE, new Object[]{address});
                return Response.status((int)400).build();
            }
            String privateKeyEncrypted = this.accountService.getPrivateKeyByTypeAndId(wallet.getType(), wallet.getId(), currentUserId);
            return Response.ok((Object)privateKeyEncrypted).build();
        }
        catch (IllegalAccessException e) {
            LOG.warn("Error getting wallet private key by user '{}' for address {}", new Object[]{currentUserId, address, e});
            return Response.status((int)401).build();
        }
        catch (Exception e) {
            LOG.error("Unknown error occurred while user {} attempts to get wallet private key with address {}", new Object[]{currentUserId, address, e});
            return Response.status((int)500).build();
        }
    }

    @GET
    @Path(value="removePrivateKey")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Removes associated private key of a wallet", httpMethod="GET", response=Response.class, notes="returns empty response")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response removePrivateKey(@ApiParam(value="wallet address", required=true) @QueryParam(value="address") String address) {
        if (StringUtils.isBlank((String)address)) {
            LOG.warn((Object)EMPTY_ADDRESS_MESSAGE);
            return Response.status((int)400).build();
        }
        String currentUserId = WalletUtils.getCurrentUserId();
        LOG.info("User '{}' is removing wallet private key stored on server for address {}", new Object[]{currentUserId, address});
        try {
            Wallet wallet = this.accountService.getWalletByAddress(address);
            if (wallet == null) {
                LOG.debug(WALLET_NOT_FOUND_MESSAGE, new Object[]{address});
                return Response.status((int)400).build();
            }
            this.accountService.removePrivateKeyByTypeAndId(wallet.getType(), wallet.getId(), currentUserId);
            return Response.ok().build();
        }
        catch (IllegalAccessException e) {
            LOG.warn("Error removing wallet private key by user '{}' for address {}", new Object[]{currentUserId, address, e});
            return Response.status((int)401).build();
        }
        catch (Exception e) {
            LOG.error("Unknown error occurred while saving wallet private key: User {} attempts to save wallet private key of address {}", new Object[]{currentUserId, address, e});
            return Response.status((int)500).build();
        }
    }

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    @Path(value="saveOrDeleteAddressLabel")
    @RolesAllowed(value={"rewarding"})
    @ApiOperation(value="Saves or deletes a label associated to an address. If label is empty, then deletes it, else saves it.", httpMethod="POST", consumes="application/json", produces="application/json", response=Response.class, notes="returns saved label object")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response saveOrDeleteAddressLabel(@ApiParam(value="blockchain address label", required=true) WalletAddressLabel label) {
        if (label == null) {
            LOG.warn((Object)"Bad request sent to server with empty data");
            return Response.status((int)400).build();
        }
        try {
            label = this.accountService.saveOrDeleteAddressLabel(label, WalletUtils.getCurrentUserId());
            return Response.ok((Object)label).build();
        }
        catch (Exception e) {
            LOG.error("Unknown error occurred while saving address label: User " + WalletUtils.getCurrentUserId() + ", label: {}", new Object[]{label, e});
            return Response.status((int)500).build();
        }
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="requestFunds")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Sends a fund request to a user or space", httpMethod="POST", consumes="application/json", response=Response.class, notes="returns empty response")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response requestFunds(@ApiParam(value="funds request object", required=true) FundsRequest fundsRequest) {
        if (fundsRequest == null) {
            LOG.warn((Object)"Bad request sent to server with empty funds request");
            return Response.status((int)400).build();
        }
        if (StringUtils.isBlank((String)fundsRequest.getAddress())) {
            LOG.warn((Object)"Bad request sent to server with empty sender address");
            return Response.status((int)400).build();
        }
        String receipientRemoteId = fundsRequest.getReceipient();
        String receipientType = fundsRequest.getReceipientType();
        if (StringUtils.isBlank((String)receipientRemoteId) || StringUtils.isBlank((String)receipientType)) {
            LOG.warn((Object)"Bad request sent to server with empty receipient");
            return Response.status((int)400).build();
        }
        try {
            this.walletService.requestFunds(fundsRequest, WalletUtils.getCurrentUserId());
            return Response.ok().build();
        }
        catch (IllegalAccessException e) {
            return Response.status((int)401).build();
        }
        catch (IllegalStateException e) {
            LOG.error((Object)("Unknown error occurred while user '" + WalletUtils.getCurrentUserId() + "' requesting funds for wallet  '" + fundsRequest.getAddress() + "'"), (Throwable)e);
            return Response.status((int)400).build();
        }
        catch (Exception e) {
            LOG.error((Object)("Unknown error occurred while user '" + WalletUtils.getCurrentUserId() + "' requesting funds for wallet  '" + fundsRequest.getAddress() + "'"), (Throwable)e);
            return Response.status((int)500).build();
        }
    }

    @GET
    @Path(value="markFundRequestAsSent")
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Mark a web notification of funds request as sent", httpMethod="GET", response=Response.class, notes="returns empty response")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response markFundRequestAsSent(@ApiParam(value="web notification id", required=true) @QueryParam(value="notificationId") String notificationId) {
        if (StringUtils.isBlank((String)notificationId)) {
            LOG.warn((Object)"Bad request sent to server with empty notificationId");
            return Response.status((int)400).build();
        }
        String currentUser = WalletUtils.getCurrentUserId();
        try {
            this.walletService.markFundRequestAsSent(notificationId, currentUser);
            return Response.ok().build();
        }
        catch (IllegalAccessException e) {
            return Response.status((int)401).build();
        }
        catch (IllegalStateException e) {
            return Response.status((int)400).build();
        }
        catch (Exception e) {
            LOG.error((Object)("Unknown error occurred while marking fund request with id '" + notificationId + "' for user '" + WalletUtils.getCurrentUserId() + "'"), (Throwable)e);
            return Response.status((int)500).build();
        }
    }

    @GET
    @Path(value="fundRequestSent")
    @Produces(value={"text/plain"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Returns fund request status", httpMethod="GET", response=Response.class, notes="returns true if notification sent, else false")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response isFundRequestSent(@ApiParam(value="web notification id", required=true) @QueryParam(value="notificationId") String notificationId) {
        if (StringUtils.isBlank((String)notificationId)) {
            LOG.warn((Object)"Bad request sent to server with empty notificationId");
            return Response.status((int)400).build();
        }
        String currentUser = WalletUtils.getCurrentUserId();
        try {
            boolean fundRequestSent = this.walletService.isFundRequestSent(notificationId, currentUser);
            return Response.ok((Object)String.valueOf(fundRequestSent)).build();
        }
        catch (IllegalAccessException e) {
            return Response.status((int)401).build();
        }
        catch (IllegalStateException e) {
            return Response.status((int)400).build();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error retrieving fund request status", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="list")
    @RolesAllowed(value={"rewarding"})
    @ApiOperation(value="Get list of wallet accounts", httpMethod="GET", response=Response.class, produces="application/json", notes="returns array of wallets objects")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response getWallets() {
        try {
            Set<Wallet> wallets = this.accountService.listWallets();
            return Response.ok(wallets).build();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error retrieving list of wallets", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @GET
    @Path(value="refreshWalletFromBlockchain")
    @RolesAllowed(value={"rewarding"})
    @ApiOperation(value="force refresh wallet from blockchain", httpMethod="GET", response=Response.class, notes="returns no response")
    @ApiResponses(value={@ApiResponse(code=204, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response refreshWalletFromBlockchain(@ApiParam(value="wallet address", required=true) @QueryParam(value="address") String address) {
        if (StringUtils.isBlank((String)address)) {
            LOG.warn((Object)"Bad request sent to server with empty wallet address in parameter");
            return Response.status((int)400).build();
        }
        try {
            Wallet wallet = this.accountService.getWalletByAddress(address);
            if (wallet == null) {
                LOG.warn("Bad request sent to server with unknown wallet address: {}", new Object[]{address});
                return Response.status((int)400).build();
            }
            this.accountService.refreshWalletFromBlockchain(wallet, null, null);
            return Response.status((int)204).build();
        }
        catch (Exception e) {
            LOG.warn((Object)"Error retrieving list of wallets", (Throwable)e);
            return Response.serverError().build();
        }
    }
}

