// Generated by delombok at Wed Jul 08 14:08:02 UTC 2020
package org.exoplatform.wallet.model.transaction;

import static org.exoplatform.wallet.utils.WalletUtils.convertFromDecimals;
import static org.exoplatform.wallet.utils.WalletUtils.convertToDecimals;
import java.io.Serializable;
import java.math.BigInteger;
import org.exoplatform.wallet.model.Wallet;
import lombok.EqualsAndHashCode.Exclude;

public class TransactionDetail implements Serializable, Cloneable {
  private static final long serialVersionUID = 658273092293607458L;
  private long id;
  private Wallet issuer;
  private long issuerId;
  private long networkId;
  private String hash;
  private String contractAddress;
  private String contractMethodName;
  private boolean pending;
  private boolean succeeded;
  private boolean isAdminOperation;
  private String from;
  private Wallet fromWallet;
  private String to;
  private Wallet toWallet;
  private String by;
  private Wallet byWallet;
  private String label;
  private String message;
  private double value;
  private double contractAmount;
  private int gasUsed;
  private double gasPrice;
  private double tokenFee;
  private double etherFee;
  private boolean noContractFunds;
  private long timestamp;
  private long nonce;
  private String rawTransaction;
  private long sentTimestamp;
  private long sendingAttemptCount;

  @Override
  public TransactionDetail clone() {
    // NOSONAR
    try {
      return (TransactionDetail) super.clone();
    } catch (CloneNotSupportedException e) {
      throw new IllegalStateException("Error while cloning object", e);
    }
  }

  public BigInteger getContractAmountDecimal(int decimals) {
    if (contractAmount == 0) {
      return BigInteger.ZERO;
    }
    return convertToDecimals(contractAmount, decimals);
  }

  public BigInteger getValueDecimal(int decimals) {
    if (value == 0) {
      return BigInteger.ZERO;
    }
    return convertToDecimals(value, decimals);
  }

  public void setContractAmountDecimal(BigInteger amount, int decimals) {
    if (amount == null) {
      this.contractAmount = 0;
      return;
    }
    this.contractAmount = convertFromDecimals(amount, decimals);
  }

  public void setValueDecimal(BigInteger amount, int decimals) {
    if (amount == null) {
      this.value = 0;
    } else {
      this.value = convertFromDecimals(amount, decimals);
    }
  }

  @java.lang.SuppressWarnings("all")
  public TransactionDetail() {
  }

  @java.lang.SuppressWarnings("all")
  public long getId() {
    return this.id;
  }

  @java.lang.SuppressWarnings("all")
  public Wallet getIssuer() {
    return this.issuer;
  }

  @java.lang.SuppressWarnings("all")
  public long getIssuerId() {
    return this.issuerId;
  }

  @java.lang.SuppressWarnings("all")
  public long getNetworkId() {
    return this.networkId;
  }

  @java.lang.SuppressWarnings("all")
  public String getHash() {
    return this.hash;
  }

  @java.lang.SuppressWarnings("all")
  public String getContractAddress() {
    return this.contractAddress;
  }

  @java.lang.SuppressWarnings("all")
  public String getContractMethodName() {
    return this.contractMethodName;
  }

  @java.lang.SuppressWarnings("all")
  public boolean isPending() {
    return this.pending;
  }

  @java.lang.SuppressWarnings("all")
  public boolean isSucceeded() {
    return this.succeeded;
  }

  @java.lang.SuppressWarnings("all")
  public boolean isAdminOperation() {
    return this.isAdminOperation;
  }

  @java.lang.SuppressWarnings("all")
  public String getFrom() {
    return this.from;
  }

  @java.lang.SuppressWarnings("all")
  public Wallet getFromWallet() {
    return this.fromWallet;
  }

  @java.lang.SuppressWarnings("all")
  public String getTo() {
    return this.to;
  }

  @java.lang.SuppressWarnings("all")
  public Wallet getToWallet() {
    return this.toWallet;
  }

  @java.lang.SuppressWarnings("all")
  public String getBy() {
    return this.by;
  }

  @java.lang.SuppressWarnings("all")
  public Wallet getByWallet() {
    return this.byWallet;
  }

  @java.lang.SuppressWarnings("all")
  public String getLabel() {
    return this.label;
  }

  @java.lang.SuppressWarnings("all")
  public String getMessage() {
    return this.message;
  }

  @java.lang.SuppressWarnings("all")
  public double getValue() {
    return this.value;
  }

  @java.lang.SuppressWarnings("all")
  public double getContractAmount() {
    return this.contractAmount;
  }

  @java.lang.SuppressWarnings("all")
  public int getGasUsed() {
    return this.gasUsed;
  }

  @java.lang.SuppressWarnings("all")
  public double getGasPrice() {
    return this.gasPrice;
  }

  @java.lang.SuppressWarnings("all")
  public double getTokenFee() {
    return this.tokenFee;
  }

  @java.lang.SuppressWarnings("all")
  public double getEtherFee() {
    return this.etherFee;
  }

  @java.lang.SuppressWarnings("all")
  public boolean isNoContractFunds() {
    return this.noContractFunds;
  }

  @java.lang.SuppressWarnings("all")
  public long getTimestamp() {
    return this.timestamp;
  }

  @java.lang.SuppressWarnings("all")
  public long getNonce() {
    return this.nonce;
  }

  @java.lang.SuppressWarnings("all")
  public String getRawTransaction() {
    return this.rawTransaction;
  }

  @java.lang.SuppressWarnings("all")
  public long getSentTimestamp() {
    return this.sentTimestamp;
  }

  @java.lang.SuppressWarnings("all")
  public long getSendingAttemptCount() {
    return this.sendingAttemptCount;
  }

  @java.lang.SuppressWarnings("all")
  public void setId(final long id) {
    this.id = id;
  }

  @java.lang.SuppressWarnings("all")
  public void setIssuer(final Wallet issuer) {
    this.issuer = issuer;
  }

  @java.lang.SuppressWarnings("all")
  public void setIssuerId(final long issuerId) {
    this.issuerId = issuerId;
  }

  @java.lang.SuppressWarnings("all")
  public void setNetworkId(final long networkId) {
    this.networkId = networkId;
  }

  @java.lang.SuppressWarnings("all")
  public void setHash(final String hash) {
    this.hash = hash;
  }

  @java.lang.SuppressWarnings("all")
  public void setContractAddress(final String contractAddress) {
    this.contractAddress = contractAddress;
  }

  @java.lang.SuppressWarnings("all")
  public void setContractMethodName(final String contractMethodName) {
    this.contractMethodName = contractMethodName;
  }

  @java.lang.SuppressWarnings("all")
  public void setPending(final boolean pending) {
    this.pending = pending;
  }

  @java.lang.SuppressWarnings("all")
  public void setSucceeded(final boolean succeeded) {
    this.succeeded = succeeded;
  }

  @java.lang.SuppressWarnings("all")
  public void setAdminOperation(final boolean isAdminOperation) {
    this.isAdminOperation = isAdminOperation;
  }

  @java.lang.SuppressWarnings("all")
  public void setFrom(final String from) {
    this.from = from;
  }

  @java.lang.SuppressWarnings("all")
  public void setFromWallet(final Wallet fromWallet) {
    this.fromWallet = fromWallet;
  }

  @java.lang.SuppressWarnings("all")
  public void setTo(final String to) {
    this.to = to;
  }

  @java.lang.SuppressWarnings("all")
  public void setToWallet(final Wallet toWallet) {
    this.toWallet = toWallet;
  }

  @java.lang.SuppressWarnings("all")
  public void setBy(final String by) {
    this.by = by;
  }

  @java.lang.SuppressWarnings("all")
  public void setByWallet(final Wallet byWallet) {
    this.byWallet = byWallet;
  }

  @java.lang.SuppressWarnings("all")
  public void setLabel(final String label) {
    this.label = label;
  }

  @java.lang.SuppressWarnings("all")
  public void setMessage(final String message) {
    this.message = message;
  }

  @java.lang.SuppressWarnings("all")
  public void setValue(final double value) {
    this.value = value;
  }

  @java.lang.SuppressWarnings("all")
  public void setContractAmount(final double contractAmount) {
    this.contractAmount = contractAmount;
  }

  @java.lang.SuppressWarnings("all")
  public void setGasUsed(final int gasUsed) {
    this.gasUsed = gasUsed;
  }

  @java.lang.SuppressWarnings("all")
  public void setGasPrice(final double gasPrice) {
    this.gasPrice = gasPrice;
  }

  @java.lang.SuppressWarnings("all")
  public void setTokenFee(final double tokenFee) {
    this.tokenFee = tokenFee;
  }

  @java.lang.SuppressWarnings("all")
  public void setEtherFee(final double etherFee) {
    this.etherFee = etherFee;
  }

  @java.lang.SuppressWarnings("all")
  public void setNoContractFunds(final boolean noContractFunds) {
    this.noContractFunds = noContractFunds;
  }

  @java.lang.SuppressWarnings("all")
  public void setTimestamp(final long timestamp) {
    this.timestamp = timestamp;
  }

  @java.lang.SuppressWarnings("all")
  public void setNonce(final long nonce) {
    this.nonce = nonce;
  }

  @java.lang.SuppressWarnings("all")
  public void setRawTransaction(final String rawTransaction) {
    this.rawTransaction = rawTransaction;
  }

  @java.lang.SuppressWarnings("all")
  public void setSentTimestamp(final long sentTimestamp) {
    this.sentTimestamp = sentTimestamp;
  }

  @java.lang.SuppressWarnings("all")
  public void setSendingAttemptCount(final long sendingAttemptCount) {
    this.sendingAttemptCount = sendingAttemptCount;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof TransactionDetail)) return false;
    final TransactionDetail other = (TransactionDetail) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    if (this.getId() != other.getId()) return false;
    if (this.getIssuerId() != other.getIssuerId()) return false;
    if (this.getNetworkId() != other.getNetworkId()) return false;
    final java.lang.Object this$hash = this.getHash();
    final java.lang.Object other$hash = other.getHash();
    if (this$hash == null ? other$hash != null : !this$hash.equals(other$hash)) return false;
    final java.lang.Object this$contractAddress = this.getContractAddress();
    final java.lang.Object other$contractAddress = other.getContractAddress();
    if (this$contractAddress == null ? other$contractAddress != null : !this$contractAddress.equals(other$contractAddress)) return false;
    final java.lang.Object this$contractMethodName = this.getContractMethodName();
    final java.lang.Object other$contractMethodName = other.getContractMethodName();
    if (this$contractMethodName == null ? other$contractMethodName != null : !this$contractMethodName.equals(other$contractMethodName)) return false;
    if (this.isPending() != other.isPending()) return false;
    if (this.isSucceeded() != other.isSucceeded()) return false;
    if (this.isAdminOperation() != other.isAdminOperation()) return false;
    final java.lang.Object this$from = this.getFrom();
    final java.lang.Object other$from = other.getFrom();
    if (this$from == null ? other$from != null : !this$from.equals(other$from)) return false;
    final java.lang.Object this$to = this.getTo();
    final java.lang.Object other$to = other.getTo();
    if (this$to == null ? other$to != null : !this$to.equals(other$to)) return false;
    final java.lang.Object this$by = this.getBy();
    final java.lang.Object other$by = other.getBy();
    if (this$by == null ? other$by != null : !this$by.equals(other$by)) return false;
    final java.lang.Object this$label = this.getLabel();
    final java.lang.Object other$label = other.getLabel();
    if (this$label == null ? other$label != null : !this$label.equals(other$label)) return false;
    final java.lang.Object this$message = this.getMessage();
    final java.lang.Object other$message = other.getMessage();
    if (this$message == null ? other$message != null : !this$message.equals(other$message)) return false;
    if (java.lang.Double.compare(this.getValue(), other.getValue()) != 0) return false;
    if (java.lang.Double.compare(this.getContractAmount(), other.getContractAmount()) != 0) return false;
    if (this.getGasUsed() != other.getGasUsed()) return false;
    if (java.lang.Double.compare(this.getGasPrice(), other.getGasPrice()) != 0) return false;
    if (java.lang.Double.compare(this.getTokenFee(), other.getTokenFee()) != 0) return false;
    if (java.lang.Double.compare(this.getEtherFee(), other.getEtherFee()) != 0) return false;
    if (this.isNoContractFunds() != other.isNoContractFunds()) return false;
    if (this.getTimestamp() != other.getTimestamp()) return false;
    if (this.getNonce() != other.getNonce()) return false;
    final java.lang.Object this$rawTransaction = this.getRawTransaction();
    final java.lang.Object other$rawTransaction = other.getRawTransaction();
    if (this$rawTransaction == null ? other$rawTransaction != null : !this$rawTransaction.equals(other$rawTransaction)) return false;
    if (this.getSentTimestamp() != other.getSentTimestamp()) return false;
    if (this.getSendingAttemptCount() != other.getSendingAttemptCount()) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof TransactionDetail;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final long $id = this.getId();
    result = result * PRIME + (int) ($id >>> 32 ^ $id);
    final long $issuerId = this.getIssuerId();
    result = result * PRIME + (int) ($issuerId >>> 32 ^ $issuerId);
    final long $networkId = this.getNetworkId();
    result = result * PRIME + (int) ($networkId >>> 32 ^ $networkId);
    final java.lang.Object $hash = this.getHash();
    result = result * PRIME + ($hash == null ? 43 : $hash.hashCode());
    final java.lang.Object $contractAddress = this.getContractAddress();
    result = result * PRIME + ($contractAddress == null ? 43 : $contractAddress.hashCode());
    final java.lang.Object $contractMethodName = this.getContractMethodName();
    result = result * PRIME + ($contractMethodName == null ? 43 : $contractMethodName.hashCode());
    result = result * PRIME + (this.isPending() ? 79 : 97);
    result = result * PRIME + (this.isSucceeded() ? 79 : 97);
    result = result * PRIME + (this.isAdminOperation() ? 79 : 97);
    final java.lang.Object $from = this.getFrom();
    result = result * PRIME + ($from == null ? 43 : $from.hashCode());
    final java.lang.Object $to = this.getTo();
    result = result * PRIME + ($to == null ? 43 : $to.hashCode());
    final java.lang.Object $by = this.getBy();
    result = result * PRIME + ($by == null ? 43 : $by.hashCode());
    final java.lang.Object $label = this.getLabel();
    result = result * PRIME + ($label == null ? 43 : $label.hashCode());
    final java.lang.Object $message = this.getMessage();
    result = result * PRIME + ($message == null ? 43 : $message.hashCode());
    final long $value = java.lang.Double.doubleToLongBits(this.getValue());
    result = result * PRIME + (int) ($value >>> 32 ^ $value);
    final long $contractAmount = java.lang.Double.doubleToLongBits(this.getContractAmount());
    result = result * PRIME + (int) ($contractAmount >>> 32 ^ $contractAmount);
    result = result * PRIME + this.getGasUsed();
    final long $gasPrice = java.lang.Double.doubleToLongBits(this.getGasPrice());
    result = result * PRIME + (int) ($gasPrice >>> 32 ^ $gasPrice);
    final long $tokenFee = java.lang.Double.doubleToLongBits(this.getTokenFee());
    result = result * PRIME + (int) ($tokenFee >>> 32 ^ $tokenFee);
    final long $etherFee = java.lang.Double.doubleToLongBits(this.getEtherFee());
    result = result * PRIME + (int) ($etherFee >>> 32 ^ $etherFee);
    result = result * PRIME + (this.isNoContractFunds() ? 79 : 97);
    final long $timestamp = this.getTimestamp();
    result = result * PRIME + (int) ($timestamp >>> 32 ^ $timestamp);
    final long $nonce = this.getNonce();
    result = result * PRIME + (int) ($nonce >>> 32 ^ $nonce);
    final java.lang.Object $rawTransaction = this.getRawTransaction();
    result = result * PRIME + ($rawTransaction == null ? 43 : $rawTransaction.hashCode());
    final long $sentTimestamp = this.getSentTimestamp();
    result = result * PRIME + (int) ($sentTimestamp >>> 32 ^ $sentTimestamp);
    final long $sendingAttemptCount = this.getSendingAttemptCount();
    result = result * PRIME + (int) ($sendingAttemptCount >>> 32 ^ $sendingAttemptCount);
    return result;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  public java.lang.String toString() {
    return "TransactionDetail(id=" + this.getId() + ", issuer=" + this.getIssuer() + ", issuerId=" + this.getIssuerId() + ", networkId=" + this.getNetworkId() + ", hash=" + this.getHash() + ", contractAddress=" + this.getContractAddress() + ", contractMethodName=" + this.getContractMethodName() + ", pending=" + this.isPending() + ", succeeded=" + this.isSucceeded() + ", isAdminOperation=" + this.isAdminOperation() + ", from=" + this.getFrom() + ", fromWallet=" + this.getFromWallet() + ", to=" + this.getTo() + ", toWallet=" + this.getToWallet() + ", by=" + this.getBy() + ", byWallet=" + this.getByWallet() + ", value=" + this.getValue() + ", contractAmount=" + this.getContractAmount() + ", gasUsed=" + this.getGasUsed() + ", gasPrice=" + this.getGasPrice() + ", tokenFee=" + this.getTokenFee() + ", etherFee=" + this.getEtherFee() + ", noContractFunds=" + this.isNoContractFunds() + ", timestamp=" + this.getTimestamp() + ", nonce=" + this.getNonce() + ", rawTransaction=" + this.getRawTransaction() + ", sentTimestamp=" + this.getSentTimestamp() + ", sendingAttemptCount=" + this.getSendingAttemptCount() + ")";
  }
}
