/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wallet.model.reward;

import java.io.Serializable;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.wallet.model.Wallet;
import org.exoplatform.wallet.model.reward.RewardPeriod;
import org.exoplatform.wallet.model.reward.RewardTeam;
import org.exoplatform.wallet.model.reward.WalletPluginReward;
import org.exoplatform.wallet.model.transaction.TransactionDetail;

public class WalletReward
implements Serializable {
    private static final long serialVersionUID = -4328398843364453949L;
    private Wallet wallet;
    private List<RewardTeam> teams;
    private TransactionDetail transaction;
    private Set<WalletPluginReward> rewards;
    private RewardPeriod period;

    public long getIdentityId() {
        return this.wallet == null ? 0L : this.wallet.getTechnicalId();
    }

    public boolean isEnabled() {
        if (this.wallet == null) {
            throw new IllegalStateException("wallet isn't loaded");
        }
        if (StringUtils.isNotBlank((CharSequence)this.wallet.getAddress()) && this.wallet.getIsApproved() == null) {
            throw new IllegalStateException("wallet blockchain state isn't loaded");
        }
        return this.wallet.isEnabled() && !this.wallet.isDeletedUser() && !this.wallet.isDisabledUser() && StringUtils.isNotBlank((CharSequence)this.wallet.getAddress()) && this.wallet.getIsApproved() != false;
    }

    public String getPoolName() {
        if (this.teams == null) {
            return null;
        }
        Set teamNames = this.teams.stream().map(RewardTeam::getName).collect(Collectors.toSet());
        return StringUtils.join(teamNames, (String)",");
    }

    public RewardTeam getTeam() {
        if (this.teams == null || this.teams.isEmpty()) {
            return null;
        }
        return this.teams.get(0);
    }

    public String getStatus() {
        if (this.transaction == null) {
            return null;
        }
        if (this.transaction.isPending()) {
            return "pending";
        }
        if (this.transaction.isSucceeded()) {
            return "success";
        }
        return "error";
    }

    public double getTokensSent() {
        if (this.transaction == null) {
            return 0.0;
        }
        return this.transaction.getContractAmount();
    }

    public double getTokensToSend() {
        if (this.rewards == null || this.rewards.isEmpty()) {
            return 0.0;
        }
        return this.rewards.stream().mapToDouble(reward -> reward.getAmount()).sum();
    }

    public double getPoolTokensToSend() {
        if (this.rewards == null || this.rewards.isEmpty()) {
            return 0.0;
        }
        return this.rewards.stream().filter(WalletPluginReward::isPoolsUsed).mapToDouble(reward -> reward.getAmount()).sum();
    }

    public Wallet getWallet() {
        return this.wallet;
    }

    public List<RewardTeam> getTeams() {
        return this.teams;
    }

    public TransactionDetail getTransaction() {
        return this.transaction;
    }

    public Set<WalletPluginReward> getRewards() {
        return this.rewards;
    }

    public RewardPeriod getPeriod() {
        return this.period;
    }

    public void setWallet(Wallet wallet) {
        this.wallet = wallet;
    }

    public void setTeams(List<RewardTeam> teams) {
        this.teams = teams;
    }

    public void setTransaction(TransactionDetail transaction) {
        this.transaction = transaction;
    }

    public void setRewards(Set<WalletPluginReward> rewards) {
        this.rewards = rewards;
    }

    public void setPeriod(RewardPeriod period) {
        this.period = period;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WalletReward)) {
            return false;
        }
        WalletReward other = (WalletReward)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Wallet this$wallet = this.getWallet();
        Wallet other$wallet = other.getWallet();
        return !(this$wallet == null ? other$wallet != null : !((Object)this$wallet).equals(other$wallet));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WalletReward;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Wallet $wallet = this.getWallet();
        result = result * 59 + ($wallet == null ? 43 : ((Object)$wallet).hashCode());
        return result;
    }

    public String toString() {
        return "WalletReward(wallet=" + this.getWallet() + ", teams=" + this.getTeams() + ", transaction=" + this.getTransaction() + ", rewards=" + this.getRewards() + ", period=" + this.getPeriod() + ")";
    }

    public WalletReward(Wallet wallet, List<RewardTeam> teams, TransactionDetail transaction, Set<WalletPluginReward> rewards, RewardPeriod period) {
        this.wallet = wallet;
        this.teams = teams;
        this.transaction = transaction;
        this.rewards = rewards;
        this.period = period;
    }

    public WalletReward() {
    }
}

