// Generated by delombok at Thu Mar 04 14:13:12 UTC 2021
/*
 * This file is part of the Meeds project (https://meeds.io/).
 * Copyright (C) 2020 Meeds Association
 * contact@meeds.io
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */
package org.exoplatform.wallet.model.reward;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import lombok.*;

public class RewardSettings implements Serializable, Cloneable {
  private static final long serialVersionUID = -8650247964730374760L;
  private RewardPeriodType periodType = RewardPeriodType.DEFAULT;
  private Set<RewardPluginSettings> pluginSettings;

  @Override
  public RewardSettings clone() {
    // NOSONAR
    try {
      return (RewardSettings) super.clone();
    } catch (CloneNotSupportedException e) {
      @SuppressWarnings("unchecked")
      Set<RewardPluginSettings> clonedPluginSettings = pluginSettings == null ? null : (Set<RewardPluginSettings>) new HashSet<>(pluginSettings).clone();
      return new RewardSettings(periodType, clonedPluginSettings);
    }
  }

  @java.lang.SuppressWarnings("all")
  public RewardPeriodType getPeriodType() {
    return this.periodType;
  }

  @java.lang.SuppressWarnings("all")
  public Set<RewardPluginSettings> getPluginSettings() {
    return this.pluginSettings;
  }

  @java.lang.SuppressWarnings("all")
  public void setPeriodType(final RewardPeriodType periodType) {
    this.periodType = periodType;
  }

  @java.lang.SuppressWarnings("all")
  public void setPluginSettings(final Set<RewardPluginSettings> pluginSettings) {
    this.pluginSettings = pluginSettings;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof RewardSettings)) return false;
    final RewardSettings other = (RewardSettings) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    final java.lang.Object this$periodType = this.getPeriodType();
    final java.lang.Object other$periodType = other.getPeriodType();
    if (this$periodType == null ? other$periodType != null : !this$periodType.equals(other$periodType)) return false;
    final java.lang.Object this$pluginSettings = this.getPluginSettings();
    final java.lang.Object other$pluginSettings = other.getPluginSettings();
    if (this$pluginSettings == null ? other$pluginSettings != null : !this$pluginSettings.equals(other$pluginSettings)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof RewardSettings;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  public int hashCode() {
    final int PRIME = 59;
    int result = 1;
    final java.lang.Object $periodType = this.getPeriodType();
    result = result * PRIME + ($periodType == null ? 43 : $periodType.hashCode());
    final java.lang.Object $pluginSettings = this.getPluginSettings();
    result = result * PRIME + ($pluginSettings == null ? 43 : $pluginSettings.hashCode());
    return result;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  public java.lang.String toString() {
    return "RewardSettings(periodType=" + this.getPeriodType() + ", pluginSettings=" + this.getPluginSettings() + ")";
  }

  @java.lang.SuppressWarnings("all")
  public RewardSettings() {
  }

  @java.lang.SuppressWarnings("all")
  public RewardSettings(final RewardPeriodType periodType, final Set<RewardPluginSettings> pluginSettings) {
    this.periodType = periodType;
    this.pluginSettings = pluginSettings;
  }
}
