/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wallet.rest;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.FormParam;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.exoplatform.wallet.model.transaction.TransactionDetail;
import org.exoplatform.wallet.service.WalletTokenAdminService;
import org.exoplatform.wallet.utils.WalletUtils;

@Path(value="/wallet/api/admin/transaction")
@RolesAllowed(value={"rewarding"})
@Tag(name="/wallet/api/admin/transaction", description="Manages admin wallet transactions to send on blockchain")
public class WalletAdminTransactionREST
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(WalletAdminTransactionREST.class);
    private WalletTokenAdminService walletTokenAdminService;

    @POST
    @Path(value="sendEther")
    @RolesAllowed(value={"rewarding"})
    @Operation(summary="Send ether using blockchain transaction from Admin wallet", method="POST", description="Send ether using blockchain transaction from Admin wallet and returns transaction hash")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response sendEther(@Parameter(description="receiver wallet address", required=true) @FormParam(value="receiver") String receiver, @Parameter(description="ether amount to send", required=true) @FormParam(value="etherAmount") double etherAmount, @Parameter(description="transaction label") @FormParam(value="transactionLabel") String transactionLabel, @Parameter(description="transaction message to send to receiver with transaction") @FormParam(value="transactionMessage") String transactionMessage) {
        String currentUserId = WalletUtils.getCurrentUserId();
        if (StringUtils.isBlank((String)receiver)) {
            return Response.status((int)400).build();
        }
        if (etherAmount <= 0.0) {
            LOG.warn("Wrong ether amount '{}' sent to server", new Object[]{etherAmount});
            return Response.status((int)400).build();
        }
        try {
            TransactionDetail transactionDetail = new TransactionDetail();
            transactionDetail.setTo(receiver);
            transactionDetail.setValue(etherAmount);
            transactionDetail.setLabel(transactionLabel);
            transactionDetail.setMessage(transactionMessage);
            transactionDetail = this.getWalletTokenAdminService().sendEther(transactionDetail, currentUserId);
            return Response.ok((Object)(transactionDetail == null ? "" : transactionDetail.getHash())).build();
        }
        catch (Exception e) {
            LOG.error("Error sending ether to wallet {}", new Object[]{receiver, e});
            return Response.serverError().build();
        }
    }

    @POST
    @Path(value="sendToken")
    @RolesAllowed(value={"rewarding"})
    @Operation(summary="Send tokens using blockchain transaction from Admin wallet", method="POST", description="Send tokens using blockchain transaction from Admin wallet and returns transaction hash")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Request fulfilled"), @ApiResponse(responseCode="400", description="Invalid query input"), @ApiResponse(responseCode="401", description="Unauthorized operation"), @ApiResponse(responseCode="500", description="Internal server error")})
    public Response sendToken(@Parameter(description="receiver wallet address", required=true) @FormParam(value="receiver") String receiver, @Parameter(description="transaction label") @FormParam(value="transactionLabel") String transactionLabel, @Parameter(description="transaction message to send to receiver with transaction") @FormParam(value="transactionMessage") String transactionMessage, @Parameter(description="value of token to send to receiver") @FormParam(value="tokenAmount") double tokenAmount) {
        String currentUserId = WalletUtils.getCurrentUserId();
        if (StringUtils.isBlank((String)receiver)) {
            return Response.status((int)400).build();
        }
        try {
            if (tokenAmount <= 0.0) {
                throw new IllegalStateException("Can't send tokens to wallet " + receiver + "because the value of token is not valid");
            }
            TransactionDetail transactionDetail = new TransactionDetail();
            transactionDetail.setTo(receiver);
            transactionDetail.setContractAmount(tokenAmount);
            transactionDetail.setLabel(transactionLabel);
            transactionDetail.setMessage(transactionMessage);
            transactionDetail = this.getWalletTokenAdminService().sendToken(transactionDetail, currentUserId);
            return Response.ok((Object)(transactionDetail == null ? "" : transactionDetail.getHash())).build();
        }
        catch (Exception e) {
            LOG.error("Error sending token to wallet {}", new Object[]{receiver, e});
            return Response.serverError().build();
        }
    }

    private WalletTokenAdminService getWalletTokenAdminService() {
        if (this.walletTokenAdminService == null) {
            this.walletTokenAdminService = (WalletTokenAdminService)CommonsUtils.getService(WalletTokenAdminService.class);
        }
        return this.walletTokenAdminService;
    }
}

