/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.wallet.service;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.addon.wallet.contract.ERTTokenV2;
import org.exoplatform.addon.wallet.fork.EventEncoder;
import org.exoplatform.addon.wallet.model.ContractDetail;
import org.exoplatform.addon.wallet.model.Wallet;
import org.exoplatform.addon.wallet.model.WalletInitializationState;
import org.exoplatform.addon.wallet.model.transaction.TransactionDetail;
import org.exoplatform.addon.wallet.service.EthereumClientConnector;
import org.exoplatform.addon.wallet.service.WalletAccountService;
import org.exoplatform.addon.wallet.service.WalletContractService;
import org.exoplatform.addon.wallet.utils.WalletUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.web3j.abi.EventValues;
import org.web3j.abi.FunctionReturnDecoder;
import org.web3j.abi.TypeReference;
import org.web3j.abi.datatypes.Event;
import org.web3j.abi.datatypes.Type;
import org.web3j.protocol.core.methods.response.EthBlock;
import org.web3j.protocol.core.methods.response.Transaction;
import org.web3j.protocol.core.methods.response.TransactionReceipt;

public class EthereumTransactionDecoder {
    private static final Log LOG = ExoLogger.getLogger(EthereumTransactionDecoder.class);
    private static final String FUNC_DEPOSIT_FUNDS = "depositFunds";
    private static final String TRANSFER_SIGNATURE = EventEncoder.encode(ERTTokenV2.TRANSFER_EVENT);
    private static final String APPROVAL_SIGNATURE = EventEncoder.encode(ERTTokenV2.APPROVAL_EVENT);
    private static final String ADDED_ADMIN_METHOD_SIGNATURE = EventEncoder.encode(ERTTokenV2.ADDEDADMIN_EVENT);
    private static final String REMOVED_ADMIN_SIGNATURE = EventEncoder.encode(ERTTokenV2.REMOVEDADMIN_EVENT);
    private static final String APPROVED_ACCOUNT_SIGNATURE = EventEncoder.encode(ERTTokenV2.APPROVEDACCOUNT_EVENT);
    private static final String DISAPPROVED_ACCOUNT_SIGNATURE = EventEncoder.encode(ERTTokenV2.DISAPPROVEDACCOUNT_EVENT);
    private static final String CONTRACT_PAUSED_SIGNATURE = EventEncoder.encode(ERTTokenV2.CONTRACTPAUSED_EVENT);
    private static final String CONTRACT_UNPAUSED_SIGNATURE = EventEncoder.encode(ERTTokenV2.CONTRACTUNPAUSED_EVENT);
    private static final String DEPOSIT_RECEIVED_SIGNATURE = EventEncoder.encode(ERTTokenV2.DEPOSITRECEIVED_EVENT);
    private static final String TOKEN_PRICE_CHANGED_SIGNATURE = EventEncoder.encode(ERTTokenV2.TOKENPRICECHANGED_EVENT);
    private static final String TRANSFER_OWNERSHIP_SIGNATURE = EventEncoder.encode(ERTTokenV2.TRANSFEROWNERSHIP_EVENT);
    private static final String ACCOUNT_INITIALIZATION_SIGNATURE = EventEncoder.encode(ERTTokenV2.INITIALIZATION_EVENT);
    private static final String ACCOUNT_REWARD_SIGNATURE = EventEncoder.encode(ERTTokenV2.REWARD_EVENT);
    private static final String ACCOUNT_VESTED_SIGNATURE = EventEncoder.encode(ERTTokenV2.VESTING_EVENT);
    private static final String TRANSFER_VESTING_SIGNATURE = EventEncoder.encode(ERTTokenV2.VESTINGTRANSFER_EVENT);
    private static final String UPGRADED_SIGNATURE = EventEncoder.encode(ERTTokenV2.UPGRADED_EVENT);
    private static final String DATA_UPGRADED_SIGNATURE = EventEncoder.encode(ERTTokenV2.UPGRADEDDATA_EVENT);
    private static final Map<String, String> CONTRACT_METHODS_BY_SIG = new HashMap<String, String>();
    private WalletAccountService accountService;
    private WalletContractService contractService;
    private EthereumClientConnector ethereumClientConnector;

    public EthereumTransactionDecoder(EthereumClientConnector ethereumClientConnector) {
        this.ethereumClientConnector = ethereumClientConnector;
    }

    public TransactionDetail computeTransactionDetail(long networkId, String hash, ContractDetail contractDetail) throws InterruptedException {
        if (StringUtils.isBlank((CharSequence)hash)) {
            throw new IllegalArgumentException("Transaction hash is empty");
        }
        if (networkId <= 0L) {
            throw new IllegalArgumentException("Unknown network id: " + networkId);
        }
        TransactionDetail transactionDetail = new TransactionDetail();
        transactionDetail.setNetworkId(networkId);
        transactionDetail.setHash(hash);
        return this.computeTransactionDetail(transactionDetail, contractDetail);
    }

    public TransactionDetail computeTransactionDetail(TransactionDetail transactionDetail, ContractDetail contractDetail) throws InterruptedException {
        if (transactionDetail == null) {
            throw new IllegalArgumentException("Empty transaction detail parameter");
        }
        String hash = transactionDetail.getHash();
        if (StringUtils.isBlank((CharSequence)hash)) {
            throw new IllegalStateException("Transaction hash is empty");
        }
        if (transactionDetail.getNetworkId() <= 0L) {
            throw new IllegalStateException("Unknown network id: " + transactionDetail.getNetworkId());
        }
        Transaction transaction = this.ethereumClientConnector.getTransaction(hash);
        if (transaction == null) {
            LOG.info("Can't find transaction with hash {}, it may be pending", new Object[]{hash});
            return transactionDetail;
        }
        EthBlock.Block block = this.ethereumClientConnector.getBlock(transaction.getBlockHash());
        transactionDetail.setTimestamp(block.getTimestamp().longValue() * 1000L);
        String senderAddress = transaction.getFrom();
        transactionDetail.setFrom(senderAddress);
        BigInteger weiAmount = transaction.getValue();
        transactionDetail.setValueDecimal(weiAmount, 18);
        TransactionReceipt transactionReceipt = this.ethereumClientConnector.getTransactionReceipt(hash);
        transactionDetail.setPending(transactionReceipt == null);
        transactionDetail.setSucceeded(transactionReceipt != null && transactionReceipt.isStatusOK());
        String receiverAddress = transaction.getTo();
        transactionDetail.setTo(receiverAddress);
        if (contractDetail == null && receiverAddress != null) {
            contractDetail = this.getContractService().getContractDetail(receiverAddress);
        }
        if (contractDetail != null && StringUtils.isNotBlank((CharSequence)contractDetail.getAddress())) {
            transactionDetail.setContractAddress(contractDetail.getAddress());
            this.computeContractTransactionDetail(contractDetail, transactionDetail, transactionReceipt);
        }
        return transactionDetail;
    }

    public void computeContractTransactionDetail(TransactionDetail transactionDetail, TransactionReceipt transactionReceipt) {
        this.computeContractTransactionDetail(null, transactionDetail, transactionReceipt);
    }

    public void computeContractTransactionDetail(ContractDetail contractDetail, TransactionDetail transactionDetail, TransactionReceipt transactionReceipt) {
        String toAddress;
        List logs = transactionReceipt == null ? null : transactionReceipt.getLogs();
        transactionDetail.setSucceeded(transactionReceipt != null && transactionReceipt.isStatusOK());
        if (!transactionDetail.isSucceeded()) {
            if (StringUtils.equals((CharSequence)transactionDetail.getContractMethodName(), (CharSequence)"initializeAccount")) {
                this.getAccountService().setInitializationStatus(transactionDetail.getTo(), WalletInitializationState.MODIFIED);
            }
            return;
        }
        String string = toAddress = transactionReceipt == null ? null : transactionReceipt.getTo();
        if (contractDetail == null) {
            contractDetail = this.getContractService().getContractDetail(StringUtils.lowerCase((String)toAddress));
        }
        if (contractDetail == null || !StringUtils.equalsIgnoreCase((CharSequence)toAddress, (CharSequence)contractDetail.getAddress())) {
            return;
        }
        Integer contractDecimals = contractDetail.getDecimals();
        String hash = transactionDetail.getHash();
        if (logs != null && !logs.isEmpty()) {
            int logsSize = logs.size();
            LOG.debug("Retrieving information from blockchain for transaction {} with {} LOGS", new Object[]{hash, logsSize});
            int i = 0;
            boolean transactionLogTreated = false;
            while (!transactionLogTreated && i < logsSize) {
                BigInteger amount;
                EventValues parameters;
                org.web3j.protocol.core.methods.response.Log log;
                List topics;
                if ((topics = (log = (org.web3j.protocol.core.methods.response.Log)logs.get(i++)).getTopics()) == null || topics.isEmpty()) {
                    LOG.warn("Transaction {} has NO topics", new Object[]{hash});
                    transactionDetail.setSucceeded(false);
                    continue;
                }
                String topic = (String)topics.get(0);
                LOG.debug("Treating transaction {} with {} topics", new Object[]{hash, topics.size()});
                String methodName = CONTRACT_METHODS_BY_SIG.get(topic);
                if (StringUtils.isBlank((CharSequence)methodName)) continue;
                transactionDetail.setContractMethodName(methodName);
                if (StringUtils.equals((CharSequence)methodName, (CharSequence)"transfer")) {
                    parameters = EthereumTransactionDecoder.extractEventParameters(ERTTokenV2.TRANSFER_EVENT, log);
                    if (parameters == null) continue;
                    transactionDetail.setFrom(((Type)parameters.getIndexedValues().get(0)).getValue().toString());
                    transactionDetail.setTo(((Type)parameters.getIndexedValues().get(1)).getValue().toString());
                    amount = (BigInteger)((Type)parameters.getNonIndexedValues().get(0)).getValue();
                    transactionDetail.setContractAmountDecimal(amount, contractDecimals.intValue());
                    if (!StringUtils.equals((CharSequence)transactionReceipt.getFrom(), (CharSequence)transactionDetail.getFrom())) {
                        transactionDetail.setBy(transactionReceipt.getFrom());
                        transactionDetail.setContractMethodName("transferFrom");
                    }
                    transactionDetail.setAdminOperation(false);
                    continue;
                }
                if (StringUtils.equals((CharSequence)methodName, (CharSequence)"approve")) {
                    transactionLogTreated = true;
                    parameters = EthereumTransactionDecoder.extractEventParameters(ERTTokenV2.APPROVAL_EVENT, log);
                    if (parameters == null) continue;
                    transactionDetail.setFrom(((Type)parameters.getIndexedValues().get(0)).getValue().toString());
                    transactionDetail.setTo(((Type)parameters.getIndexedValues().get(1)).getValue().toString());
                    amount = (BigInteger)((Type)parameters.getNonIndexedValues().get(0)).getValue();
                    transactionDetail.setContractAmountDecimal(amount, contractDecimals.intValue());
                    transactionDetail.setAdminOperation(false);
                    continue;
                }
                if (StringUtils.equals((CharSequence)methodName, (CharSequence)"approveAccount")) {
                    if (logsSize > 1) continue;
                    transactionLogTreated = true;
                    parameters = EthereumTransactionDecoder.extractEventParameters(ERTTokenV2.APPROVEDACCOUNT_EVENT, log);
                    transactionDetail.setFrom(transactionReceipt.getFrom());
                    if (parameters == null) continue;
                    transactionDetail.setTo(((Type)parameters.getNonIndexedValues().get(0)).getValue().toString());
                    transactionDetail.setAdminOperation(true);
                    continue;
                }
                if (StringUtils.equals((CharSequence)methodName, (CharSequence)"disapproveAccount")) {
                    transactionLogTreated = true;
                    parameters = EthereumTransactionDecoder.extractEventParameters(ERTTokenV2.DISAPPROVEDACCOUNT_EVENT, log);
                    if (parameters == null) continue;
                    transactionDetail.setFrom(transactionReceipt.getFrom());
                    transactionDetail.setTo(((Type)parameters.getNonIndexedValues().get(0)).getValue().toString());
                    transactionDetail.setAdminOperation(true);
                    continue;
                }
                if (StringUtils.equals((CharSequence)methodName, (CharSequence)"addAdmin")) {
                    transactionLogTreated = true;
                    parameters = EthereumTransactionDecoder.extractEventParameters(ERTTokenV2.ADDEDADMIN_EVENT, log);
                    if (parameters == null) continue;
                    transactionDetail.setFrom(transactionReceipt.getFrom());
                    transactionDetail.setTo(((Type)parameters.getNonIndexedValues().get(0)).getValue().toString());
                    transactionDetail.setContractAmount((double)((BigInteger)((Type)parameters.getNonIndexedValues().get(1)).getValue()).longValue());
                    transactionDetail.setAdminOperation(true);
                    continue;
                }
                if (StringUtils.equals((CharSequence)methodName, (CharSequence)"removeAdmin")) {
                    transactionLogTreated = true;
                    parameters = EthereumTransactionDecoder.extractEventParameters(ERTTokenV2.REMOVEDADMIN_EVENT, log);
                    if (parameters == null) continue;
                    transactionDetail.setFrom(transactionReceipt.getFrom());
                    transactionDetail.setTo(((Type)parameters.getNonIndexedValues().get(0)).getValue().toString());
                    transactionDetail.setAdminOperation(true);
                    continue;
                }
                if (StringUtils.equals((CharSequence)methodName, (CharSequence)"upgradeData")) {
                    transactionLogTreated = true;
                    parameters = EthereumTransactionDecoder.extractEventParameters(ERTTokenV2.UPGRADEDDATA_EVENT, log);
                    if (parameters == null) continue;
                    transactionDetail.setContractAmount((double)((BigInteger)((Type)parameters.getNonIndexedValues().get(0)).getValue()).longValue());
                    transactionDetail.setTo(((Type)parameters.getNonIndexedValues().get(1)).getValue().toString());
                    transactionDetail.setAdminOperation(true);
                    continue;
                }
                if (StringUtils.equals((CharSequence)methodName, (CharSequence)"upgradeImplementation")) {
                    transactionLogTreated = true;
                    parameters = EthereumTransactionDecoder.extractEventParameters(ERTTokenV2.UPGRADED_EVENT, log);
                    if (parameters == null) continue;
                    transactionDetail.setContractAmount((double)((BigInteger)((Type)parameters.getNonIndexedValues().get(0)).getValue()).longValue());
                    transactionDetail.setTo(((Type)parameters.getNonIndexedValues().get(1)).getValue().toString());
                    transactionDetail.setAdminOperation(true);
                    continue;
                }
                if (StringUtils.equals((CharSequence)methodName, (CharSequence)FUNC_DEPOSIT_FUNDS)) {
                    transactionLogTreated = true;
                    parameters = EthereumTransactionDecoder.extractEventParameters(ERTTokenV2.DEPOSITRECEIVED_EVENT, log);
                    if (parameters == null) continue;
                    transactionDetail.setFrom(((Type)parameters.getNonIndexedValues().get(0)).getValue().toString());
                    BigInteger weiAmount = (BigInteger)((Type)parameters.getNonIndexedValues().get(1)).getValue();
                    transactionDetail.setValueDecimal(weiAmount, 18);
                    transactionDetail.setAdminOperation(true);
                    continue;
                }
                if (StringUtils.equals((CharSequence)methodName, (CharSequence)"setSellPrice")) {
                    transactionLogTreated = true;
                    parameters = EthereumTransactionDecoder.extractEventParameters(ERTTokenV2.TOKENPRICECHANGED_EVENT, log);
                    if (parameters == null) continue;
                    transactionDetail.setContractAmount((double)((BigInteger)((Type)parameters.getNonIndexedValues().get(0)).getValue()).longValue());
                    transactionDetail.setAdminOperation(true);
                    continue;
                }
                if (StringUtils.equals((CharSequence)methodName, (CharSequence)"transformToVested")) {
                    transactionLogTreated = true;
                    parameters = EthereumTransactionDecoder.extractEventParameters(ERTTokenV2.VESTING_EVENT, log);
                    if (parameters == null) continue;
                    transactionDetail.setTo(((Type)parameters.getIndexedValues().get(0)).getValue().toString());
                    amount = (BigInteger)((Type)parameters.getNonIndexedValues().get(0)).getValue();
                    transactionDetail.setContractAmountDecimal(amount, contractDecimals.intValue());
                    transactionDetail.setAdminOperation(true);
                    continue;
                }
                if (StringUtils.equals((CharSequence)methodName, (CharSequence)"transferOwnership")) {
                    transactionLogTreated = true;
                    parameters = EthereumTransactionDecoder.extractEventParameters(ERTTokenV2.TRANSFEROWNERSHIP_EVENT, log);
                    if (parameters == null) continue;
                    transactionDetail.setTo(((Type)parameters.getNonIndexedValues().get(0)).getValue().toString());
                    transactionDetail.setAdminOperation(true);
                    continue;
                }
                if (StringUtils.equals((CharSequence)methodName, (CharSequence)"initializeAccount")) {
                    transactionLogTreated = true;
                    parameters = EthereumTransactionDecoder.extractEventParameters(ERTTokenV2.INITIALIZATION_EVENT, log);
                    if (parameters == null) continue;
                    transactionDetail.setFrom(((Type)parameters.getIndexedValues().get(0)).getValue().toString());
                    transactionDetail.setTo(((Type)parameters.getIndexedValues().get(1)).getValue().toString());
                    amount = (BigInteger)((Type)parameters.getNonIndexedValues().get(0)).getValue();
                    transactionDetail.setContractAmountDecimal(amount, contractDecimals.intValue());
                    BigInteger weiAmount = (BigInteger)((Type)parameters.getNonIndexedValues().get(1)).getValue();
                    transactionDetail.setValueDecimal(weiAmount, 18);
                    transactionDetail.setAdminOperation(false);
                    if (transactionDetail.isSucceeded()) {
                        this.getAccountService().setInitializationStatus(transactionDetail.getTo(), WalletInitializationState.INITIALIZED);
                        continue;
                    }
                    this.getAccountService().setInitializationStatus(transactionDetail.getTo(), WalletInitializationState.MODIFIED);
                    continue;
                }
                if (StringUtils.equals((CharSequence)methodName, (CharSequence)"reward")) {
                    transactionLogTreated = true;
                    parameters = EthereumTransactionDecoder.extractEventParameters(ERTTokenV2.REWARD_EVENT, log);
                    if (parameters == null) continue;
                    transactionDetail.setFrom(((Type)parameters.getIndexedValues().get(0)).getValue().toString());
                    transactionDetail.setTo(((Type)parameters.getIndexedValues().get(1)).getValue().toString());
                    amount = (BigInteger)((Type)parameters.getNonIndexedValues().get(0)).getValue();
                    transactionDetail.setValueDecimal(amount, contractDecimals.intValue());
                    amount = (BigInteger)((Type)parameters.getNonIndexedValues().get(1)).getValue();
                    transactionDetail.setContractAmountDecimal(amount, contractDecimals.intValue());
                    transactionDetail.setAdminOperation(false);
                    continue;
                }
                if (transactionLogTreated || i + 1 != logsSize) continue;
                LOG.warn("Can't find contract method name of transaction {}", new Object[]{transactionDetail});
            }
        }
        if (StringUtils.isNotBlank((CharSequence)transactionDetail.getFrom()) && WalletUtils.isWalletEmpty((Wallet)transactionDetail.getFromWallet())) {
            transactionDetail.setFromWallet(this.getAccountService().getWalletByAddress(transactionDetail.getFrom()));
        }
        if (StringUtils.isNotBlank((CharSequence)transactionDetail.getTo()) && WalletUtils.isWalletEmpty((Wallet)transactionDetail.getToWallet())) {
            transactionDetail.setToWallet(this.getAccountService().getWalletByAddress(transactionDetail.getTo()));
        }
        if (StringUtils.isNotBlank((CharSequence)transactionDetail.getBy()) && WalletUtils.isWalletEmpty((Wallet)transactionDetail.getByWallet())) {
            transactionDetail.setByWallet(this.getAccountService().getWalletByAddress(transactionDetail.getBy()));
        }
    }

    private static EventValues extractEventParameters(Event event, org.web3j.protocol.core.methods.response.Log log) {
        List topics = log.getTopics();
        String encodedEventSignature = EventEncoder.encode(event);
        if (!((String)topics.get(0)).equals(encodedEventSignature)) {
            return null;
        }
        ArrayList<Type> indexedValues = new ArrayList<Type>();
        List nonIndexedValues = FunctionReturnDecoder.decode((String)log.getData(), (List)event.getNonIndexedParameters());
        List indexedParameters = event.getIndexedParameters();
        for (int i = 0; i < indexedParameters.size(); ++i) {
            Type value = FunctionReturnDecoder.decodeIndexedValue((String)((String)topics.get(i + 1)), (TypeReference)((TypeReference)indexedParameters.get(i)));
            indexedValues.add(value);
        }
        return new EventValues(indexedValues, nonIndexedValues);
    }

    private WalletAccountService getAccountService() {
        if (this.accountService == null) {
            this.accountService = (WalletAccountService)CommonsUtils.getService(WalletAccountService.class);
        }
        return this.accountService;
    }

    public WalletContractService getContractService() {
        if (this.contractService == null) {
            this.contractService = (WalletContractService)CommonsUtils.getService(WalletContractService.class);
        }
        return this.contractService;
    }

    static {
        CONTRACT_METHODS_BY_SIG.put(TRANSFER_SIGNATURE, "transfer");
        CONTRACT_METHODS_BY_SIG.put(APPROVAL_SIGNATURE, "approve");
        CONTRACT_METHODS_BY_SIG.put(ADDED_ADMIN_METHOD_SIGNATURE, "addAdmin");
        CONTRACT_METHODS_BY_SIG.put(REMOVED_ADMIN_SIGNATURE, "removeAdmin");
        CONTRACT_METHODS_BY_SIG.put(APPROVED_ACCOUNT_SIGNATURE, "approveAccount");
        CONTRACT_METHODS_BY_SIG.put(DISAPPROVED_ACCOUNT_SIGNATURE, "disapproveAccount");
        CONTRACT_METHODS_BY_SIG.put(CONTRACT_PAUSED_SIGNATURE, "pause");
        CONTRACT_METHODS_BY_SIG.put(CONTRACT_UNPAUSED_SIGNATURE, "unPause");
        CONTRACT_METHODS_BY_SIG.put(DEPOSIT_RECEIVED_SIGNATURE, FUNC_DEPOSIT_FUNDS);
        CONTRACT_METHODS_BY_SIG.put(TOKEN_PRICE_CHANGED_SIGNATURE, "setSellPrice");
        CONTRACT_METHODS_BY_SIG.put(TRANSFER_OWNERSHIP_SIGNATURE, "transferOwnership");
        CONTRACT_METHODS_BY_SIG.put(ACCOUNT_INITIALIZATION_SIGNATURE, "initializeAccount");
        CONTRACT_METHODS_BY_SIG.put(ACCOUNT_REWARD_SIGNATURE, "reward");
        CONTRACT_METHODS_BY_SIG.put(ACCOUNT_VESTED_SIGNATURE, "transformToVested");
        CONTRACT_METHODS_BY_SIG.put(TRANSFER_VESTING_SIGNATURE, "transfer");
        CONTRACT_METHODS_BY_SIG.put(UPGRADED_SIGNATURE, "upgradeImplementation");
        CONTRACT_METHODS_BY_SIG.put(DATA_UPGRADED_SIGNATURE, "upgradeData");
    }
}

