/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.wallet.service;

import org.apache.commons.lang.StringUtils;
import org.exoplatform.addon.wallet.model.ContractDetail;
import org.exoplatform.addon.wallet.model.Wallet;
import org.exoplatform.addon.wallet.model.WalletType;
import org.exoplatform.addon.wallet.model.settings.GlobalSettings;
import org.exoplatform.addon.wallet.model.settings.InitialFundsSettings;
import org.exoplatform.addon.wallet.model.settings.UserSettings;
import org.exoplatform.addon.wallet.model.settings.WalletSettings;
import org.exoplatform.addon.wallet.model.transaction.FundsRequest;
import org.exoplatform.addon.wallet.service.EthereumClientConnector;
import org.exoplatform.addon.wallet.service.WalletAccountService;
import org.exoplatform.addon.wallet.service.WalletContractService;
import org.exoplatform.addon.wallet.service.WalletService;
import org.exoplatform.addon.wallet.utils.WalletUtils;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.service.storage.WebNotificationStorage;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.picocontainer.Startable;

public class EthereumWalletService
implements WalletService,
Startable {
    private static final Log LOG = ExoLogger.getLogger(EthereumWalletService.class);
    private ExoContainer container;
    private EthereumClientConnector clientConnector;
    private WalletContractService contractService;
    private WalletAccountService accountService;
    private SettingService settingService;
    private SpaceService spaceService;
    private WebNotificationStorage webNotificationStorage;
    private GlobalSettings configuredGlobalSettings = new GlobalSettings();

    public EthereumWalletService(EthereumClientConnector clientConnector, WalletContractService contractService, WalletAccountService accountService, WebNotificationStorage webNotificationStorage, PortalContainer container, InitParams params) {
        String value;
        this.container = container;
        this.clientConnector = clientConnector;
        this.accountService = accountService;
        this.contractService = contractService;
        this.webNotificationStorage = webNotificationStorage;
        if (params.containsKey((Object)"networkId")) {
            value = params.getValueParam("networkId").getValue();
            long defaultNetworkId = Long.parseLong(value);
            this.configuredGlobalSettings.getNetwork().setId(defaultNetworkId);
        }
        if (params.containsKey((Object)"networkURL")) {
            String defaultNetworkURL = params.getValueParam("networkURL").getValue();
            this.configuredGlobalSettings.getNetwork().setProviderURL(defaultNetworkURL);
        }
        if (params.containsKey((Object)"networkWSURL")) {
            String defaultNetworkWsURL = params.getValueParam("networkWSURL").getValue();
            this.configuredGlobalSettings.getNetwork().setWebsocketProviderURL(defaultNetworkWsURL);
        }
        if (params.containsKey((Object)"accessPermission")) {
            String defaultAccessPermission = params.getValueParam("accessPermission").getValue();
            this.configuredGlobalSettings.setAccessPermission(defaultAccessPermission);
        }
        if (params.containsKey((Object)"gasLimit")) {
            value = params.getValueParam("gasLimit").getValue();
            long gasLimit = Long.parseLong(value);
            this.configuredGlobalSettings.getNetwork().setGasLimit(Long.valueOf(gasLimit));
        }
        if (params.containsKey((Object)"cheapGasPrice")) {
            value = params.getValueParam("cheapGasPrice").getValue();
            long minGasPrice = Long.parseLong(value);
            this.configuredGlobalSettings.getNetwork().setMinGasPrice(Long.valueOf(minGasPrice));
        }
        if (params.containsKey((Object)"normalGasPrice")) {
            value = params.getValueParam("normalGasPrice").getValue();
            long normalGasPrice = Long.parseLong(value);
            this.configuredGlobalSettings.getNetwork().setNormalGasPrice(Long.valueOf(normalGasPrice));
        }
        if (params.containsKey((Object)"fastGasPrice")) {
            value = params.getValueParam("fastGasPrice").getValue();
            long maxGasPrice = Long.parseLong(value);
            this.configuredGlobalSettings.getNetwork().setMaxGasPrice(Long.valueOf(maxGasPrice));
        }
        if (params.containsKey((Object)"tokenAddress")) {
            String contractAddress = params.getValueParam("tokenAddress").getValue();
            this.configuredGlobalSettings.setContractAddress(contractAddress);
        }
    }

    public void start() {
        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
        RequestLifeCycle.begin((ExoContainer)this.container);
        try {
            this.configuredGlobalSettings.setContractAbi(this.contractService.getContractAbi().toString());
            this.configuredGlobalSettings.setContractBin(this.contractService.getContractBinary());
            this.computeInitialFundsSettings();
            String contractAddress = this.configuredGlobalSettings.getContractAddress();
            if (StringUtils.isBlank((String)contractAddress)) {
                return;
            }
            ContractDetail contractDetail = this.contractService.getContractDetail(contractAddress);
            this.configuredGlobalSettings.setContractDetail(contractDetail);
            this.clientConnector.start(this.configuredGlobalSettings.getNetwork().getWebsocketProviderURL());
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    public void stop() {
        this.clientConnector.stop();
    }

    public void setConfiguredContractDetail(ContractDetail contractDetail) {
        this.configuredGlobalSettings.setContractDetail(contractDetail);
    }

    public void saveInitialFundsSettings(InitialFundsSettings initialFundsSettings) {
        if (initialFundsSettings == null) {
            throw new IllegalArgumentException("initialFundsSettings parameter is mandatory");
        }
        LOG.debug("Saving initial funds settings: {}", new Object[]{initialFundsSettings});
        this.getSettingService().set(WalletUtils.WALLET_CONTEXT, WalletUtils.WALLET_SCOPE, "INITIAL_FUNDS", SettingValue.create((String)WalletUtils.toJsonString((Object)initialFundsSettings)));
        this.configuredGlobalSettings.setInitialFunds(initialFundsSettings);
    }

    public GlobalSettings getSettings() {
        return this.configuredGlobalSettings.clone();
    }

    public UserSettings getUserSettings(String spaceId, String currentUser) {
        GlobalSettings globalSettings = this.getSettings();
        UserSettings userSettings = new UserSettings(globalSettings);
        userSettings.setAdmin(WalletUtils.isUserAdmin((String)currentUser));
        userSettings.setWalletEnabled(true);
        String accessPermission = globalSettings.getAccessPermission();
        if (StringUtils.isNotBlank((String)accessPermission)) {
            Space space = WalletUtils.getSpace((String)accessPermission);
            if (!WalletUtils.isUserMemberOf((String)currentUser, (String)accessPermission) && space != null && !this.getSpaceService().isMember(space, currentUser)) {
                LOG.debug("Wallet is disabled for user {} because he's not member of permission expression {}", new Object[]{currentUser, accessPermission});
                userSettings.setWalletEnabled(false);
                return userSettings;
            }
        }
        Wallet wallet = null;
        if (StringUtils.isNotBlank((String)spaceId)) {
            wallet = this.accountService.getWalletByTypeAndId(WalletType.SPACE.getId(), spaceId, currentUser);
            if (wallet != null && !WalletUtils.canAccessWallet((Wallet)wallet, (String)currentUser)) {
                LOG.warn("User {} is not allowed to display space wallet {}", new Object[]{currentUser, spaceId});
                userSettings.setWalletEnabled(false);
            }
        } else {
            wallet = this.accountService.getWalletByTypeAndId(WalletType.USER.getId(), currentUser, currentUser);
        }
        if (wallet != null) {
            userSettings.setWalletEnabled(userSettings.isWalletEnabled() && wallet.isEnabled());
        }
        if (userSettings.isWalletEnabled() || userSettings.isAdmin()) {
            SettingValue userSettingsValue = this.getSettingService().get(Context.USER.id(currentUser), WalletUtils.WALLET_SCOPE, "ADDONS_ETHEREUM_WALLET_SETTINGS");
            WalletSettings walletSettings = null;
            walletSettings = userSettingsValue != null && userSettingsValue.getValue() != null ? (WalletSettings)WalletUtils.fromJsonString((String)userSettingsValue.getValue().toString(), WalletSettings.class) : new WalletSettings();
            userSettings.setUserPreferences(walletSettings);
            if (wallet != null) {
                walletSettings.setWalletAddress(wallet.getAddress());
                if (this.accountService.isWalletOwner(wallet, currentUser)) {
                    walletSettings.setPhrase(wallet.getPassPhrase());
                    walletSettings.setHasKeyOnServerSide(wallet.isHasPrivateKey());
                } else {
                    WalletUtils.hideWalletOwnerPrivateInformation((Wallet)wallet);
                }
                userSettings.setWallet(wallet);
            }
            walletSettings.setAddresesLabels(this.accountService.getAddressesLabelsVisibleBy(currentUser));
        }
        return userSettings;
    }

    public void saveUserPreferences(String currentUser, WalletSettings userPreferences) {
        if (userPreferences == null) {
            throw new IllegalArgumentException("userPreferences parameter is mandatory");
        }
        this.getSettingService().set(Context.USER.id(currentUser), WalletUtils.WALLET_SCOPE, "ADDONS_ETHEREUM_WALLET_SETTINGS", SettingValue.create((String)WalletUtils.toJsonString((Object)userPreferences)));
    }

    public void requestFunds(FundsRequest fundsRequest, String currentUser) throws IllegalAccessException {
        Wallet requestSender = this.accountService.getWalletByAddress(fundsRequest.getAddress());
        if (StringUtils.isNotBlank((String)currentUser)) {
            if (requestSender == null) {
                throw new IllegalStateException("Bad request sent to server with unknown sender address");
            }
            String requestSenderId = requestSender.getId();
            String requestSenderType = requestSender.getType();
            if (WalletType.isUser((String)requestSenderType) && !StringUtils.equals((String)currentUser, (String)requestSenderId)) {
                LOG.warn("Bad request sent to server with invalid sender type or id {} / {}", new Object[]{requestSenderType, requestSenderId});
                throw new IllegalAccessException("Bad request sent to server with invalid sender");
            }
            if (WalletType.isSpace((String)requestSenderType) && !WalletUtils.isUserSpaceMember((String)requestSenderId, (String)fundsRequest.getReceipient())) {
                throw new IllegalAccessException("Request sender is not allowed to request funds from space");
            }
        }
        NotificationContext ctx = NotificationContextImpl.cloneInstance();
        GlobalSettings settings = this.getSettings();
        if (!StringUtils.isBlank((String)fundsRequest.getContract())) {
            ContractDetail contractDetail = settings.getContractDetail();
            if (contractDetail == null) {
                throw new IllegalStateException("Bad request sent to server with invalid contract address (O ly default addresses are permitted)");
            }
            ctx.append(WalletUtils.CONTRACT_DETAILS_PARAMETER, (Object)contractDetail);
        }
        String requestReceipientId = fundsRequest.getReceipient();
        String requestReceipientType = fundsRequest.getReceipientType();
        Wallet requestReceipient = this.accountService.getWalletByTypeAndId(WalletType.getType((String)requestReceipientType).getId(), requestReceipientId);
        if (requestReceipient == null || requestReceipient.getTechnicalId() == 0L) {
            LOG.warn("Can't find fund request recipient with id {} and type {}", new Object[]{requestReceipientId, requestReceipientType});
        }
        ctx.append(WalletUtils.FUNDS_REQUEST_SENDER_DETAIL_PARAMETER, (Object)this.accountService.getWalletByTypeAndId(WalletType.USER.getId(), WalletUtils.getCurrentUserId()));
        ctx.append(WalletUtils.SENDER_ACCOUNT_DETAIL_PARAMETER, (Object)requestSender);
        ctx.append(WalletUtils.RECEIVER_ACCOUNT_DETAIL_PARAMETER, (Object)requestReceipient);
        ctx.append(WalletUtils.FUNDS_REQUEST_PARAMETER, (Object)fundsRequest);
        ctx.getNotificationExecutor().with(ctx.makeCommand(PluginKey.key((String)"FundsRequestNotificationPlugin"))).execute(ctx);
    }

    public void markFundRequestAsSent(String notificationId, String currentUser) throws IllegalAccessException {
        NotificationInfo notificationInfo = this.webNotificationStorage.get(notificationId);
        if (notificationInfo == null) {
            throw new IllegalStateException("Notification with id " + notificationId + " wasn't found");
        }
        if (notificationInfo.getTo() == null || !currentUser.equals(notificationInfo.getTo())) {
            throw new IllegalAccessException("Target user of notification '" + notificationId + "' is different from current user");
        }
        notificationInfo.getOwnerParameter().put("sent", "true");
        this.webNotificationStorage.update(notificationInfo, false);
    }

    public boolean isFundRequestSent(String notificationId, String currentUser) throws IllegalAccessException {
        NotificationInfo notificationInfo = this.webNotificationStorage.get(notificationId);
        if (notificationInfo == null) {
            throw new IllegalStateException("Notification with id " + notificationId + " wasn't found");
        }
        if (notificationInfo.getTo() == null || !currentUser.equals(notificationInfo.getTo())) {
            throw new IllegalAccessException("Target user of notification '" + notificationId + "' is different from current user");
        }
        String fundRequestSentString = (String)notificationInfo.getOwnerParameter().get("sent");
        return Boolean.parseBoolean(fundRequestSentString);
    }

    private void computeInitialFundsSettings() {
        SettingValue initialFundsSettingsValue = this.getSettingService().get(WalletUtils.WALLET_CONTEXT, WalletUtils.WALLET_SCOPE, "INITIAL_FUNDS");
        if (initialFundsSettingsValue != null && initialFundsSettingsValue.getValue() != null) {
            this.configuredGlobalSettings.setInitialFunds((InitialFundsSettings)WalletUtils.fromJsonString((String)initialFundsSettingsValue.getValue().toString(), InitialFundsSettings.class));
        }
    }

    private SettingService getSettingService() {
        if (this.settingService == null) {
            this.settingService = (SettingService)CommonsUtils.getService(SettingService.class);
        }
        return this.settingService;
    }

    private SpaceService getSpaceService() {
        if (this.spaceService == null) {
            this.spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
        }
        return this.spaceService;
    }
}

