/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.wallet.reward.service;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.exoplatform.addon.wallet.model.reward.RewardTeam;
import org.exoplatform.addon.wallet.model.reward.RewardTeamMember;
import org.exoplatform.addon.wallet.reward.dao.RewardTeamDAO;
import org.exoplatform.addon.wallet.reward.entity.RewardTeamEntity;
import org.exoplatform.addon.wallet.reward.entity.RewardTeamMemberEntity;
import org.exoplatform.addon.wallet.reward.service.RewardTeamService;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

public class WalletRewardTeamService
implements RewardTeamService {
    private RewardTeamDAO rewardTeamDAO;

    public WalletRewardTeamService(RewardTeamDAO rewardTeamDAO) {
        this.rewardTeamDAO = rewardTeamDAO;
    }

    public List<RewardTeam> getTeams() {
        List teamEntities = this.rewardTeamDAO.findAll();
        return teamEntities.stream().map(teamEntity -> WalletRewardTeamService.toDTO(teamEntity)).collect(Collectors.toList());
    }

    public RewardTeam saveTeam(RewardTeam rewardTeam) {
        if (rewardTeam == null) {
            throw new IllegalArgumentException("Empty team to save");
        }
        RewardTeamEntity teamEntity = WalletRewardTeamService.fromDTO(rewardTeam);
        teamEntity = teamEntity.getId() == null || teamEntity.getId() == 0L ? (RewardTeamEntity)this.rewardTeamDAO.create(teamEntity) : (RewardTeamEntity)this.rewardTeamDAO.update(teamEntity);
        return WalletRewardTeamService.toDTO((RewardTeamEntity)this.rewardTeamDAO.find(teamEntity.getId()));
    }

    public RewardTeam removeTeam(Long id) {
        if (id == null || id == 0L) {
            throw new IllegalArgumentException("Team id is required");
        }
        RewardTeamEntity entity = (RewardTeamEntity)this.rewardTeamDAO.find(id);
        if (entity != null) {
            this.rewardTeamDAO.delete(entity);
        }
        return WalletRewardTeamService.toDTO(entity);
    }

    private static RewardTeamEntity fromDTO(RewardTeam rewardTeam) {
        if (rewardTeam == null) {
            return null;
        }
        RewardTeamEntity teamEntity = new RewardTeamEntity();
        teamEntity.setId(rewardTeam.getId() == null || rewardTeam.getId() == 0L ? null : rewardTeam.getId());
        teamEntity.setName(rewardTeam.getName());
        teamEntity.setDescription(rewardTeam.getDescription());
        teamEntity.setBudget(rewardTeam.getBudget());
        teamEntity.setRewardType(rewardTeam.getRewardType());
        teamEntity.setRewardPerMember(rewardTeam.getRewardPerMember());
        teamEntity.setDisabled(rewardTeam.isDisabled());
        if (rewardTeam.getManager() != null && rewardTeam.getManager().getIdentityId() != 0L) {
            teamEntity.setManager(rewardTeam.getManager().getIdentityId());
        }
        if (rewardTeam.getSpaceId() != null && rewardTeam.getSpaceId() != 0L) {
            teamEntity.setSpaceId(rewardTeam.getSpaceId());
        }
        if (rewardTeam.getMembers() != null && !rewardTeam.getMembers().isEmpty()) {
            teamEntity.setMembers(rewardTeam.getMembers().stream().map(rewardTeamMember -> WalletRewardTeamService.getRewardTeamMemberEntity(teamEntity, rewardTeamMember)).collect(Collectors.toSet()));
        }
        return teamEntity;
    }

    private static RewardTeam toDTO(RewardTeamEntity teamEntity) {
        SpaceService spaceService;
        Space space;
        if (teamEntity == null) {
            return null;
        }
        RewardTeam rewardTeam = new RewardTeam();
        rewardTeam.setId(teamEntity.getId());
        rewardTeam.setName(teamEntity.getName());
        rewardTeam.setDescription(teamEntity.getDescription());
        rewardTeam.setBudget(teamEntity.getBudget());
        rewardTeam.setManager(WalletRewardTeamService.getRewardTeamMember(teamEntity.getManager()));
        rewardTeam.setRewardType(teamEntity.getRewardType());
        rewardTeam.setRewardPerMember(teamEntity.getRewardPerMember());
        rewardTeam.setDisabled(teamEntity.getDisabled().booleanValue());
        if (teamEntity.getSpaceId() != null && teamEntity.getSpaceId() != 0L && (space = (spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class)).getSpaceById(String.valueOf(teamEntity.getSpaceId()))) != null) {
            rewardTeam.setSpaceId(teamEntity.getSpaceId());
            rewardTeam.setSpacePrettyName(space.getPrettyName());
        }
        if (teamEntity.getMembers() != null && !teamEntity.getMembers().isEmpty()) {
            List list = teamEntity.getMembers().stream().map(teamMemberEntity -> WalletRewardTeamService.getRewardTeamMember(teamMemberEntity)).collect(Collectors.toList());
            rewardTeam.setMembers(new ArrayList(list));
        }
        return rewardTeam;
    }

    private static RewardTeamMemberEntity getRewardTeamMemberEntity(RewardTeamEntity teamEntity, RewardTeamMember rewardTeamMember) {
        if (rewardTeamMember == null) {
            return null;
        }
        RewardTeamMemberEntity teamMemberEntity = new RewardTeamMemberEntity();
        teamMemberEntity.setId(rewardTeamMember.getTechnicalId() == null || rewardTeamMember.getTechnicalId() == 0L ? null : rewardTeamMember.getTechnicalId());
        teamMemberEntity.setIdentityId(rewardTeamMember.getIdentityId());
        teamMemberEntity.setTeam(teamEntity);
        return teamMemberEntity;
    }

    private static RewardTeamMember getRewardTeamMember(RewardTeamMemberEntity teamMemberEntity) {
        if (teamMemberEntity == null) {
            return null;
        }
        RewardTeamMember rewardTeamMember = WalletRewardTeamService.getRewardTeamMember(teamMemberEntity.getIdentityId());
        if (rewardTeamMember == null) {
            return null;
        }
        rewardTeamMember.setTechnicalId(Long.valueOf(teamMemberEntity.getId()));
        return rewardTeamMember;
    }

    private static RewardTeamMember getRewardTeamMember(Long identityId) {
        if (identityId == null || identityId == 0L) {
            return null;
        }
        IdentityManager identityManager = (IdentityManager)CommonsUtils.getService(IdentityManager.class);
        Identity identity = identityManager.getIdentity(String.valueOf(identityId), true);
        if (identity == null) {
            return null;
        }
        RewardTeamMember rewardTeamMember = new RewardTeamMember();
        rewardTeamMember.setId(identity.getRemoteId());
        rewardTeamMember.setProviderId(identity.getProviderId());
        rewardTeamMember.setIdentityId(Long.valueOf(Long.parseLong(identity.getId())));
        return rewardTeamMember;
    }
}

