/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.wallet.storage;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.addon.wallet.dao.WalletAccountDAO;
import org.exoplatform.addon.wallet.dao.WalletPrivateKeyDAO;
import org.exoplatform.addon.wallet.entity.WalletEntity;
import org.exoplatform.addon.wallet.entity.WalletPrivateKeyEntity;
import org.exoplatform.addon.wallet.model.Wallet;
import org.exoplatform.addon.wallet.model.WalletInitializationState;
import org.exoplatform.addon.wallet.model.WalletType;
import org.exoplatform.addon.wallet.utils.WalletUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.web.security.codec.AbstractCodec;
import org.exoplatform.web.security.codec.CodecInitializer;

public class WalletStorage {
    private static final Log LOG = ExoLogger.getLogger(WalletStorage.class);
    private WalletAccountDAO walletAccountDAO;
    private WalletPrivateKeyDAO privateKeyDAO;
    private AbstractCodec codec;

    public WalletStorage(WalletAccountDAO walletAccountDAO, WalletPrivateKeyDAO privateKeyDAO, CodecInitializer codecInitializer) {
        this.walletAccountDAO = walletAccountDAO;
        this.privateKeyDAO = privateKeyDAO;
        try {
            this.codec = codecInitializer.getCodec();
        }
        catch (Exception e) {
            LOG.error((Object)"Error initializing codecs", (Throwable)e);
        }
    }

    public Set<Wallet> listWallets() {
        List walletEntities = this.walletAccountDAO.findAll();
        if (walletEntities == null || walletEntities.isEmpty()) {
            return Collections.emptySet();
        }
        return walletEntities.stream().map(this::fromEntity).filter(wallet -> StringUtils.isNotBlank((CharSequence)wallet.getType())).collect(Collectors.toSet());
    }

    public long getWalletsCount() {
        return this.walletAccountDAO.count();
    }

    public Wallet getWalletByIdentityId(long identityId) {
        WalletEntity walletEntity = (WalletEntity)this.walletAccountDAO.find(Long.valueOf(identityId));
        if (walletEntity == null) {
            return null;
        }
        return this.fromEntity(walletEntity);
    }

    public Wallet getWalletByAddress(String address) {
        WalletEntity walletEntity = this.walletAccountDAO.findByAddress(address.toLowerCase());
        if (walletEntity == null) {
            return null;
        }
        return this.fromEntity(walletEntity);
    }

    public Wallet saveWallet(Wallet wallet, boolean isNew) {
        WalletEntity walletEntity = this.toEntity(wallet);
        walletEntity = isNew ? (WalletEntity)this.walletAccountDAO.create(walletEntity) : (WalletEntity)this.walletAccountDAO.update(walletEntity);
        return this.fromEntity(walletEntity);
    }

    public Wallet saveWalletBackupState(long identityId, boolean backupState) {
        WalletEntity walletEntity = (WalletEntity)this.walletAccountDAO.find(Long.valueOf(identityId));
        walletEntity.setBackedUp(backupState);
        walletEntity = (WalletEntity)this.walletAccountDAO.update(walletEntity);
        return this.fromEntity(walletEntity);
    }

    public Wallet removeWallet(long identityId) {
        WalletEntity walletEntity = (WalletEntity)this.walletAccountDAO.find(Long.valueOf(identityId));
        this.walletAccountDAO.delete(walletEntity);
        return this.fromEntity(walletEntity);
    }

    public String getWalletPrivateKey(long walletId) {
        WalletPrivateKeyEntity privateKeyEntity = this.privateKeyDAO.findByWalletId(walletId);
        if (privateKeyEntity != null && StringUtils.isNotBlank((CharSequence)privateKeyEntity.getKeyContent())) {
            String privateKey = privateKeyEntity.getKeyContent();
            return this.decodeWalletKey(privateKey);
        }
        return null;
    }

    public void removeWalletPrivateKey(long walletId) {
        WalletPrivateKeyEntity privateKeyEntity = this.privateKeyDAO.findByWalletId(walletId);
        if (privateKeyEntity != null) {
            WalletEntity wallet = privateKeyEntity.getWallet();
            this.privateKeyDAO.delete(privateKeyEntity);
            wallet.setPrivateKey(null);
            this.walletAccountDAO.update(wallet);
        }
    }

    public void saveWalletPrivateKey(long walletId, String content) {
        if (StringUtils.isBlank((CharSequence)content)) {
            throw new IllegalArgumentException("content is mandatory");
        }
        WalletEntity walletEntity = (WalletEntity)this.walletAccountDAO.find(Long.valueOf(walletId));
        if (walletEntity == null) {
            throw new IllegalStateException("Wallet with id " + walletId + " wasn't found");
        }
        WalletPrivateKeyEntity privateKey = walletEntity.getPrivateKey();
        if (privateKey == null) {
            privateKey = new WalletPrivateKeyEntity();
            privateKey.setId(null);
            privateKey.setWallet(walletEntity);
            walletEntity.setPrivateKey(privateKey);
        } else if (StringUtils.isNotBlank((CharSequence)privateKey.getKeyContent())) {
            LOG.info("Replacing wallet {}/{} private key", new Object[]{walletEntity.getType(), walletEntity.getId()});
        }
        privateKey.setKeyContent(this.encodeWalletKey(content));
        if (privateKey.getId() == null) {
            this.privateKeyDAO.create(privateKey);
        } else {
            this.privateKeyDAO.update(privateKey);
        }
    }

    private String decodeWalletKey(String content) {
        return this.codec.decode(content);
    }

    private String encodeWalletKey(String content) {
        return this.codec.encode(content);
    }

    private Wallet fromEntity(WalletEntity walletEntity) {
        Wallet wallet = new Wallet();
        wallet.setTechnicalId(walletEntity.getId().longValue());
        wallet.setAddress(walletEntity.getAddress());
        wallet.setPassPhrase(walletEntity.getPassPhrase());
        wallet.setEnabled(walletEntity.isEnabled());
        wallet.setInitializationState(walletEntity.getInitializationState().name());
        wallet.setBackedUp(walletEntity.isBackedUp());
        if (walletEntity.getPrivateKey() == null) {
            WalletPrivateKeyEntity privateKey = this.privateKeyDAO.findByWalletId(walletEntity.getId());
            wallet.setHasPrivateKey(privateKey != null);
        } else {
            wallet.setHasPrivateKey(true);
        }
        Identity identity = WalletUtils.getIdentityById((long)walletEntity.getId());
        WalletUtils.computeWalletFromIdentity((Wallet)wallet, (Identity)identity);
        return wallet;
    }

    private WalletEntity toEntity(Wallet wallet) {
        WalletEntity walletEntity = new WalletEntity();
        walletEntity.setId(wallet.getTechnicalId());
        walletEntity.setAddress(wallet.getAddress().toLowerCase());
        walletEntity.setEnabled(wallet.isEnabled());
        walletEntity.setInitializationState(WalletInitializationState.valueOf((String)wallet.getInitializationState()));
        walletEntity.setPassPhrase(wallet.getPassPhrase());
        walletEntity.setBackedUp(wallet.isBackedUp());
        walletEntity.setType(WalletType.getType((String)wallet.getType()));
        return walletEntity;
    }
}

