/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.wallet.reward.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.Set;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.exoplatform.addon.wallet.model.reward.WalletReward;
import org.exoplatform.addon.wallet.reward.service.RewardService;
import org.exoplatform.addon.wallet.utils.WalletUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;
import org.json.JSONException;
import org.json.JSONObject;

@Path(value="/wallet/api/reward/")
@RolesAllowed(value={"rewarding"})
@Api(value="/wallet/api/reward", description="Manage wallet rewards")
public class RewardBudgetREST
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(RewardBudgetREST.class);
    private RewardService rewardService;

    public RewardBudgetREST(RewardService rewardService) {
        this.rewardService = rewardService;
    }

    @GET
    @Path(value="compute")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"rewarding"})
    @ApiOperation(value="Compute rewards of wallets per a chosen period of time", httpMethod="GET", response=Response.class, produces="application/json", notes="returns a set of wallet reward object")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=403, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response computeRewards(@ApiParam(value="Start date of period in milliseconds", required=true) @QueryParam(value="periodDateInSeconds") long periodDateInSeconds) {
        try {
            Set<WalletReward> rewards = this.rewardService.computeReward(periodDateInSeconds);
            return Response.ok(rewards).build();
        }
        catch (Exception e) {
            LOG.error((Object)"Error getting computed reward", (Throwable)e);
            JSONObject object = new JSONObject();
            try {
                object.append("error", (Object)e.getMessage());
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            return Response.status((int)500).type("application/json").entity((Object)object.toString()).build();
        }
    }

    @GET
    @Path(value="send")
    @RolesAllowed(value={"rewarding"})
    @ApiOperation(value="Send rewards of wallets per a chosen period of time", httpMethod="GET", response=Response.class, notes="return empty response")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=403, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response sendRewards(@ApiParam(value="Start date of period in milliseconds", required=true) @QueryParam(value="periodDateInSeconds") long periodDateInSeconds) {
        try {
            this.rewardService.sendRewards(periodDateInSeconds, WalletUtils.getCurrentUserId());
            return Response.ok().build();
        }
        catch (Exception e) {
            LOG.error((Object)"Error getting computed reward", (Throwable)e);
            JSONObject object = new JSONObject();
            try {
                object.append("error", (Object)e.getMessage());
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            return Response.status((int)500).type("application/json").entity((Object)object.toString()).build();
        }
    }
}

