/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.wallet.model.transaction;

import java.io.Serializable;
import java.math.BigInteger;
import org.exoplatform.addon.wallet.model.Wallet;
import org.exoplatform.addon.wallet.utils.WalletUtils;

public class TransactionDetail
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 658273092293607458L;
    private long id;
    private Wallet issuer;
    private long issuerId;
    private long networkId;
    private String hash;
    private String contractAddress;
    private String contractMethodName;
    private boolean pending;
    private boolean succeeded;
    private boolean isAdminOperation;
    private String from;
    private Wallet fromWallet;
    private String to;
    private Wallet toWallet;
    private String by;
    private Wallet byWallet;
    private String label;
    private String message;
    private double value;
    private double contractAmount;
    private int gasUsed;
    private double gasPrice;
    private double tokenFee;
    private boolean noContractFunds;
    private long timestamp;

    public TransactionDetail clone() {
        try {
            return (TransactionDetail)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Error while cloning object", e);
        }
    }

    public BigInteger getContractAmountDecimal(int decimals) {
        if (this.contractAmount == 0.0) {
            return BigInteger.ZERO;
        }
        return WalletUtils.convertToDecimals(this.contractAmount, decimals);
    }

    public BigInteger getValueDecimal(int decimals) {
        if (this.value == 0.0) {
            return BigInteger.ZERO;
        }
        return WalletUtils.convertToDecimals(this.value, decimals);
    }

    public void setContractAmountDecimal(BigInteger amount, int decimals) {
        if (amount == null) {
            this.contractAmount = 0.0;
            return;
        }
        this.contractAmount = WalletUtils.convertFromDecimals(amount, decimals);
    }

    public void setValueDecimal(BigInteger amount, int decimals) {
        this.value = amount == null ? 0.0 : WalletUtils.convertFromDecimals(amount, decimals);
    }

    public long getId() {
        return this.id;
    }

    public Wallet getIssuer() {
        return this.issuer;
    }

    public long getIssuerId() {
        return this.issuerId;
    }

    public long getNetworkId() {
        return this.networkId;
    }

    public String getHash() {
        return this.hash;
    }

    public String getContractAddress() {
        return this.contractAddress;
    }

    public String getContractMethodName() {
        return this.contractMethodName;
    }

    public boolean isPending() {
        return this.pending;
    }

    public boolean isSucceeded() {
        return this.succeeded;
    }

    public boolean isAdminOperation() {
        return this.isAdminOperation;
    }

    public String getFrom() {
        return this.from;
    }

    public Wallet getFromWallet() {
        return this.fromWallet;
    }

    public String getTo() {
        return this.to;
    }

    public Wallet getToWallet() {
        return this.toWallet;
    }

    public String getBy() {
        return this.by;
    }

    public Wallet getByWallet() {
        return this.byWallet;
    }

    public String getLabel() {
        return this.label;
    }

    public String getMessage() {
        return this.message;
    }

    public double getValue() {
        return this.value;
    }

    public double getContractAmount() {
        return this.contractAmount;
    }

    public int getGasUsed() {
        return this.gasUsed;
    }

    public double getGasPrice() {
        return this.gasPrice;
    }

    public double getTokenFee() {
        return this.tokenFee;
    }

    public boolean isNoContractFunds() {
        return this.noContractFunds;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setIssuer(Wallet issuer) {
        this.issuer = issuer;
    }

    public void setIssuerId(long issuerId) {
        this.issuerId = issuerId;
    }

    public void setNetworkId(long networkId) {
        this.networkId = networkId;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public void setContractAddress(String contractAddress) {
        this.contractAddress = contractAddress;
    }

    public void setContractMethodName(String contractMethodName) {
        this.contractMethodName = contractMethodName;
    }

    public void setPending(boolean pending) {
        this.pending = pending;
    }

    public void setSucceeded(boolean succeeded) {
        this.succeeded = succeeded;
    }

    public void setAdminOperation(boolean isAdminOperation) {
        this.isAdminOperation = isAdminOperation;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public void setFromWallet(Wallet fromWallet) {
        this.fromWallet = fromWallet;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public void setToWallet(Wallet toWallet) {
        this.toWallet = toWallet;
    }

    public void setBy(String by) {
        this.by = by;
    }

    public void setByWallet(Wallet byWallet) {
        this.byWallet = byWallet;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setValue(double value) {
        this.value = value;
    }

    public void setContractAmount(double contractAmount) {
        this.contractAmount = contractAmount;
    }

    public void setGasUsed(int gasUsed) {
        this.gasUsed = gasUsed;
    }

    public void setGasPrice(double gasPrice) {
        this.gasPrice = gasPrice;
    }

    public void setTokenFee(double tokenFee) {
        this.tokenFee = tokenFee;
    }

    public void setNoContractFunds(boolean noContractFunds) {
        this.noContractFunds = noContractFunds;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransactionDetail)) {
            return false;
        }
        TransactionDetail other = (TransactionDetail)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        if (this.getIssuerId() != other.getIssuerId()) {
            return false;
        }
        if (this.getNetworkId() != other.getNetworkId()) {
            return false;
        }
        String this$hash = this.getHash();
        String other$hash = other.getHash();
        if (this$hash == null ? other$hash != null : !this$hash.equals(other$hash)) {
            return false;
        }
        String this$contractAddress = this.getContractAddress();
        String other$contractAddress = other.getContractAddress();
        if (this$contractAddress == null ? other$contractAddress != null : !this$contractAddress.equals(other$contractAddress)) {
            return false;
        }
        String this$contractMethodName = this.getContractMethodName();
        String other$contractMethodName = other.getContractMethodName();
        if (this$contractMethodName == null ? other$contractMethodName != null : !this$contractMethodName.equals(other$contractMethodName)) {
            return false;
        }
        if (this.isPending() != other.isPending()) {
            return false;
        }
        if (this.isSucceeded() != other.isSucceeded()) {
            return false;
        }
        if (this.isAdminOperation() != other.isAdminOperation()) {
            return false;
        }
        String this$from = this.getFrom();
        String other$from = other.getFrom();
        if (this$from == null ? other$from != null : !this$from.equals(other$from)) {
            return false;
        }
        String this$to = this.getTo();
        String other$to = other.getTo();
        if (this$to == null ? other$to != null : !this$to.equals(other$to)) {
            return false;
        }
        String this$by = this.getBy();
        String other$by = other.getBy();
        if (this$by == null ? other$by != null : !this$by.equals(other$by)) {
            return false;
        }
        String this$label = this.getLabel();
        String other$label = other.getLabel();
        if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        if (Double.compare(this.getValue(), other.getValue()) != 0) {
            return false;
        }
        if (Double.compare(this.getContractAmount(), other.getContractAmount()) != 0) {
            return false;
        }
        if (this.getGasUsed() != other.getGasUsed()) {
            return false;
        }
        if (Double.compare(this.getGasPrice(), other.getGasPrice()) != 0) {
            return false;
        }
        if (Double.compare(this.getTokenFee(), other.getTokenFee()) != 0) {
            return false;
        }
        if (this.isNoContractFunds() != other.isNoContractFunds()) {
            return false;
        }
        return this.getTimestamp() == other.getTimestamp();
    }

    protected boolean canEqual(Object other) {
        return other instanceof TransactionDetail;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $id = this.getId();
        result = result * 59 + (int)($id >>> 32 ^ $id);
        long $issuerId = this.getIssuerId();
        result = result * 59 + (int)($issuerId >>> 32 ^ $issuerId);
        long $networkId = this.getNetworkId();
        result = result * 59 + (int)($networkId >>> 32 ^ $networkId);
        String $hash = this.getHash();
        result = result * 59 + ($hash == null ? 43 : $hash.hashCode());
        String $contractAddress = this.getContractAddress();
        result = result * 59 + ($contractAddress == null ? 43 : $contractAddress.hashCode());
        String $contractMethodName = this.getContractMethodName();
        result = result * 59 + ($contractMethodName == null ? 43 : $contractMethodName.hashCode());
        result = result * 59 + (this.isPending() ? 79 : 97);
        result = result * 59 + (this.isSucceeded() ? 79 : 97);
        result = result * 59 + (this.isAdminOperation() ? 79 : 97);
        String $from = this.getFrom();
        result = result * 59 + ($from == null ? 43 : $from.hashCode());
        String $to = this.getTo();
        result = result * 59 + ($to == null ? 43 : $to.hashCode());
        String $by = this.getBy();
        result = result * 59 + ($by == null ? 43 : $by.hashCode());
        String $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : $label.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        long $value = Double.doubleToLongBits(this.getValue());
        result = result * 59 + (int)($value >>> 32 ^ $value);
        long $contractAmount = Double.doubleToLongBits(this.getContractAmount());
        result = result * 59 + (int)($contractAmount >>> 32 ^ $contractAmount);
        result = result * 59 + this.getGasUsed();
        long $gasPrice = Double.doubleToLongBits(this.getGasPrice());
        result = result * 59 + (int)($gasPrice >>> 32 ^ $gasPrice);
        long $tokenFee = Double.doubleToLongBits(this.getTokenFee());
        result = result * 59 + (int)($tokenFee >>> 32 ^ $tokenFee);
        result = result * 59 + (this.isNoContractFunds() ? 79 : 97);
        long $timestamp = this.getTimestamp();
        result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
        return result;
    }

    public String toString() {
        return "TransactionDetail(id=" + this.getId() + ", issuer=" + this.getIssuer() + ", issuerId=" + this.getIssuerId() + ", networkId=" + this.getNetworkId() + ", hash=" + this.getHash() + ", contractAddress=" + this.getContractAddress() + ", contractMethodName=" + this.getContractMethodName() + ", pending=" + this.isPending() + ", succeeded=" + this.isSucceeded() + ", isAdminOperation=" + this.isAdminOperation() + ", from=" + this.getFrom() + ", fromWallet=" + this.getFromWallet() + ", to=" + this.getTo() + ", toWallet=" + this.getToWallet() + ", by=" + this.getBy() + ", byWallet=" + this.getByWallet() + ", label=" + this.getLabel() + ", message=" + this.getMessage() + ", value=" + this.getValue() + ", contractAmount=" + this.getContractAmount() + ", gasUsed=" + this.getGasUsed() + ", gasPrice=" + this.getGasPrice() + ", tokenFee=" + this.getTokenFee() + ", noContractFunds=" + this.isNoContractFunds() + ", timestamp=" + this.getTimestamp() + ")";
    }
}

