/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.wallet.listener;

import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.addon.wallet.model.Wallet;
import org.exoplatform.addon.wallet.statistic.StatisticUtils;
import org.exoplatform.addon.wallet.utils.WalletUtils;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;

public class WalletCreationListener
extends Listener<Wallet, String> {
    public void onEvent(Event<Wallet, String> event) throws Exception {
        String contractAddress = WalletUtils.getContractAddress();
        if (StringUtils.isBlank((CharSequence)contractAddress)) {
            return;
        }
        String issuer = (String)event.getData();
        Wallet wallet = (Wallet)event.getSource();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("", wallet);
        parameters.put("local_service", "wallet");
        parameters.put("operation", "create_wallet");
        parameters.put("status", "ok");
        parameters.put("status_code", "200");
        parameters.put("duration_ms", "");
        parameters.put("issuer", issuer);
        StatisticUtils.addStatisticEntry(parameters);
    }
}

