/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.wallet.model.reward;

import java.io.Serializable;
import java.util.Set;
import org.exoplatform.addon.wallet.model.Wallet;
import org.exoplatform.addon.wallet.model.reward.RewardTransaction;
import org.exoplatform.addon.wallet.model.reward.WalletPluginReward;

public class WalletReward
implements Serializable {
    private static final long serialVersionUID = -4328398843364453949L;
    private Wallet wallet;
    private Set<WalletPluginReward> rewards;
    private RewardTransaction rewardTransaction;
    private String poolName;
    private boolean enabled;

    public double getTokensSent() {
        if (this.rewardTransaction == null || this.rewardTransaction.getTokensSent() == 0.0) {
            return 0.0;
        }
        return this.rewardTransaction.getTokensSent();
    }

    public double getTokensToSend() {
        if (this.rewards == null || this.rewards.isEmpty()) {
            return 0.0;
        }
        return this.rewards.stream().mapToDouble(reward -> reward.getAmount()).sum();
    }

    public double getPoolTokensToSend() {
        if (this.rewards == null || this.rewards.isEmpty()) {
            return 0.0;
        }
        return this.rewards.stream().filter(WalletPluginReward::isPoolsUsed).mapToDouble(reward -> reward.getAmount()).sum();
    }

    public Wallet getWallet() {
        return this.wallet;
    }

    public Set<WalletPluginReward> getRewards() {
        return this.rewards;
    }

    public RewardTransaction getRewardTransaction() {
        return this.rewardTransaction;
    }

    public String getPoolName() {
        return this.poolName;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setWallet(Wallet wallet) {
        this.wallet = wallet;
    }

    public void setRewards(Set<WalletPluginReward> rewards) {
        this.rewards = rewards;
    }

    public void setRewardTransaction(RewardTransaction rewardTransaction) {
        this.rewardTransaction = rewardTransaction;
    }

    public void setPoolName(String poolName) {
        this.poolName = poolName;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WalletReward)) {
            return false;
        }
        WalletReward other = (WalletReward)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Wallet this$wallet = this.getWallet();
        Wallet other$wallet = other.getWallet();
        if (this$wallet == null ? other$wallet != null : !((Object)this$wallet).equals(other$wallet)) {
            return false;
        }
        return this.isEnabled() == other.isEnabled();
    }

    protected boolean canEqual(Object other) {
        return other instanceof WalletReward;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Wallet $wallet = this.getWallet();
        result = result * 59 + ($wallet == null ? 43 : ((Object)$wallet).hashCode());
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "WalletReward(wallet=" + this.getWallet() + ", rewards=" + this.getRewards() + ", rewardTransaction=" + this.getRewardTransaction() + ", poolName=" + this.getPoolName() + ", enabled=" + this.isEnabled() + ")";
    }

    public WalletReward(Wallet wallet, Set<WalletPluginReward> rewards, RewardTransaction rewardTransaction, String poolName, boolean enabled) {
        this.wallet = wallet;
        this.rewards = rewards;
        this.rewardTransaction = rewardTransaction;
        this.poolName = poolName;
        this.enabled = enabled;
    }

    public WalletReward() {
    }
}

