/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.wallet.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.addon.wallet.model.ContractDetail;
import org.exoplatform.addon.wallet.service.WalletContractService;
import org.exoplatform.addon.wallet.utils.WalletUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="/wallet/api/contract")
@RolesAllowed(value={"users"})
@Api(value="/wallet/api/contract", description="Manages internally stored token contract detail")
public class WalletContractREST
implements ResourceContainer {
    private static final Log LOG = ExoLogger.getLogger(WalletContractREST.class);
    private WalletContractService contractService;

    public WalletContractREST(WalletContractService contractService) {
        this.contractService = contractService;
    }

    @GET
    @Produces(value={"application/json"})
    @RolesAllowed(value={"users"})
    @ApiOperation(value="Retrieves stored contract details in internal datasource", httpMethod="GET", produces="application/json", response=Response.class, notes="returns contract detail object")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response getContract(@ApiParam(value="contract address", required=true) @QueryParam(value="address") String address) {
        if (StringUtils.isBlank((String)address)) {
            LOG.warn((Object)"Empty contract address");
            return Response.status((int)400).build();
        }
        try {
            ContractDetail contractDetail = this.contractService.getContractDetail(address);
            if (contractDetail == null) {
                contractDetail = new ContractDetail();
            }
            return Response.ok((Object)contractDetail).build();
        }
        catch (Exception e) {
            LOG.error((Object)("Error getting contract details: " + address), (Throwable)e);
            return Response.serverError().build();
        }
    }

    @GET
    @Path(value="bin/{name}")
    @RolesAllowed(value={"rewarding"})
    @ApiOperation(value="Retrieves contract binary", httpMethod="GET", response=Response.class, notes="returns contract bin content")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response getBin(@ApiParam(value="contract name", required=true) @PathParam(value="name") String name) {
        if (StringUtils.isBlank((String)name)) {
            LOG.warn((Object)"Empty resource name");
            return Response.status((int)400).build();
        }
        if (name.contains("..") || name.contains("/") || name.contains("\\")) {
            LOG.error((Object)(WalletUtils.getCurrentUserId() + " has used a forbidden path character is used: '..' or '/' or '\\'"));
            return Response.status((int)401).build();
        }
        try {
            String contractBin = this.contractService.getContractFileContent(name, "bin");
            return Response.ok((Object)contractBin).build();
        }
        catch (Exception e) {
            LOG.error((Object)("Error retrieving contract BIN: " + name), (Throwable)e);
            return Response.serverError().build();
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="abi/{name}")
    @RolesAllowed(value={"rewarding"})
    @ApiOperation(value="Retrieves contract ABI", httpMethod="GET", produces="application/json", response=Response.class, notes="returns contract ABI object")
    @ApiResponses(value={@ApiResponse(code=200, message="Request fulfilled"), @ApiResponse(code=400, message="Invalid query input"), @ApiResponse(code=401, message="Unauthorized operation"), @ApiResponse(code=500, message="Internal server error")})
    public Response getAbi(@ApiParam(value="contract name", required=true) @PathParam(value="name") String name) {
        if (StringUtils.isBlank((String)name)) {
            LOG.warn((Object)"Empty resource name");
            return Response.status((int)400).build();
        }
        if (name.contains("..") || name.contains("/") || name.contains("\\")) {
            LOG.error((Object)(WalletUtils.getCurrentUserId() + " has used a forbidden path character is used: '..' or '/' or '\\'"));
            return Response.status((int)401).build();
        }
        try {
            String contractAbi = this.contractService.getContractFileContent(name, "json");
            return Response.ok((Object)contractAbi).build();
        }
        catch (Exception e) {
            LOG.error((Object)("Error retrieving contract ABI: " + name), (Throwable)e);
            return Response.serverError().build();
        }
    }
}

