/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wallet.contract;

import io.reactivex.Flowable;
import io.reactivex.functions.Function;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.web3j.abi.EventEncoder;
import org.web3j.abi.TypeReference;
import org.web3j.abi.datatypes.Address;
import org.web3j.abi.datatypes.Bool;
import org.web3j.abi.datatypes.Event;
import org.web3j.abi.datatypes.Type;
import org.web3j.abi.datatypes.Utf8String;
import org.web3j.abi.datatypes.generated.Uint16;
import org.web3j.abi.datatypes.generated.Uint256;
import org.web3j.abi.datatypes.generated.Uint8;
import org.web3j.crypto.Credentials;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.DefaultBlockParameter;
import org.web3j.protocol.core.RemoteCall;
import org.web3j.protocol.core.RemoteFunctionCall;
import org.web3j.protocol.core.methods.request.EthFilter;
import org.web3j.protocol.core.methods.response.BaseEventResponse;
import org.web3j.protocol.core.methods.response.Log;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.tx.Contract;
import org.web3j.tx.TransactionManager;
import org.web3j.tx.gas.ContractGasProvider;

public class ERTTokenV1
extends Contract {
    public static final String BINARY = "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";
    public static final String FUNC_NAME = "name";
    public static final String FUNC_APPROVE = "approve";
    public static final String FUNC_INITIALIZED = "initialized";
    public static final String FUNC_REMOVEADMIN = "removeAdmin";
    public static final String FUNC_TOTALSUPPLY = "totalSupply";
    public static final String FUNC_INITIALIZE = "initialize";
    public static final String FUNC_TRANSFERFROM = "transferFrom";
    public static final String FUNC_DECIMALS = "decimals";
    public static final String FUNC_UPGRADEIMPLEMENTATION = "upgradeImplementation";
    public static final String FUNC_VESTINGBALANCEOF = "vestingBalanceOf";
    public static final String FUNC_GETSELLPRICE = "getSellPrice";
    public static final String FUNC_ISADMIN = "isAdmin";
    public static final String FUNC_ADDADMIN = "addAdmin";
    public static final String FUNC_VERSION = "version";
    public static final String FUNC_PAUSED = "paused";
    public static final String FUNC_DISAPPROVEACCOUNT = "disapproveAccount";
    public static final String FUNC_ISINITIALIZEDACCOUNT = "isInitializedAccount";
    public static final String FUNC_UPGRADEDATA = "upgradeData";
    public static final String FUNC_BALANCEOF = "balanceOf";
    public static final String FUNC_PAUSE = "pause";
    public static final String FUNC_OWNER = "owner";
    public static final String FUNC_GETDATAADDRESS = "getDataAddress";
    public static final String FUNC_SYMBOL = "symbol";
    public static final String FUNC_UPGRADEDATAANDIMPLEMENTATION = "upgradeDataAndImplementation";
    public static final String FUNC_TRANSFER = "transfer";
    public static final String FUNC_ISAPPROVEDACCOUNT = "isApprovedAccount";
    public static final String FUNC_GETADMINLEVEL = "getAdminLevel";
    public static final String FUNC_ISPAUSED = "isPaused";
    public static final String FUNC_SETSYMBOL = "setSymbol";
    public static final String FUNC_IMPLEMENTATIONADDRESS = "implementationAddress";
    public static final String FUNC_SETNAME = "setName";
    public static final String FUNC_ALLOWANCE = "allowance";
    public static final String FUNC_REWARDBALANCEOF = "rewardBalanceOf";
    public static final String FUNC_TRANSFEROWNERSHIP = "transferOwnership";
    public static final String FUNC_UNPAUSE = "unPause";
    public static final String FUNC_APPROVEACCOUNT = "approveAccount";
    public static final String FUNC_SETSELLPRICE = "setSellPrice";
    public static final Event UPGRADED_EVENT = new Event("Upgraded", Arrays.asList(new TypeReference<Uint16>(){}, new TypeReference<Address>(){}));
    public static final Event UPGRADEDDATA_EVENT = new Event("UpgradedData", Arrays.asList(new TypeReference<Uint16>(){}, new TypeReference<Address>(){}));
    public static final Event TOKENPRICECHANGED_EVENT = new Event("TokenPriceChanged", Arrays.asList(new TypeReference<Uint256>(){}));
    public static final Event TRANSACTIONFEE_EVENT = new Event("TransactionFee", Arrays.asList(new TypeReference<Address>(){}, new TypeReference<Uint256>(){}, new TypeReference<Uint256>(){}));
    public static final Event NOSUFFICIENTFUND_EVENT = new Event("NoSufficientFund", Arrays.asList(new TypeReference<Uint256>(){}));
    public static final Event DEPOSITRECEIVED_EVENT = new Event("DepositReceived", Arrays.asList(new TypeReference<Address>(){}, new TypeReference<Uint256>(){}));
    public static final Event TRANSFER_EVENT = new Event("Transfer", Arrays.asList(new TypeReference<Address>(true){}, new TypeReference<Address>(true){}, new TypeReference<Uint256>(){}));
    public static final Event APPROVAL_EVENT = new Event("Approval", Arrays.asList(new TypeReference<Address>(true){}, new TypeReference<Address>(true){}, new TypeReference<Uint256>(){}));
    public static final Event APPROVEDACCOUNT_EVENT = new Event("ApprovedAccount", Arrays.asList(new TypeReference<Address>(){}));
    public static final Event DISAPPROVEDACCOUNT_EVENT = new Event("DisapprovedAccount", Arrays.asList(new TypeReference<Address>(){}));
    public static final Event CONTRACTPAUSED_EVENT = new Event("ContractPaused", Arrays.asList(new TypeReference[0]));
    public static final Event CONTRACTUNPAUSED_EVENT = new Event("ContractUnPaused", Arrays.asList(new TypeReference[0]));
    public static final Event ADDEDADMIN_EVENT = new Event("AddedAdmin", Arrays.asList(new TypeReference<Address>(){}, new TypeReference<Uint8>(){}));
    public static final Event REMOVEDADMIN_EVENT = new Event("RemovedAdmin", Arrays.asList(new TypeReference<Address>(){}));
    public static final Event TRANSFEROWNERSHIP_EVENT = new Event("TransferOwnership", Arrays.asList(new TypeReference<Address>(){}));

    @Deprecated
    protected ERTTokenV1(String contractAddress, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        super(BINARY, contractAddress, web3j, credentials, gasPrice, gasLimit);
    }

    protected ERTTokenV1(String contractAddress, Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        super(BINARY, contractAddress, web3j, credentials, contractGasProvider);
    }

    @Deprecated
    protected ERTTokenV1(String contractAddress, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        super(BINARY, contractAddress, web3j, transactionManager, gasPrice, gasLimit);
    }

    protected ERTTokenV1(String contractAddress, Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        super(BINARY, contractAddress, web3j, transactionManager, contractGasProvider);
    }

    public RemoteFunctionCall<String> name() {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_NAME, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Utf8String>(){}));
        return this.executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteFunctionCall<TransactionReceipt> approve(String _spender, BigInteger _value) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_APPROVE, Arrays.asList(new Address(160, _spender), new Uint256(_value)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<Boolean> initialized() {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_INITIALIZED, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Bool>(){}));
        return this.executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteFunctionCall<TransactionReceipt> removeAdmin(String _target) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_REMOVEADMIN, Arrays.asList(new Address(160, _target)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<BigInteger> totalSupply() {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_TOTALSUPPLY, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Uint256>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<TransactionReceipt> initialize(BigInteger _initialAmount, String _tokenName, BigInteger _decimalUnits, String _tokenSymbol) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_INITIALIZE, Arrays.asList(new Uint256(_initialAmount), new Utf8String(_tokenName), new Uint8(_decimalUnits), new Utf8String(_tokenSymbol)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> transferFrom(String _from, String _to, BigInteger _value) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_TRANSFERFROM, Arrays.asList(new Address(160, _from), new Address(160, _to), new Uint256(_value)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<BigInteger> decimals() {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_DECIMALS, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Uint8>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<TransactionReceipt> upgradeImplementation(String _proxy, BigInteger _version, String _newImplementation) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_UPGRADEIMPLEMENTATION, Arrays.asList(new Address(160, _proxy), new Uint16(_version), new Address(160, _newImplementation)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<BigInteger> vestingBalanceOf(String _target) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_VESTINGBALANCEOF, Arrays.asList(new Address(160, _target)), Arrays.asList(new TypeReference<Uint256>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<BigInteger> getSellPrice() {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_GETSELLPRICE, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Uint256>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<Boolean> isAdmin(String _target, BigInteger _level) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_ISADMIN, Arrays.asList(new Address(160, _target), new Uint8(_level)), Arrays.asList(new TypeReference<Bool>(){}));
        return this.executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteFunctionCall<TransactionReceipt> addAdmin(String _target, BigInteger _level) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_ADDADMIN, Arrays.asList(new Address(160, _target), new Uint8(_level)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<BigInteger> version() {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_VERSION, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Uint16>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<Boolean> paused() {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_PAUSED, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Bool>(){}));
        return this.executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteFunctionCall<TransactionReceipt> disapproveAccount(String _target) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_DISAPPROVEACCOUNT, Arrays.asList(new Address(160, _target)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<Boolean> isInitializedAccount(String _target) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_ISINITIALIZEDACCOUNT, Arrays.asList(new Address(160, _target)), Arrays.asList(new TypeReference<Bool>(){}));
        return this.executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteFunctionCall<TransactionReceipt> upgradeData(BigInteger _dataVersion, String _dataAddress) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_UPGRADEDATA, Arrays.asList(new Uint16(_dataVersion), new Address(160, _dataAddress)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<BigInteger> balanceOf(String _target) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_BALANCEOF, Arrays.asList(new Address(160, _target)), Arrays.asList(new TypeReference<Uint256>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<TransactionReceipt> pause() {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_PAUSE, Arrays.asList(new Type[0]), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<String> owner() {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_OWNER, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Address>(){}));
        return this.executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteFunctionCall<String> getDataAddress(BigInteger _version) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_GETDATAADDRESS, Arrays.asList(new Uint16(_version)), Arrays.asList(new TypeReference<Address>(){}));
        return this.executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteFunctionCall<String> symbol() {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_SYMBOL, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Utf8String>(){}));
        return this.executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteFunctionCall<TransactionReceipt> upgradeDataAndImplementation(String _proxy, BigInteger _version, String _newImplementation, BigInteger _dataVersion, String _dataAddress) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_UPGRADEDATAANDIMPLEMENTATION, Arrays.asList(new Address(160, _proxy), new Uint16(_version), new Address(160, _newImplementation), new Uint16(_dataVersion), new Address(160, _dataAddress)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> transfer(String _to, BigInteger _value) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_TRANSFER, Arrays.asList(new Address(160, _to), new Uint256(_value)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<Boolean> isApprovedAccount(String _target) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_ISAPPROVEDACCOUNT, Arrays.asList(new Address(160, _target)), Arrays.asList(new TypeReference<Bool>(){}));
        return this.executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteFunctionCall<BigInteger> getAdminLevel(String _target) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_GETADMINLEVEL, Arrays.asList(new Address(160, _target)), Arrays.asList(new TypeReference<Uint8>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<Boolean> isPaused() {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_ISPAUSED, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Bool>(){}));
        return this.executeRemoteCallSingleValueReturn(function, Boolean.class);
    }

    public RemoteFunctionCall<TransactionReceipt> setSymbol(String _symbol) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_SETSYMBOL, Arrays.asList(new Utf8String(_symbol)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<String> implementationAddress() {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_IMPLEMENTATIONADDRESS, Arrays.asList(new Type[0]), Arrays.asList(new TypeReference<Address>(){}));
        return this.executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteFunctionCall<TransactionReceipt> setName(String _name) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_SETNAME, Arrays.asList(new Utf8String(_name)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<BigInteger> allowance(String _target, String _spender) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_ALLOWANCE, Arrays.asList(new Address(160, _target), new Address(160, _spender)), Arrays.asList(new TypeReference<Uint256>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<BigInteger> rewardBalanceOf(String _target) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_REWARDBALANCEOF, Arrays.asList(new Address(160, _target)), Arrays.asList(new TypeReference<Uint256>(){}));
        return this.executeRemoteCallSingleValueReturn(function, BigInteger.class);
    }

    public RemoteFunctionCall<TransactionReceipt> transferOwnership(String _newOwner) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_TRANSFEROWNERSHIP, Arrays.asList(new Address(160, _newOwner)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> unPause() {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_UNPAUSE, Arrays.asList(new Type[0]), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> approveAccount(String _target) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_APPROVEACCOUNT, Arrays.asList(new Address(160, _target)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public RemoteFunctionCall<TransactionReceipt> setSellPrice(BigInteger _value) {
        org.web3j.abi.datatypes.Function function = new org.web3j.abi.datatypes.Function(FUNC_SETSELLPRICE, Arrays.asList(new Uint256(_value)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public List<UpgradedEventResponse> getUpgradedEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(UPGRADED_EVENT, transactionReceipt);
        ArrayList<UpgradedEventResponse> responses = new ArrayList<UpgradedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            UpgradedEventResponse typedResponse = new UpgradedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.implementationVersion = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            typedResponse.implementationAddress = (String)((Type)eventValues.getNonIndexedValues().get(1)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<UpgradedEventResponse> upgradedEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map((Function)new Function<Log, UpgradedEventResponse>(){

            public UpgradedEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = ERTTokenV1.this.extractEventParametersWithLog(UPGRADED_EVENT, log);
                UpgradedEventResponse typedResponse = new UpgradedEventResponse();
                typedResponse.log = log;
                typedResponse.implementationVersion = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
                typedResponse.implementationAddress = (String)((Type)eventValues.getNonIndexedValues().get(1)).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<UpgradedEventResponse> upgradedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)UPGRADED_EVENT));
        return this.upgradedEventFlowable(filter);
    }

    public List<UpgradedDataEventResponse> getUpgradedDataEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(UPGRADEDDATA_EVENT, transactionReceipt);
        ArrayList<UpgradedDataEventResponse> responses = new ArrayList<UpgradedDataEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            UpgradedDataEventResponse typedResponse = new UpgradedDataEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.dataVersion = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            typedResponse.dataAddress = (String)((Type)eventValues.getNonIndexedValues().get(1)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<UpgradedDataEventResponse> upgradedDataEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map((Function)new Function<Log, UpgradedDataEventResponse>(){

            public UpgradedDataEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = ERTTokenV1.this.extractEventParametersWithLog(UPGRADEDDATA_EVENT, log);
                UpgradedDataEventResponse typedResponse = new UpgradedDataEventResponse();
                typedResponse.log = log;
                typedResponse.dataVersion = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
                typedResponse.dataAddress = (String)((Type)eventValues.getNonIndexedValues().get(1)).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<UpgradedDataEventResponse> upgradedDataEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)UPGRADEDDATA_EVENT));
        return this.upgradedDataEventFlowable(filter);
    }

    public List<TokenPriceChangedEventResponse> getTokenPriceChangedEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(TOKENPRICECHANGED_EVENT, transactionReceipt);
        ArrayList<TokenPriceChangedEventResponse> responses = new ArrayList<TokenPriceChangedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            TokenPriceChangedEventResponse typedResponse = new TokenPriceChangedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.tokenPrice = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<TokenPriceChangedEventResponse> tokenPriceChangedEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map((Function)new Function<Log, TokenPriceChangedEventResponse>(){

            public TokenPriceChangedEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = ERTTokenV1.this.extractEventParametersWithLog(TOKENPRICECHANGED_EVENT, log);
                TokenPriceChangedEventResponse typedResponse = new TokenPriceChangedEventResponse();
                typedResponse.log = log;
                typedResponse.tokenPrice = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<TokenPriceChangedEventResponse> tokenPriceChangedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)TOKENPRICECHANGED_EVENT));
        return this.tokenPriceChangedEventFlowable(filter);
    }

    public List<TransactionFeeEventResponse> getTransactionFeeEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(TRANSACTIONFEE_EVENT, transactionReceipt);
        ArrayList<TransactionFeeEventResponse> responses = new ArrayList<TransactionFeeEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            TransactionFeeEventResponse typedResponse = new TransactionFeeEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.from = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            typedResponse.tokenFee = (BigInteger)((Type)eventValues.getNonIndexedValues().get(1)).getValue();
            typedResponse.etherFeeRefund = (BigInteger)((Type)eventValues.getNonIndexedValues().get(2)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<TransactionFeeEventResponse> transactionFeeEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map((Function)new Function<Log, TransactionFeeEventResponse>(){

            public TransactionFeeEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = ERTTokenV1.this.extractEventParametersWithLog(TRANSACTIONFEE_EVENT, log);
                TransactionFeeEventResponse typedResponse = new TransactionFeeEventResponse();
                typedResponse.log = log;
                typedResponse.from = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
                typedResponse.tokenFee = (BigInteger)((Type)eventValues.getNonIndexedValues().get(1)).getValue();
                typedResponse.etherFeeRefund = (BigInteger)((Type)eventValues.getNonIndexedValues().get(2)).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<TransactionFeeEventResponse> transactionFeeEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)TRANSACTIONFEE_EVENT));
        return this.transactionFeeEventFlowable(filter);
    }

    public List<NoSufficientFundEventResponse> getNoSufficientFundEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(NOSUFFICIENTFUND_EVENT, transactionReceipt);
        ArrayList<NoSufficientFundEventResponse> responses = new ArrayList<NoSufficientFundEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            NoSufficientFundEventResponse typedResponse = new NoSufficientFundEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.balance = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<NoSufficientFundEventResponse> noSufficientFundEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map((Function)new Function<Log, NoSufficientFundEventResponse>(){

            public NoSufficientFundEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = ERTTokenV1.this.extractEventParametersWithLog(NOSUFFICIENTFUND_EVENT, log);
                NoSufficientFundEventResponse typedResponse = new NoSufficientFundEventResponse();
                typedResponse.log = log;
                typedResponse.balance = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<NoSufficientFundEventResponse> noSufficientFundEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)NOSUFFICIENTFUND_EVENT));
        return this.noSufficientFundEventFlowable(filter);
    }

    public List<DepositReceivedEventResponse> getDepositReceivedEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(DEPOSITRECEIVED_EVENT, transactionReceipt);
        ArrayList<DepositReceivedEventResponse> responses = new ArrayList<DepositReceivedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            DepositReceivedEventResponse typedResponse = new DepositReceivedEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.from = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            typedResponse.amount = (BigInteger)((Type)eventValues.getNonIndexedValues().get(1)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<DepositReceivedEventResponse> depositReceivedEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map((Function)new Function<Log, DepositReceivedEventResponse>(){

            public DepositReceivedEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = ERTTokenV1.this.extractEventParametersWithLog(DEPOSITRECEIVED_EVENT, log);
                DepositReceivedEventResponse typedResponse = new DepositReceivedEventResponse();
                typedResponse.log = log;
                typedResponse.from = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
                typedResponse.amount = (BigInteger)((Type)eventValues.getNonIndexedValues().get(1)).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<DepositReceivedEventResponse> depositReceivedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)DEPOSITRECEIVED_EVENT));
        return this.depositReceivedEventFlowable(filter);
    }

    public List<TransferEventResponse> getTransferEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(TRANSFER_EVENT, transactionReceipt);
        ArrayList<TransferEventResponse> responses = new ArrayList<TransferEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            TransferEventResponse typedResponse = new TransferEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse._from = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
            typedResponse._to = (String)((Type)eventValues.getIndexedValues().get(1)).getValue();
            typedResponse._value = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<TransferEventResponse> transferEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map((Function)new Function<Log, TransferEventResponse>(){

            public TransferEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = ERTTokenV1.this.extractEventParametersWithLog(TRANSFER_EVENT, log);
                TransferEventResponse typedResponse = new TransferEventResponse();
                typedResponse.log = log;
                typedResponse._from = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
                typedResponse._to = (String)((Type)eventValues.getIndexedValues().get(1)).getValue();
                typedResponse._value = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<TransferEventResponse> transferEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)TRANSFER_EVENT));
        return this.transferEventFlowable(filter);
    }

    public List<ApprovalEventResponse> getApprovalEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(APPROVAL_EVENT, transactionReceipt);
        ArrayList<ApprovalEventResponse> responses = new ArrayList<ApprovalEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            ApprovalEventResponse typedResponse = new ApprovalEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse._owner = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
            typedResponse._spender = (String)((Type)eventValues.getIndexedValues().get(1)).getValue();
            typedResponse._value = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<ApprovalEventResponse> approvalEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map((Function)new Function<Log, ApprovalEventResponse>(){

            public ApprovalEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = ERTTokenV1.this.extractEventParametersWithLog(APPROVAL_EVENT, log);
                ApprovalEventResponse typedResponse = new ApprovalEventResponse();
                typedResponse.log = log;
                typedResponse._owner = (String)((Type)eventValues.getIndexedValues().get(0)).getValue();
                typedResponse._spender = (String)((Type)eventValues.getIndexedValues().get(1)).getValue();
                typedResponse._value = (BigInteger)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<ApprovalEventResponse> approvalEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)APPROVAL_EVENT));
        return this.approvalEventFlowable(filter);
    }

    public List<ApprovedAccountEventResponse> getApprovedAccountEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(APPROVEDACCOUNT_EVENT, transactionReceipt);
        ArrayList<ApprovedAccountEventResponse> responses = new ArrayList<ApprovedAccountEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            ApprovedAccountEventResponse typedResponse = new ApprovedAccountEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.target = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<ApprovedAccountEventResponse> approvedAccountEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map((Function)new Function<Log, ApprovedAccountEventResponse>(){

            public ApprovedAccountEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = ERTTokenV1.this.extractEventParametersWithLog(APPROVEDACCOUNT_EVENT, log);
                ApprovedAccountEventResponse typedResponse = new ApprovedAccountEventResponse();
                typedResponse.log = log;
                typedResponse.target = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<ApprovedAccountEventResponse> approvedAccountEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)APPROVEDACCOUNT_EVENT));
        return this.approvedAccountEventFlowable(filter);
    }

    public List<DisapprovedAccountEventResponse> getDisapprovedAccountEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(DISAPPROVEDACCOUNT_EVENT, transactionReceipt);
        ArrayList<DisapprovedAccountEventResponse> responses = new ArrayList<DisapprovedAccountEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            DisapprovedAccountEventResponse typedResponse = new DisapprovedAccountEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.target = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<DisapprovedAccountEventResponse> disapprovedAccountEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map((Function)new Function<Log, DisapprovedAccountEventResponse>(){

            public DisapprovedAccountEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = ERTTokenV1.this.extractEventParametersWithLog(DISAPPROVEDACCOUNT_EVENT, log);
                DisapprovedAccountEventResponse typedResponse = new DisapprovedAccountEventResponse();
                typedResponse.log = log;
                typedResponse.target = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<DisapprovedAccountEventResponse> disapprovedAccountEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)DISAPPROVEDACCOUNT_EVENT));
        return this.disapprovedAccountEventFlowable(filter);
    }

    public List<ContractPausedEventResponse> getContractPausedEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(CONTRACTPAUSED_EVENT, transactionReceipt);
        ArrayList<ContractPausedEventResponse> responses = new ArrayList<ContractPausedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            ContractPausedEventResponse typedResponse = new ContractPausedEventResponse();
            typedResponse.log = eventValues.getLog();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<ContractPausedEventResponse> contractPausedEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map((Function)new Function<Log, ContractPausedEventResponse>(){

            public ContractPausedEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = ERTTokenV1.this.extractEventParametersWithLog(CONTRACTPAUSED_EVENT, log);
                ContractPausedEventResponse typedResponse = new ContractPausedEventResponse();
                typedResponse.log = log;
                return typedResponse;
            }
        });
    }

    public Flowable<ContractPausedEventResponse> contractPausedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)CONTRACTPAUSED_EVENT));
        return this.contractPausedEventFlowable(filter);
    }

    public List<ContractUnPausedEventResponse> getContractUnPausedEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(CONTRACTUNPAUSED_EVENT, transactionReceipt);
        ArrayList<ContractUnPausedEventResponse> responses = new ArrayList<ContractUnPausedEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            ContractUnPausedEventResponse typedResponse = new ContractUnPausedEventResponse();
            typedResponse.log = eventValues.getLog();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<ContractUnPausedEventResponse> contractUnPausedEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map((Function)new Function<Log, ContractUnPausedEventResponse>(){

            public ContractUnPausedEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = ERTTokenV1.this.extractEventParametersWithLog(CONTRACTUNPAUSED_EVENT, log);
                ContractUnPausedEventResponse typedResponse = new ContractUnPausedEventResponse();
                typedResponse.log = log;
                return typedResponse;
            }
        });
    }

    public Flowable<ContractUnPausedEventResponse> contractUnPausedEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)CONTRACTUNPAUSED_EVENT));
        return this.contractUnPausedEventFlowable(filter);
    }

    public List<AddedAdminEventResponse> getAddedAdminEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(ADDEDADMIN_EVENT, transactionReceipt);
        ArrayList<AddedAdminEventResponse> responses = new ArrayList<AddedAdminEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            AddedAdminEventResponse typedResponse = new AddedAdminEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.target = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            typedResponse.level = (BigInteger)((Type)eventValues.getNonIndexedValues().get(1)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<AddedAdminEventResponse> addedAdminEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map((Function)new Function<Log, AddedAdminEventResponse>(){

            public AddedAdminEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = ERTTokenV1.this.extractEventParametersWithLog(ADDEDADMIN_EVENT, log);
                AddedAdminEventResponse typedResponse = new AddedAdminEventResponse();
                typedResponse.log = log;
                typedResponse.target = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
                typedResponse.level = (BigInteger)((Type)eventValues.getNonIndexedValues().get(1)).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<AddedAdminEventResponse> addedAdminEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)ADDEDADMIN_EVENT));
        return this.addedAdminEventFlowable(filter);
    }

    public List<RemovedAdminEventResponse> getRemovedAdminEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(REMOVEDADMIN_EVENT, transactionReceipt);
        ArrayList<RemovedAdminEventResponse> responses = new ArrayList<RemovedAdminEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            RemovedAdminEventResponse typedResponse = new RemovedAdminEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.target = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<RemovedAdminEventResponse> removedAdminEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map((Function)new Function<Log, RemovedAdminEventResponse>(){

            public RemovedAdminEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = ERTTokenV1.this.extractEventParametersWithLog(REMOVEDADMIN_EVENT, log);
                RemovedAdminEventResponse typedResponse = new RemovedAdminEventResponse();
                typedResponse.log = log;
                typedResponse.target = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<RemovedAdminEventResponse> removedAdminEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)REMOVEDADMIN_EVENT));
        return this.removedAdminEventFlowable(filter);
    }

    public List<TransferOwnershipEventResponse> getTransferOwnershipEvents(TransactionReceipt transactionReceipt) {
        List valueList = this.extractEventParametersWithLog(TRANSFEROWNERSHIP_EVENT, transactionReceipt);
        ArrayList<TransferOwnershipEventResponse> responses = new ArrayList<TransferOwnershipEventResponse>(valueList.size());
        for (Contract.EventValuesWithLog eventValues : valueList) {
            TransferOwnershipEventResponse typedResponse = new TransferOwnershipEventResponse();
            typedResponse.log = eventValues.getLog();
            typedResponse.newOwner = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
            responses.add(typedResponse);
        }
        return responses;
    }

    public Flowable<TransferOwnershipEventResponse> transferOwnershipEventFlowable(EthFilter filter) {
        return this.web3j.ethLogFlowable(filter).map((Function)new Function<Log, TransferOwnershipEventResponse>(){

            public TransferOwnershipEventResponse apply(Log log) {
                Contract.EventValuesWithLog eventValues = ERTTokenV1.this.extractEventParametersWithLog(TRANSFEROWNERSHIP_EVENT, log);
                TransferOwnershipEventResponse typedResponse = new TransferOwnershipEventResponse();
                typedResponse.log = log;
                typedResponse.newOwner = (String)((Type)eventValues.getNonIndexedValues().get(0)).getValue();
                return typedResponse;
            }
        });
    }

    public Flowable<TransferOwnershipEventResponse> transferOwnershipEventFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        EthFilter filter = new EthFilter(startBlock, endBlock, this.getContractAddress());
        filter.addSingleTopic(EventEncoder.encode((Event)TRANSFEROWNERSHIP_EVENT));
        return this.transferOwnershipEventFlowable(filter);
    }

    @Deprecated
    public static ERTTokenV1 load(String contractAddress, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        return new ERTTokenV1(contractAddress, web3j, credentials, gasPrice, gasLimit);
    }

    @Deprecated
    public static ERTTokenV1 load(String contractAddress, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        return new ERTTokenV1(contractAddress, web3j, transactionManager, gasPrice, gasLimit);
    }

    public static ERTTokenV1 load(String contractAddress, Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        return new ERTTokenV1(contractAddress, web3j, credentials, contractGasProvider);
    }

    public static ERTTokenV1 load(String contractAddress, Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        return new ERTTokenV1(contractAddress, web3j, transactionManager, contractGasProvider);
    }

    public static RemoteCall<ERTTokenV1> deploy(Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        return ERTTokenV1.deployRemoteCall(ERTTokenV1.class, (Web3j)web3j, (Credentials)credentials, (ContractGasProvider)contractGasProvider, (String)BINARY, (String)"");
    }

    public static RemoteCall<ERTTokenV1> deploy(Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        return ERTTokenV1.deployRemoteCall(ERTTokenV1.class, (Web3j)web3j, (TransactionManager)transactionManager, (ContractGasProvider)contractGasProvider, (String)BINARY, (String)"");
    }

    @Deprecated
    public static RemoteCall<ERTTokenV1> deploy(Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        return ERTTokenV1.deployRemoteCall(ERTTokenV1.class, (Web3j)web3j, (Credentials)credentials, (BigInteger)gasPrice, (BigInteger)gasLimit, (String)BINARY, (String)"");
    }

    @Deprecated
    public static RemoteCall<ERTTokenV1> deploy(Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        return ERTTokenV1.deployRemoteCall(ERTTokenV1.class, (Web3j)web3j, (TransactionManager)transactionManager, (BigInteger)gasPrice, (BigInteger)gasLimit, (String)BINARY, (String)"");
    }

    public static class TransferOwnershipEventResponse
    extends BaseEventResponse {
        public String newOwner;
    }

    public static class RemovedAdminEventResponse
    extends BaseEventResponse {
        public String target;
    }

    public static class AddedAdminEventResponse
    extends BaseEventResponse {
        public String target;
        public BigInteger level;
    }

    public static class ContractUnPausedEventResponse
    extends BaseEventResponse {
    }

    public static class ContractPausedEventResponse
    extends BaseEventResponse {
    }

    public static class DisapprovedAccountEventResponse
    extends BaseEventResponse {
        public String target;
    }

    public static class ApprovedAccountEventResponse
    extends BaseEventResponse {
        public String target;
    }

    public static class ApprovalEventResponse
    extends BaseEventResponse {
        public String _owner;
        public String _spender;
        public BigInteger _value;
    }

    public static class TransferEventResponse
    extends BaseEventResponse {
        public String _from;
        public String _to;
        public BigInteger _value;
    }

    public static class DepositReceivedEventResponse
    extends BaseEventResponse {
        public String from;
        public BigInteger amount;
    }

    public static class NoSufficientFundEventResponse
    extends BaseEventResponse {
        public BigInteger balance;
    }

    public static class TransactionFeeEventResponse
    extends BaseEventResponse {
        public String from;
        public BigInteger tokenFee;
        public BigInteger etherFeeRefund;
    }

    public static class TokenPriceChangedEventResponse
    extends BaseEventResponse {
        public BigInteger tokenPrice;
    }

    public static class UpgradedDataEventResponse
    extends BaseEventResponse {
        public BigInteger dataVersion;
        public String dataAddress;
    }

    public static class UpgradedEventResponse
    extends BaseEventResponse {
        public BigInteger implementationVersion;
        public String implementationAddress;
    }
}

