/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wallet.blockchain.listener;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.wallet.model.Wallet;
import org.exoplatform.wallet.model.transaction.TransactionDetail;
import org.exoplatform.wallet.service.WalletAccountService;
import org.exoplatform.wallet.service.WalletTransactionService;

@Asynchronous
public class TransactionMinedListener
extends Listener<Object, Map<String, Object>> {
    private WalletAccountService accountService;
    private WalletTransactionService walletTransactionService;
    private ListenerService listenerService;

    public TransactionMinedListener(WalletAccountService accountService, WalletTransactionService walletTransactionService, ListenerService listenerService) {
        this.accountService = accountService;
        this.walletTransactionService = walletTransactionService;
        this.listenerService = listenerService;
    }

    public void onEvent(Event<Object, Map<String, Object>> event) throws Exception {
        Map transactionDetailObject = (Map)event.getData();
        String hash = (String)transactionDetailObject.get("hash");
        TransactionDetail transactionDetail = this.walletTransactionService.getTransactionByHash(hash);
        if (transactionDetail == null) {
            return;
        }
        HashMap<String, Set<String>> walletsModifications = new HashMap<String, Set<String>>();
        this.addWalletsModification(transactionDetail, walletsModifications);
        if (!walletsModifications.isEmpty()) {
            this.accountService.refreshWalletsFromBlockchain(walletsModifications);
        }
        this.listenerService.broadcast("exo.wallet.transaction.minedAndUpdated", null, (Object)transactionDetail);
    }

    private void addWalletsModification(TransactionDetail transactionDetail, Map<String, Set<String>> walletsModifications) {
        this.addWalletModificationState(transactionDetail.getFromWallet(), "ether_transfer", walletsModifications);
        String contractMethodName = transactionDetail.getContractMethodName();
        if (StringUtils.isBlank((CharSequence)contractMethodName)) {
            this.addWalletModificationState(transactionDetail.getToWallet(), "ether_transfer", walletsModifications);
        } else if (StringUtils.equals((CharSequence)contractMethodName, (CharSequence)"transfer") || StringUtils.equals((CharSequence)contractMethodName, (CharSequence)"transferFrom")) {
            this.addWalletModificationState(transactionDetail.getFromWallet(), contractMethodName, walletsModifications);
            this.addWalletModificationState(transactionDetail.getToWallet(), contractMethodName, walletsModifications);
            this.addWalletModificationState(transactionDetail.getByWallet(), contractMethodName, walletsModifications);
        }
    }

    private void addWalletModificationState(Wallet wallet, String contractMethodName, Map<String, Set<String>> walletsModifications) {
        if (wallet == null) {
            return;
        }
        walletsModifications.computeIfAbsent(wallet.getAddress(), k -> new HashSet()).add(contractMethodName);
    }
}

