/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wallet.reward.dao;

import jakarta.persistence.TypedQuery;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.wallet.model.reward.RewardPeriodType;
import org.exoplatform.wallet.model.reward.RewardStatus;
import org.exoplatform.wallet.reward.entity.WalletRewardPeriodEntity;

public class RewardPeriodDAO
extends GenericDAOJPAImpl<WalletRewardPeriodEntity, Long> {
    public List<WalletRewardPeriodEntity> findRewardPeriods(int offset, int limit) {
        List result;
        TypedQuery query = this.getEntityManager().createNamedQuery("RewardPeriod.findRewardPeriods", WalletRewardPeriodEntity.class);
        if (offset > 0) {
            query.setFirstResult(offset);
        }
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        return CollectionUtils.isEmpty((Collection)(result = query.getResultList())) ? Collections.emptyList() : result;
    }

    public WalletRewardPeriodEntity findRewardPeriodByTypeAndTime(RewardPeriodType periodType, long periodTime) {
        TypedQuery query = this.getEntityManager().createNamedQuery("RewardPeriod.findRewardPeriodByTypeAndTime", WalletRewardPeriodEntity.class);
        query.setParameter("periodType", (Object)periodType);
        query.setParameter("periodTime", (Object)periodTime);
        List resultList = query.getResultList();
        return resultList == null || resultList.isEmpty() ? null : (WalletRewardPeriodEntity)resultList.get(0);
    }

    public List<WalletRewardPeriodEntity> findRewardPeriodsByStatus(RewardStatus status) {
        TypedQuery query = this.getEntityManager().createNamedQuery("RewardPlugin.findRewardPeriodsByStatus", WalletRewardPeriodEntity.class);
        query.setParameter("status", (Object)status);
        List resultList = query.getResultList();
        return resultList == null ? Collections.emptyList() : resultList;
    }
}

