/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wallet.reward.storage;

import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.wallet.model.Wallet;
import org.exoplatform.wallet.model.reward.RewardPeriod;
import org.exoplatform.wallet.model.reward.RewardPeriodType;
import org.exoplatform.wallet.model.reward.RewardReport;
import org.exoplatform.wallet.model.reward.RewardStatus;
import org.exoplatform.wallet.model.reward.RewardTeam;
import org.exoplatform.wallet.model.reward.WalletPluginReward;
import org.exoplatform.wallet.model.reward.WalletReward;
import org.exoplatform.wallet.model.transaction.TransactionDetail;
import org.exoplatform.wallet.reward.dao.RewardDAO;
import org.exoplatform.wallet.reward.dao.RewardPeriodDAO;
import org.exoplatform.wallet.reward.dao.RewardPluginDAO;
import org.exoplatform.wallet.reward.dao.RewardTeamDAO;
import org.exoplatform.wallet.reward.entity.RewardTeamEntity;
import org.exoplatform.wallet.reward.entity.WalletRewardEntity;
import org.exoplatform.wallet.reward.entity.WalletRewardPeriodEntity;
import org.exoplatform.wallet.reward.entity.WalletRewardPluginEntity;
import org.exoplatform.wallet.reward.storage.WalletRewardTeamStorage;
import org.exoplatform.wallet.service.WalletAccountService;
import org.exoplatform.wallet.service.WalletTransactionService;

public class WalletRewardReportStorage {
    private static final Log LOG = ExoLogger.getLogger(WalletRewardReportStorage.class);
    private RewardPluginDAO rewardPluginDAO;
    private RewardDAO rewardDAO;
    private RewardPeriodDAO rewardPeriodDAO;
    private RewardTeamDAO rewardTeamDAO;
    private WalletRewardTeamStorage rewardTeamStorage;
    private WalletAccountService walletAccountService;
    private WalletTransactionService walletTransactionService;

    public WalletRewardReportStorage(RewardPluginDAO rewardPluginDAO, RewardDAO rewardDAO, RewardPeriodDAO rewardPeriodDAO, RewardTeamDAO rewardTeamDAO, WalletRewardTeamStorage rewardTeamStorage, WalletAccountService walletAccountService, WalletTransactionService walletTransactionService) {
        this.rewardPluginDAO = rewardPluginDAO;
        this.rewardDAO = rewardDAO;
        this.rewardPeriodDAO = rewardPeriodDAO;
        this.rewardTeamDAO = rewardTeamDAO;
        this.rewardTeamStorage = rewardTeamStorage;
        this.walletAccountService = walletAccountService;
        this.walletTransactionService = walletTransactionService;
    }

    public List<RewardPeriod> findRewardReportPeriods(int offset, int limit) {
        List<WalletRewardPeriodEntity> rewardPeriodEntities = this.rewardPeriodDAO.findRewardPeriods(offset, limit);
        return rewardPeriodEntities.stream().map(this::toDTO).toList();
    }

    public RewardReport getRewardReportByPeriodId(long id, ZoneId zoneId) {
        return this.getRewardReport((WalletRewardPeriodEntity)this.rewardPeriodDAO.find(Long.valueOf(id)), zoneId);
    }

    public RewardReport getRewardReport(RewardPeriodType periodType, LocalDate date, ZoneId zoneId) {
        RewardPeriod period = periodType.getPeriodOfTime(date, zoneId);
        WalletRewardPeriodEntity rewardPeriodEntity = this.rewardPeriodDAO.findRewardPeriodByTypeAndTime(periodType, period.getPeriodMedianDateInSeconds());
        return this.getRewardReport(rewardPeriodEntity, zoneId);
    }

    public RewardPeriod getRewardPeriod(RewardPeriodType periodType, LocalDate date, ZoneId zoneId) {
        RewardPeriod period = periodType.getPeriodOfTime(date, zoneId);
        WalletRewardPeriodEntity rewardPeriodEntity = this.rewardPeriodDAO.findRewardPeriodByTypeAndTime(periodType, period.getPeriodMedianDateInSeconds());
        return this.toDTO(rewardPeriodEntity);
    }

    private RewardReport getRewardReport(WalletRewardPeriodEntity rewardPeriodEntity, ZoneId zoneId) {
        if (rewardPeriodEntity == null) {
            return null;
        }
        RewardReport rewardReport = new RewardReport();
        RewardPeriod periodOfTime = this.toDTO(rewardPeriodEntity);
        periodOfTime = periodOfTime.getRewardPeriodType().getPeriodOfTime(periodOfTime.getPeriodMedianDate(), zoneId);
        periodOfTime.setId(rewardPeriodEntity.getId().longValue());
        rewardReport.setPeriod(periodOfTime);
        List<WalletRewardEntity> rewardEntities = this.rewardDAO.findRewardsByPeriodId(rewardPeriodEntity.getId());
        if (rewardEntities != null) {
            ArrayList walletRewardEntities = new ArrayList();
            rewardEntities.forEach(reward -> {
                List<WalletRewardEntity> walletRewardList = rewardEntities.stream().filter(wr -> wr.getIdentityId() == reward.getIdentityId()).toList();
                if (walletRewardList.size() == 1) {
                    walletRewardEntities.add(reward);
                } else {
                    WalletRewardEntity walletRewardEntity = walletRewardList.stream().filter(r -> r.getTransactionHash() != null).sorted((r2, r1) -> {
                        if (r1.getTokensSent() > r2.getTokensSent()) {
                            return 1;
                        }
                        if (r2.getTokensSent() > r1.getTokensSent()) {
                            return -1;
                        }
                        return 0;
                    }).findFirst().orElseGet(() -> (WalletRewardEntity)walletRewardList.get(0));
                    if (walletRewardEntity.getId().longValue() == reward.getId().longValue()) {
                        walletRewardEntities.add(reward);
                    }
                }
            });
            Set rewards = walletRewardEntities.stream().map(rewardEntity -> this.toDTO((WalletRewardEntity)rewardEntity, zoneId)).collect(Collectors.toSet());
            rewardReport.setRewards(rewards);
        }
        return rewardReport;
    }

    public void saveRewardReport(RewardReport rewardReport) {
        if (rewardReport == null) {
            throw new IllegalArgumentException("reward report is null");
        }
        RewardPeriod period = rewardReport.getPeriod();
        LOG.info("Saving reward report for period from {} to {}", new Object[]{period.getStartDateFormatted("en"), period.getEndDateFormatted("en")});
        WalletRewardPeriodEntity rewardPeriodEntity = this.rewardPeriodDAO.findRewardPeriodByTypeAndTime(period.getRewardPeriodType(), period.getPeriodMedianDateInSeconds());
        if (rewardPeriodEntity == null) {
            rewardPeriodEntity = new WalletRewardPeriodEntity();
        } else if (rewardPeriodEntity.getStatus() == RewardStatus.SUCCESS) {
            LOG.warn("Reward report  from {} to {} shouldn't be modified because it has been already marked as completed.", new Object[]{period.getStartDateFormatted("en"), period.getEndDateFormatted("en")});
        }
        rewardPeriodEntity.setPeriodType(period.getRewardPeriodType());
        rewardPeriodEntity.setStartTime(period.getStartDateInSeconds());
        rewardPeriodEntity.setEndTime(period.getEndDateInSeconds());
        rewardPeriodEntity.setTimeZone(period.getTimeZone());
        if (rewardReport.isCompletelyProceeded()) {
            rewardPeriodEntity.setStatus(RewardStatus.SUCCESS);
        } else if (rewardReport.getPendingTransactionCount() > 0L) {
            rewardPeriodEntity.setStatus(RewardStatus.PENDING);
        } else if (rewardReport.getFailedTransactionCount() > 0L) {
            rewardPeriodEntity.setStatus(RewardStatus.ERROR);
        } else if (rewardReport.getTransactionsCount() > 0L) {
            rewardPeriodEntity.setStatus(RewardStatus.PENDING);
        } else {
            rewardPeriodEntity.setStatus(RewardStatus.ESTIMATION);
        }
        rewardPeriodEntity = rewardPeriodEntity.getId() == null ? (WalletRewardPeriodEntity)this.rewardPeriodDAO.create(rewardPeriodEntity) : (WalletRewardPeriodEntity)this.rewardPeriodDAO.update(rewardPeriodEntity);
        Set rewards = rewardReport.getRewards();
        for (WalletReward walletReward : rewards) {
            if (walletReward.getWallet() == null || StringUtils.isBlank((CharSequence)walletReward.getWallet().getAddress())) continue;
            long identityId = walletReward.getIdentityId();
            WalletRewardEntity rewardEntity = this.rewardDAO.findRewardByIdentityIdAndPeriodId(identityId, rewardPeriodEntity.getId());
            if (rewardEntity == null) {
                rewardEntity = new WalletRewardEntity();
            }
            rewardEntity.setTokensSent(walletReward.getTokensSent());
            rewardEntity.setTokensToSend(walletReward.getTokensToSend());
            rewardEntity.setEnabled(walletReward.isEnabled());
            rewardEntity.setIdentityId(identityId);
            rewardEntity.setPeriod(rewardPeriodEntity);
            TransactionDetail rewardTransaction = walletReward.getTransaction();
            rewardEntity.setTransactionHash(rewardTransaction == null ? null : rewardTransaction.getHash());
            RewardTeam team = walletReward.getTeam();
            if (team == null) {
                rewardEntity.setTeam(null);
            } else {
                RewardTeamEntity teamEntity = (RewardTeamEntity)this.rewardTeamDAO.find(team.getId());
                rewardEntity.setTeam(teamEntity);
            }
            rewardEntity = rewardEntity.getId() == null ? (WalletRewardEntity)this.rewardDAO.create(rewardEntity) : (WalletRewardEntity)this.rewardDAO.update(rewardEntity);
            Set rewardPlugins = walletReward.getRewards();
            if (rewardPlugins == null || rewardPlugins.isEmpty()) continue;
            for (WalletPluginReward rewardPlugin : rewardPlugins) {
                WalletRewardPluginEntity rewardPluginEntity = this.rewardPluginDAO.getRewardPluginsByRewardIdAndPluginId(rewardEntity.getId(), rewardPlugin.getPluginId());
                if (rewardPluginEntity == null) {
                    rewardPluginEntity = new WalletRewardPluginEntity();
                }
                rewardPluginEntity.setAmount(rewardPlugin.getAmount());
                rewardPluginEntity.setPoints(rewardPlugin.getPoints());
                rewardPluginEntity.setPluginId(rewardPlugin.getPluginId());
                rewardPluginEntity.setPoolUsed(rewardPlugin.isPoolsUsed());
                rewardPluginEntity.setReward(rewardEntity);
                if (rewardPluginEntity.getId() == null) {
                    this.rewardPluginDAO.create(rewardPluginEntity);
                    continue;
                }
                this.rewardPluginDAO.update(rewardPluginEntity);
            }
        }
    }

    public List<RewardPeriod> findRewardPeriodsByStatus(RewardStatus rewardStatus) {
        List<WalletRewardPeriodEntity> rewardPeriodEntities = this.rewardPeriodDAO.findRewardPeriodsByStatus(rewardStatus);
        return rewardPeriodEntities.stream().map(this::toDTO).collect(Collectors.toList());
    }

    public List<WalletReward> listRewards(long identityId, ZoneId zoneId, int limit) {
        List<WalletRewardEntity> rewardEntities = this.rewardDAO.findRewardsByIdentityId(identityId, limit);
        List<WalletReward> walletRewards = rewardEntities.stream().map(rewardEntity -> this.toDTO((WalletRewardEntity)rewardEntity, zoneId)).collect(Collectors.toList());
        if (!walletRewards.isEmpty()) {
            WalletReward walletReward = walletRewards.get(0);
            Wallet wallet = walletReward.getWallet();
            this.walletAccountService.retrieveWalletBlockchainState(wallet);
            walletRewards.forEach(wr -> wr.setWallet(wallet));
        }
        return walletRewards;
    }

    public double countRewards(long identityId) {
        double countRewardsByUser = this.rewardDAO.countRewardsByIdentityId(identityId);
        return Double.isNaN(countRewardsByUser) ? 0.0 : countRewardsByUser;
    }

    public void replaceRewardTransactions(String oldHash, String newHash) {
        this.rewardDAO.replaceRewardTransactions(oldHash, newHash);
    }

    private RewardPeriod toDTO(WalletRewardPeriodEntity period) {
        if (period == null) {
            return null;
        }
        RewardPeriod rewardPeriod = new RewardPeriod(period.getPeriodType());
        rewardPeriod.setId(period.getId().longValue());
        rewardPeriod.setStartDateInSeconds(period.getStartTime());
        rewardPeriod.setEndDateInSeconds(period.getEndTime());
        if (StringUtils.isNotBlank((CharSequence)period.getTimeZone())) {
            rewardPeriod.setTimeZone(period.getTimeZone());
        }
        return rewardPeriod;
    }

    private void retrieveRewardPlugins(WalletRewardEntity rewardEntity, WalletReward walletReward) {
        Set<WalletPluginReward> rewardPlugins = this.getRewardPluginsByRewardId(rewardEntity.getId());
        walletReward.setRewards(rewardPlugins);
    }

    private Set<WalletPluginReward> getRewardPluginsByRewardId(Long rewardId) {
        List<WalletRewardPluginEntity> rewardsPluginEntities = this.rewardPluginDAO.getRewardPluginsByRewardId(rewardId);
        if (rewardsPluginEntities != null) {
            return rewardsPluginEntities.stream().map(this::toDTO).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    private WalletReward toDTO(WalletRewardEntity rewardEntity, ZoneId zoneId) {
        WalletReward walletReward = new WalletReward();
        this.retrieveTeam(rewardEntity, walletReward);
        this.retrieveWallet(rewardEntity, walletReward);
        this.retrieveTransaction(rewardEntity, walletReward);
        this.retrieveRewardPlugins(rewardEntity, walletReward);
        WalletRewardPeriodEntity periodEntity = rewardEntity.getPeriod();
        if (periodEntity != null && periodEntity.getPeriodType() != null) {
            RewardPeriodType rewardPeriodType = periodEntity.getPeriodType();
            ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(Instant.ofEpochSecond(periodEntity.getStartTime()), zoneId);
            walletReward.setPeriod(rewardPeriodType.getPeriodOfTime(zonedDateTime));
        }
        return walletReward;
    }

    private WalletPluginReward toDTO(WalletRewardPluginEntity rewardPluginEntity) {
        WalletPluginReward pluginReward = new WalletPluginReward();
        pluginReward.setIdentityId(rewardPluginEntity.getReward().getIdentityId());
        pluginReward.setPluginId(rewardPluginEntity.getPluginId());
        pluginReward.setPoolsUsed(rewardPluginEntity.isPoolUsed());
        pluginReward.setPoints(rewardPluginEntity.getPoints());
        pluginReward.setAmount(rewardPluginEntity.getAmount());
        return pluginReward;
    }

    private void retrieveTransaction(WalletRewardEntity rewardEntity, WalletReward walletReward) {
        String transactionHash = rewardEntity.getTransactionHash();
        if (StringUtils.isNotBlank((CharSequence)transactionHash)) {
            TransactionDetail transactionDetail = this.walletTransactionService.getTransactionByHash(transactionHash);
            walletReward.setTransaction(transactionDetail);
        }
    }

    private void retrieveTeam(WalletRewardEntity rewardEntity, WalletReward walletReward) {
        if (rewardEntity.getTeam() != null) {
            long teamId = rewardEntity.getTeam().getId();
            RewardTeam team = this.rewardTeamStorage.getTeamById(teamId);
            walletReward.setTeams(Collections.singletonList(team));
        }
    }

    private void retrieveWallet(WalletRewardEntity rewardEntity, WalletReward walletReward) {
        Wallet wallet = this.walletAccountService.getWalletByIdentityId(rewardEntity.getIdentityId());
        walletReward.setWallet(wallet);
    }
}

