/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wallet.model.reward;

import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.wallet.model.WalletType;
import org.exoplatform.wallet.utils.WalletUtils;

public class RewardTransaction
implements Serializable {
    private static final long serialVersionUID = 658273092293607458L;
    private String hash;
    private String periodType;
    private long startDateInSeconds;
    private String receiverType;
    private String receiverId;
    private long receiverIdentityId;
    private double tokensSent;
    private String status;

    public static RewardTransaction fromStoredValue(String storedTransactionDetails) {
        RewardTransaction transaction = new RewardTransaction();
        if (StringUtils.isNotBlank((CharSequence)storedTransactionDetails)) {
            String[] transactionDetailsArray = storedTransactionDetails.split(";");
            transaction.setHash(transactionDetailsArray[0]);
            transaction.setReceiverType(transactionDetailsArray.length > 1 ? WalletUtils.decodeString(transactionDetailsArray[1]) : null);
            transaction.setReceiverId(transactionDetailsArray.length > 2 ? WalletUtils.decodeString(transactionDetailsArray[2]) : null);
            String tokensSentString = transactionDetailsArray.length > 3 ? transactionDetailsArray[3] : null;
            transaction.setTokensSent(StringUtils.isBlank((CharSequence)tokensSentString) ? 0.0 : Double.parseDouble(tokensSentString));
            String receiverIdentityId = transactionDetailsArray.length > 4 ? transactionDetailsArray[4] : null;
            transaction.setReceiverIdentityId(StringUtils.isBlank((CharSequence)receiverIdentityId) || StringUtils.equals((CharSequence)"null", (CharSequence)receiverIdentityId) ? 0L : Long.parseLong(receiverIdentityId));
        }
        return transaction;
    }

    public String getToStoreValue() {
        Identity receiverIdentity = null;
        if (this.receiverIdentityId > 0L) {
            receiverIdentity = WalletUtils.getIdentityById(this.receiverIdentityId);
        } else {
            if (StringUtils.isBlank((CharSequence)this.receiverType)) {
                throw new IllegalStateException("receiverType is mandatory");
            }
            if (StringUtils.isBlank((CharSequence)this.receiverId)) {
                throw new IllegalStateException("receiverId is mandatory");
            }
            receiverIdentity = WalletUtils.getIdentityByTypeAndId(WalletType.getType(this.receiverType), this.receiverId);
        }
        return this.hash + ";;;" + this.tokensSent + ";" + receiverIdentity.getId();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RewardTransaction)) {
            return false;
        }
        return StringUtils.equalsIgnoreCase((CharSequence)this.hash, (CharSequence)((RewardTransaction)obj).getHash());
    }

    public int hashCode() {
        return this.hash == null ? 0 : this.hash.hashCode();
    }

    public String getHash() {
        return this.hash;
    }

    public String getPeriodType() {
        return this.periodType;
    }

    public long getStartDateInSeconds() {
        return this.startDateInSeconds;
    }

    public String getReceiverType() {
        return this.receiverType;
    }

    public String getReceiverId() {
        return this.receiverId;
    }

    public long getReceiverIdentityId() {
        return this.receiverIdentityId;
    }

    public double getTokensSent() {
        return this.tokensSent;
    }

    public String getStatus() {
        return this.status;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public void setPeriodType(String periodType) {
        this.periodType = periodType;
    }

    public void setStartDateInSeconds(long startDateInSeconds) {
        this.startDateInSeconds = startDateInSeconds;
    }

    public void setReceiverType(String receiverType) {
        this.receiverType = receiverType;
    }

    public void setReceiverId(String receiverId) {
        this.receiverId = receiverId;
    }

    public void setReceiverIdentityId(long receiverIdentityId) {
        this.receiverIdentityId = receiverIdentityId;
    }

    public void setTokensSent(double tokensSent) {
        this.tokensSent = tokensSent;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String toString() {
        return "RewardTransaction(hash=" + this.getHash() + ", periodType=" + this.getPeriodType() + ", startDateInSeconds=" + this.getStartDateInSeconds() + ", receiverType=" + this.getReceiverType() + ", receiverId=" + this.getReceiverId() + ", receiverIdentityId=" + this.getReceiverIdentityId() + ", tokensSent=" + this.getTokensSent() + ", status=" + this.getStatus() + ")";
    }
}

