/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.wallet.reward.plugin;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.exoplatform.addon.wallet.reward.api.RewardPlugin;
import org.exoplatform.addon.wallet.utils.RewardUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.xml.Component;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class KudosRewardPlugin
extends RewardPlugin {
    private static final Log LOG = ExoLogger.getLogger(KudosRewardPlugin.class);
    private static final String KUDOS_SERVICE_FQN = "org.exoplatform.addon.kudos.service.KudosService";
    private static final String COUNT_USERS_KUDOS_METHOD_NAME = "countKudosByPeriodAndReceiver";
    private ConfigurationManager configurationManager;
    private ExoContainer container;
    private Object serviceInstance;
    private Method retrievePointsMethod;
    private boolean enabled;

    public KudosRewardPlugin(ExoContainer container, ConfigurationManager configurationManager) {
        this.container = container;
        this.configurationManager = configurationManager;
        Component component = this.configurationManager.getComponent(KUDOS_SERVICE_FQN);
        this.enabled = component != null;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Map<Long, Double> getEarnedPoints(Set<Long> identityIds, long startDateInSeconds, long endDateInSeconds) {
        HashMap<Long, Double> earnedPoints = new HashMap<Long, Double>();
        if (identityIds == null || identityIds.isEmpty()) {
            return earnedPoints;
        }
        Method method = this.getMethod();
        if (method == null) {
            throw new IllegalStateException("Can't find kudos service method to retrieve user points");
        }
        for (Long identityId : identityIds) {
            long points = 0L;
            try {
                points = (Long)method.invoke(this.getService(), identityId, startDateInSeconds, endDateInSeconds);
            }
            catch (Exception e) {
                LOG.warn("Error getting kudos count for user with id {}", new Object[]{identityId, e});
            }
            earnedPoints.put(identityId, Double.valueOf(points));
        }
        return earnedPoints;
    }

    private Method getMethod() {
        if (this.retrievePointsMethod != null) {
            return this.retrievePointsMethod;
        }
        this.retrievePointsMethod = RewardUtils.getMethod((ExoContainer)this.container, (String)KUDOS_SERVICE_FQN, (String)COUNT_USERS_KUDOS_METHOD_NAME);
        return this.retrievePointsMethod;
    }

    private Object getService() {
        if (this.serviceInstance != null) {
            return this.serviceInstance;
        }
        this.serviceInstance = RewardUtils.getService((ExoContainer)this.container, (String)KUDOS_SERVICE_FQN);
        return this.serviceInstance;
    }
}

