/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.wallet.reward.service;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.addon.wallet.model.ContractDetail;
import org.exoplatform.addon.wallet.model.Wallet;
import org.exoplatform.addon.wallet.model.WalletType;
import org.exoplatform.addon.wallet.model.reward.RewardBudgetType;
import org.exoplatform.addon.wallet.model.reward.RewardPeriod;
import org.exoplatform.addon.wallet.model.reward.RewardPeriodType;
import org.exoplatform.addon.wallet.model.reward.RewardPluginSettings;
import org.exoplatform.addon.wallet.model.reward.RewardSettings;
import org.exoplatform.addon.wallet.model.reward.RewardTeam;
import org.exoplatform.addon.wallet.model.reward.RewardTeamMember;
import org.exoplatform.addon.wallet.model.reward.RewardTransaction;
import org.exoplatform.addon.wallet.model.reward.WalletPluginReward;
import org.exoplatform.addon.wallet.model.reward.WalletReward;
import org.exoplatform.addon.wallet.model.settings.GlobalSettings;
import org.exoplatform.addon.wallet.model.transaction.TransactionDetail;
import org.exoplatform.addon.wallet.reward.api.RewardPlugin;
import org.exoplatform.addon.wallet.reward.service.RewardService;
import org.exoplatform.addon.wallet.reward.service.RewardSettingsService;
import org.exoplatform.addon.wallet.reward.service.RewardTeamService;
import org.exoplatform.addon.wallet.reward.service.RewardTransactionService;
import org.exoplatform.addon.wallet.service.WalletAccountService;
import org.exoplatform.addon.wallet.service.WalletTokenAdminService;
import org.exoplatform.addon.wallet.service.WalletTransactionService;
import org.exoplatform.addon.wallet.utils.RewardUtils;
import org.exoplatform.addon.wallet.utils.WalletUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class WalletRewardService
implements RewardService {
    private static final Log LOG = ExoLogger.getLogger(WalletRewardService.class);
    private WalletAccountService walletAccountService;
    private WalletTransactionService walletTransactionService;
    private WalletTokenAdminService walletTokenAdminService;
    private RewardSettingsService rewardSettingsService;
    private RewardTeamService rewardTeamService;
    private RewardTransactionService rewardTransactionService;

    public WalletRewardService(WalletAccountService walletAccountService, WalletTransactionService walletTransactionService, RewardSettingsService rewardSettingsService, RewardTransactionService rewardTransactionService, RewardTeamService rewardTeamService) {
        this.walletAccountService = walletAccountService;
        this.walletTransactionService = walletTransactionService;
        this.rewardSettingsService = rewardSettingsService;
        this.rewardTeamService = rewardTeamService;
        this.rewardTransactionService = rewardTransactionService;
    }

    public void sendRewards(long periodDateInSeconds, String username) throws Exception {
        Set<WalletReward> rewards = this.computeReward(periodDateInSeconds);
        if (rewards == null || rewards.isEmpty()) {
            return;
        }
        String adminWalletAddress = this.getTokenAdminService().getAdminWalletAddress();
        if (StringUtils.isBlank((String)adminWalletAddress)) {
            throw new IllegalStateException("No admin wallet is configured");
        }
        if (this.getTokenAdminService().getAdminLevel(adminWalletAddress) < 2) {
            throw new IllegalStateException("Configured admin wallet is not configured as admin on token. It must be a Token admin with level 2 at least.");
        }
        Iterator<WalletReward> rewardedWalletsIterator = rewards.iterator();
        while (rewardedWalletsIterator.hasNext()) {
            WalletReward walletReward = rewardedWalletsIterator.next();
            if (walletReward == null || !walletReward.isEnabled() || walletReward.getRewards() == null || walletReward.getTokensToSend() == 0.0) {
                rewardedWalletsIterator.remove();
                continue;
            }
            if (walletReward.getTokensToSend() < 0.0) {
                throw new IllegalStateException("Can't send reward transaction for wallet of " + walletReward.getWallet().getType() + " " + walletReward.getWallet().getId() + " with a negative amount" + walletReward.getTokensToSend());
            }
            RewardTransaction rewardTransaction = walletReward.getRewardTransaction();
            if (rewardTransaction == null || !StringUtils.isNotBlank((String)rewardTransaction.getHash())) continue;
            rewardTransaction.setStartDateInSeconds(periodDateInSeconds);
            String hash = rewardTransaction.getHash();
            String transactionStatus = rewardTransaction.getStatus();
            if (StringUtils.isBlank((String)transactionStatus)) {
                LOG.warn("Can't find transaction detail of hash {} as reward transaction for {} '{}' in period {}. The reward will be re-sent.", new Object[]{hash, walletReward.getWallet().getType(), walletReward.getWallet().getId(), new Date(periodDateInSeconds * 1000L)});
                continue;
            }
            if (StringUtils.equals((String)transactionStatus, (String)"pending")) {
                throw new IllegalStateException("Reward transaction " + hash + " is pending, thus no reward sending is allowed until the transactions finishes");
            }
            if (!StringUtils.equals((String)transactionStatus, (String)"success")) continue;
            rewardedWalletsIterator.remove();
        }
        if (rewards.isEmpty()) {
            throw new IllegalStateException("No rewards to send for selected period");
        }
        GlobalSettings settings = WalletUtils.getSettings();
        ContractDetail contractDetail = settings.getContractDetail();
        if (contractDetail == null) {
            throw new IllegalStateException("Token with address " + settings.getContractAddress() + "wasn't found");
        }
        RewardSettings rewardSettings = this.rewardSettingsService.getSettings();
        if (rewardSettings == null) {
            throw new IllegalStateException("No reward settings is found");
        }
        RewardPeriodType periodType = rewardSettings.getPeriodType();
        RewardPeriod periodOfTime = periodType.getPeriodOfTime(RewardUtils.timeFromSeconds((long)periodDateInSeconds));
        BigInteger adminTokenBalance = this.getTokenAdminService().balanceOf(adminWalletAddress);
        double adminBalance = WalletUtils.convertFromDecimals((BigInteger)adminTokenBalance, (int)contractDetail.getDecimals());
        double rewardsAmount = rewards.stream().mapToDouble(WalletReward::getTokensToSend).sum();
        if (rewardsAmount > adminBalance) {
            throw new IllegalStateException("Admin doesn't have enough funds to send rewards");
        }
        for (WalletReward walletReward : rewards) {
            TransactionDetail transactionDetail = new TransactionDetail();
            transactionDetail.setFrom(adminWalletAddress);
            transactionDetail.setTo(walletReward.getWallet().getAddress());
            transactionDetail.setContractAmount(walletReward.getTokensToSend());
            transactionDetail.setValue(walletReward.getTokensToSend());
            String transactionLabel = this.getTransactionLabel(walletReward, contractDetail, periodOfTime);
            transactionDetail.setLabel(transactionLabel);
            String transactionMessage = this.getTransactionMessage(walletReward, contractDetail, periodOfTime);
            transactionDetail.setMessage(transactionMessage);
            transactionDetail = this.getTokenAdminService().reward(transactionDetail, username);
            RewardTransaction rewardTransaction = walletReward.getRewardTransaction();
            if (rewardTransaction == null) {
                rewardTransaction = new RewardTransaction();
            }
            rewardTransaction.setHash(transactionDetail.getHash());
            rewardTransaction.setPeriodType(periodType.name());
            rewardTransaction.setReceiverId(walletReward.getWallet().getId());
            rewardTransaction.setReceiverType(walletReward.getWallet().getType());
            rewardTransaction.setReceiverIdentityId(walletReward.getWallet().getTechnicalId());
            rewardTransaction.setStartDateInSeconds(periodOfTime.getStartDateInSeconds());
            rewardTransaction.setStatus("pending");
            rewardTransaction.setTokensSent(walletReward.getTokensToSend());
            this.rewardTransactionService.saveRewardTransaction(rewardTransaction);
        }
    }

    public Set<WalletReward> computeReward(long periodDateInSeconds) {
        if (periodDateInSeconds == 0L) {
            throw new IllegalArgumentException("periodDate is mandatory");
        }
        RewardSettings rewardSettings = this.rewardSettingsService.getSettings();
        if (rewardSettings == null) {
            throw new IllegalStateException("Error computing rewards using empty settings");
        }
        if (rewardSettings.getPeriodType() == null) {
            throw new IllegalStateException("Error computing rewards using empty period type");
        }
        Set<Wallet> wallets = this.walletAccountService.listWallets();
        for (Wallet wallet2 : wallets) {
            this.walletAccountService.retrieveWalletBlockchainState(wallet2);
        }
        Set<Long> identityIds = (wallets = wallets.stream().filter(wallet -> WalletType.isUser((String)wallet.getType())).collect(Collectors.toSet())).stream().map(Wallet::getTechnicalId).collect(Collectors.toSet());
        if (identityIds == null || identityIds.isEmpty()) {
            return Collections.emptySet();
        }
        Set<Long> enabledIdentityIds = this.getEnabledWallets(wallets);
        Set<WalletReward> walletRewards = this.buildWalletRewardObjects(wallets, enabledIdentityIds);
        RewardPeriodType periodType = rewardSettings.getPeriodType();
        RewardPeriod periodOfTime = periodType.getPeriodOfTime(RewardUtils.timeFromSeconds((long)periodDateInSeconds));
        this.retrieveRewardPeriodTransactionStatus(walletRewards, periodType, periodOfTime);
        this.computeRewardDetails(walletRewards, rewardSettings, periodOfTime, identityIds, enabledIdentityIds);
        return walletRewards;
    }

    private Set<WalletReward> buildWalletRewardObjects(Set<Wallet> wallets, Set<Long> enabledIdentityIds) {
        HashSet<WalletReward> walletRewards = new HashSet<WalletReward>();
        for (Wallet wallet : wallets) {
            WalletReward walletReward = new WalletReward();
            walletReward.setWallet(wallet);
            walletReward.setEnabled(enabledIdentityIds.contains(wallet.getTechnicalId()));
            walletReward.setRewards(Collections.emptySet());
            walletRewards.add(walletReward);
        }
        List teams = this.rewardTeamService.getTeams();
        for (RewardTeam rewardTeam : teams) {
            List members = rewardTeam.getMembers();
            if (members == null) continue;
            for (RewardTeamMember teamMember : members) {
                WalletReward walletReward = walletRewards.stream().filter(walletRewardTmp -> walletRewardTmp.getWallet().getTechnicalId() == teamMember.getIdentityId().longValue()).findFirst().orElse(null);
                if (walletReward == null) continue;
                walletReward.setPoolName(rewardTeam.getName());
            }
        }
        return walletRewards;
    }

    private void retrieveRewardPeriodTransactionStatus(Set<WalletReward> walletRewards, RewardPeriodType periodType, RewardPeriod periodOfTime) {
        List rewardTransactions = this.rewardTransactionService.getRewardTransactions(periodType.name(), periodOfTime.getStartDateInSeconds());
        for (WalletReward walletReward : walletRewards) {
            String hash;
            TransactionDetail transactionDetail;
            RewardTransaction rewardTransaction = rewardTransactions.stream().filter(transaction -> transaction.getReceiverIdentityId() == walletReward.getWallet().getTechnicalId()).findFirst().orElse(null);
            walletReward.setRewardTransaction(rewardTransaction);
            if (rewardTransaction == null || !StringUtils.isNotBlank((String)rewardTransaction.getHash()) || (transactionDetail = this.walletTransactionService.getTransactionByHash(hash = rewardTransaction.getHash())) == null) continue;
            if (transactionDetail.isPending()) {
                rewardTransaction.setStatus("pending");
            } else if (transactionDetail.isSucceeded()) {
                rewardTransaction.setStatus("success");
            } else {
                rewardTransaction.setStatus("error");
            }
            Wallet receiver = transactionDetail.getToWallet();
            rewardTransaction.setPeriodType(periodType.name());
            rewardTransaction.setStartDateInSeconds(periodOfTime.getStartDateInSeconds());
            if (receiver == null) continue;
            rewardTransaction.setReceiverId(receiver.getId());
            rewardTransaction.setReceiverType(receiver.getType());
            rewardTransaction.setReceiverIdentityId(receiver.getTechnicalId());
        }
    }

    private void computeRewardDetails(Set<WalletReward> walletRewards, RewardSettings rewardSettings, RewardPeriod periodOfTime, Set<Long> identityIds, Set<Long> enabledIdentityIds) {
        Set<RewardPluginSettings> pluginSettings = rewardSettings.getPluginSettings();
        if ((pluginSettings = pluginSettings.stream().filter(RewardPluginSettings::isEnabled).collect(Collectors.toSet())) == null || pluginSettings.isEmpty()) {
            return;
        }
        Collection rewardPlugins = this.rewardSettingsService.getRewardPlugins();
        rewardPlugins = rewardPlugins.stream().filter(RewardPlugin::isEnabled).collect(Collectors.toSet());
        Set<Long> walletsWithEnabledTeam = this.getEnabledTeamMembers(enabledIdentityIds);
        HashSet<WalletPluginReward> walletRewardsByPlugin = new HashSet<WalletPluginReward>();
        for (RewardPlugin rewardPlugin : rewardPlugins) {
            RewardPluginSettings rewardPluginSettings;
            if (rewardPlugin == null || !rewardPlugin.isEnabled() || (rewardPluginSettings = this.getPluginSetting(pluginSettings, rewardPlugin.getPluginId())) == null) continue;
            Map earnedPoints = rewardPlugin.getEarnedPoints(identityIds, periodOfTime.getStartDateInSeconds(), periodOfTime.getEndDateInSeconds());
            Set<Long> validIdentityIdsToUse = rewardPluginSettings.isUsePools() ? walletsWithEnabledTeam : enabledIdentityIds;
            this.computeReward(rewardPluginSettings, earnedPoints, validIdentityIdsToUse, walletRewardsByPlugin);
        }
        for (WalletReward walletReward : walletRewards) {
            Set rewardDetails = walletRewardsByPlugin.stream().filter(rewardByPlugin -> rewardByPlugin.getIdentityId() == walletReward.getWallet().getTechnicalId()).collect(Collectors.toSet());
            walletReward.setRewards(rewardDetails);
        }
    }

    private Set<Long> getEnabledTeamMembers(Set<Long> identityIds) {
        HashSet<Long> walletsWithEnabledTeam = new HashSet<Long>(identityIds);
        List teams = this.rewardTeamService.getTeams();
        for (RewardTeam rewardTeam : teams) {
            if (!rewardTeam.isDisabled() || rewardTeam.getMembers() == null || rewardTeam.getMembers().isEmpty()) continue;
            rewardTeam.getMembers().forEach(member -> walletsWithEnabledTeam.remove(member.getIdentityId()));
        }
        return walletsWithEnabledTeam;
    }

    private Set<Long> getEnabledWallets(Set<Wallet> wallets) {
        HashSet<Wallet> enabledWallets = new HashSet<Wallet>(wallets);
        Iterator enabledWalletsIterator = enabledWallets.iterator();
        while (enabledWalletsIterator.hasNext()) {
            Wallet wallet = (Wallet)enabledWalletsIterator.next();
            if (wallet == null) {
                enabledWalletsIterator.remove();
                continue;
            }
            this.walletAccountService.retrieveWalletBlockchainState(wallet);
            if (wallet.isEnabled() && !wallet.isDeletedUser() && !wallet.isDisabledUser() && wallet.getIsApproved() != null && wallet.getIsApproved().booleanValue()) continue;
            enabledWalletsIterator.remove();
        }
        return enabledWallets.stream().map(Wallet::getTechnicalId).collect(Collectors.toSet());
    }

    private RewardPluginSettings getPluginSetting(Set<RewardPluginSettings> pluginSettings, String pluginId) {
        for (RewardPluginSettings rewardPluginSettings : pluginSettings) {
            if (!StringUtils.equals((String)pluginId, (String)rewardPluginSettings.getPluginId())) continue;
            return rewardPluginSettings;
        }
        return null;
    }

    private void computeReward(RewardPluginSettings rewardPluginSettings, Map<Long, Double> earnedPoints, Set<Long> validIdentityIdsToUse, Set<WalletPluginReward> rewardMemberDetails) {
        RewardBudgetType budgetType = rewardPluginSettings.getBudgetType();
        if (budgetType == null) {
            LOG.warn("Budget type of reward plugin {} is empty, thus no computing is possible", new Object[]{rewardPluginSettings.getPluginId()});
            return;
        }
        String pluginId = rewardPluginSettings.getPluginId();
        double configuredPluginAmount = rewardPluginSettings.getAmount();
        if (configuredPluginAmount < 0.0) {
            throw new IllegalStateException("Plugin " + pluginId + " has a configured negative reward amount (" + configuredPluginAmount + ")");
        }
        this.filterElligibleMembers(earnedPoints.entrySet(), validIdentityIdsToUse, rewardPluginSettings, rewardMemberDetails);
        double amountPerPoint = 0.0;
        double totalFixedBudget = 0.0;
        switch (budgetType) {
            case FIXED_PER_POINT: {
                amountPerPoint = configuredPluginAmount;
                this.addRewardsSwitchPointAmount(rewardMemberDetails, earnedPoints.entrySet(), pluginId, amountPerPoint);
                break;
            }
            case FIXED: {
                totalFixedBudget = configuredPluginAmount;
                this.addTeamMembersReward(rewardPluginSettings, earnedPoints, totalFixedBudget, rewardMemberDetails);
                break;
            }
            case FIXED_PER_MEMBER: {
                double budgetPerMember = configuredPluginAmount;
                int totalElligibleMembersCount = earnedPoints.size();
                totalFixedBudget = budgetPerMember * (double)totalElligibleMembersCount;
                this.addTeamMembersReward(rewardPluginSettings, earnedPoints, totalFixedBudget, rewardMemberDetails);
                break;
            }
            default: {
                throw new IllegalStateException("Budget type is not recognized in plugin settings: " + pluginId + ", budget type = " + budgetType);
            }
        }
    }

    private void addTeamMembersReward(RewardPluginSettings rewardPluginSettings, Map<Long, Double> earnedPoints, double totalFixedBudget, Set<WalletPluginReward> rewardMemberDetails) {
        if (totalFixedBudget <= 0.0) {
            return;
        }
        if (rewardPluginSettings.isUsePools()) {
            List teams = this.rewardTeamService.getTeams();
            Set<Long> identityIds = this.filterEligibleMembersAndTeams(teams, earnedPoints);
            this.buildNoPoolUsers(earnedPoints, teams, identityIds);
            this.computeTeamsMembersBudget(rewardPluginSettings.getPluginId(), teams, totalFixedBudget, rewardMemberDetails, earnedPoints);
        } else {
            double totalPoints = earnedPoints.entrySet().stream().collect(Collectors.summingDouble(entry -> (Double)entry.getValue()));
            if (totalPoints <= 0.0 || totalFixedBudget <= 0.0) {
                return;
            }
            double amountPerPoint = totalFixedBudget / totalPoints;
            this.addRewardsSwitchPointAmount(rewardMemberDetails, earnedPoints.entrySet(), rewardPluginSettings.getPluginId(), amountPerPoint);
        }
    }

    private void addRewardsSwitchPointAmount(Set<WalletPluginReward> rewardMemberDetails, Set<Map.Entry<Long, Double>> identitiesPointsEntries, String pluginId, double amountPerPoint) {
        for (Map.Entry<Long, Double> identitiyPointsEntry : identitiesPointsEntries) {
            Long identityId = identitiyPointsEntry.getKey();
            Double points = identitiyPointsEntry.getValue();
            double amount = points * amountPerPoint;
            WalletPluginReward rewardMemberDetail = new WalletPluginReward();
            rewardMemberDetail.setIdentityId(identityId.longValue());
            rewardMemberDetail.setPluginId(pluginId);
            rewardMemberDetail.setPoints(points.doubleValue());
            rewardMemberDetail.setAmount(amount);
            rewardMemberDetail.setPoolsUsed(false);
            rewardMemberDetails.add(rewardMemberDetail);
        }
    }

    private void filterElligibleMembers(Set<Map.Entry<Long, Double>> identitiesPointsEntries, Set<Long> validIdentityIdsToUse, RewardPluginSettings rewardPluginSettings, Set<WalletPluginReward> rewardMemberDetails) {
        String pluginId = rewardPluginSettings.getPluginId();
        double threshold = rewardPluginSettings.getThreshold();
        Iterator<Map.Entry<Long, Double>> identitiesPointsIterator = identitiesPointsEntries.iterator();
        while (identitiesPointsIterator.hasNext()) {
            Map.Entry<Long, Double> entry = identitiesPointsIterator.next();
            Long identityId = entry.getKey();
            Double points = entry.getValue();
            points = points == null ? 0.0 : points;
            if (points < 0.0) {
                throw new IllegalStateException("Plugin with id " + pluginId + " has assigned a negative points (" + points + ") to user with id " + identityId);
            }
            if (!(points < threshold) && points != 0.0 && validIdentityIdsToUse.contains(identityId)) continue;
            identitiesPointsIterator.remove();
            if (!(points > 0.0)) continue;
            WalletPluginReward rewardMemberDetail = new WalletPluginReward();
            rewardMemberDetail.setIdentityId(identityId.longValue());
            rewardMemberDetail.setPluginId(pluginId);
            rewardMemberDetail.setPoints(points.doubleValue());
            rewardMemberDetail.setAmount(0.0);
            rewardMemberDetail.setPoolsUsed(rewardPluginSettings.isUsePools());
            rewardMemberDetails.add(rewardMemberDetail);
        }
    }

    private void computeTeamsMembersBudget(String pluginId, List<RewardTeam> teams, double totalTeamsBudget, Set<WalletPluginReward> rewardMemberDetails, Map<Long, Double> earnedPoints) {
        double totalFixedTeamsBudget = 0.0;
        double computedRecipientsCount = 0.0;
        ArrayList<RewardTeam> computedBudgetTeams = new ArrayList<RewardTeam>();
        HashMap<Long, Double> totalPointsPerTeam = new HashMap<Long, Double>();
        for (RewardTeam rewardTeam2 : teams) {
            double totalTeamBudget;
            RewardBudgetType teamBudgetType = rewardTeam2.getRewardType();
            if (rewardTeam2.getMembers() == null || rewardTeam2.getMembers().isEmpty()) continue;
            double totalTeamPoints = rewardTeam2.getMembers().stream().collect(Collectors.summingDouble(member -> (Double)earnedPoints.get(member.getIdentityId())));
            if (teamBudgetType == RewardBudgetType.COMPUTED) {
                computedRecipientsCount += (double)rewardTeam2.getMembers().size();
                computedBudgetTeams.add(rewardTeam2);
                totalPointsPerTeam.put(rewardTeam2.getId(), totalTeamPoints);
                continue;
            }
            if (teamBudgetType == RewardBudgetType.FIXED_PER_MEMBER) {
                totalTeamBudget = rewardTeam2.getBudget() * (double)rewardTeam2.getMembers().size();
                this.addTeamRewardRepartition(rewardTeam2, totalTeamBudget, totalTeamPoints, pluginId, earnedPoints, rewardMemberDetails);
                totalFixedTeamsBudget += totalTeamBudget;
                continue;
            }
            if (teamBudgetType != RewardBudgetType.FIXED) continue;
            totalTeamBudget = rewardTeam2.getBudget();
            this.addTeamRewardRepartition(rewardTeam2, totalTeamBudget, totalTeamPoints, pluginId, earnedPoints, rewardMemberDetails);
            totalFixedTeamsBudget += rewardTeam2.getBudget().doubleValue();
        }
        if (totalFixedTeamsBudget >= totalTeamsBudget) {
            throw new IllegalStateException("Total fixed teams budget is higher than fixed budget for all users");
        }
        if (computedRecipientsCount > 0.0 && !computedBudgetTeams.isEmpty()) {
            double remaingBudgetForComputedTeams = totalTeamsBudget - totalFixedTeamsBudget;
            double budgetPerTeamMember = remaingBudgetForComputedTeams / computedRecipientsCount;
            computedBudgetTeams.forEach(rewardTeam -> {
                if (rewardTeam.getMembers() != null && !rewardTeam.getMembers().isEmpty()) {
                    double totalTeamBudget = budgetPerTeamMember * (double)rewardTeam.getMembers().size();
                    Double totalTeamPoints = (Double)totalPointsPerTeam.get(rewardTeam.getId());
                    this.addTeamRewardRepartition((RewardTeam)rewardTeam, totalTeamBudget, totalTeamPoints, pluginId, earnedPoints, rewardMemberDetails);
                }
            });
        }
    }

    private void buildNoPoolUsers(Map<Long, Double> earnedPoints, List<RewardTeam> teams, Set<Long> identityIds) {
        ArrayList<Long> noPoolsIdentityIds = new ArrayList<Long>(earnedPoints.keySet());
        noPoolsIdentityIds.removeAll(identityIds);
        if (!noPoolsIdentityIds.isEmpty()) {
            RewardTeam noPoolRewardTeam = new RewardTeam();
            noPoolRewardTeam.setDisabled(false);
            List noPoolRewardTeamList = noPoolsIdentityIds.stream().map(identityId -> {
                RewardTeamMember rewardTeamMember = new RewardTeamMember();
                rewardTeamMember.setIdentityId(identityId);
                return rewardTeamMember;
            }).collect(Collectors.toList());
            noPoolRewardTeam.setMembers(noPoolRewardTeamList);
            noPoolRewardTeam.setId(Long.valueOf(0L));
            noPoolRewardTeam.setRewardType(RewardBudgetType.COMPUTED);
            teams.add(noPoolRewardTeam);
        }
    }

    private Set<Long> filterEligibleMembersAndTeams(List<RewardTeam> teams, Map<Long, Double> earnedPoints) {
        HashSet<Long> identityIds = new HashSet<Long>();
        Iterator<RewardTeam> teamsIterator = teams.iterator();
        while (teamsIterator.hasNext()) {
            RewardTeam rewardTeam = teamsIterator.next();
            List members = rewardTeam.getMembers();
            if (members == null || members.isEmpty()) {
                teamsIterator.remove();
                continue;
            }
            Iterator membersIterator = members.iterator();
            while (membersIterator.hasNext()) {
                RewardTeamMember member = (RewardTeamMember)membersIterator.next();
                Long identityId = member.getIdentityId();
                if (identityIds.contains(identityId)) {
                    throw new IllegalStateException("Team " + rewardTeam.getName() + " has a duplicated member in another Team");
                }
                identityIds.add(identityId);
                if (earnedPoints.containsKey(identityId)) continue;
                membersIterator.remove();
            }
        }
        return identityIds;
    }

    private String getTransactionLabel(WalletReward walletReward, ContractDetail contractDetail, RewardPeriod periodOfTime) {
        Wallet wallet = walletReward.getWallet();
        Locale locale = WalletUtils.getLocale((Wallet)wallet);
        String label = WalletUtils.getResourceBundleKey((Locale)locale, (String)"exoplatform.wallet.label.rewardTransactionLabel");
        if (StringUtils.isBlank((String)label)) {
            return "";
        }
        return label.replace("{0}", wallet.getName()).replace("{1}", WalletUtils.formatNumber((Object)walletReward.getTokensToSend(), (String)locale.getLanguage())).replace("{2}", contractDetail.getSymbol()).replace("{3}", RewardUtils.formatTime((long)periodOfTime.getStartDateInSeconds())).replace("{4}", RewardUtils.formatTime((long)(periodOfTime.getEndDateInSeconds() - 1L)));
    }

    private String getTransactionMessage(WalletReward walletReward, ContractDetail contractDetail, RewardPeriod periodOfTime) {
        StringBuilder transactionMessage = new StringBuilder();
        Set walletRewardsByPlugin = walletReward.getRewards();
        Locale locale = WalletUtils.getLocale((Wallet)walletReward.getWallet());
        for (WalletPluginReward walletPluginReward : walletRewardsByPlugin) {
            String label;
            String transactionMessagePart = null;
            if (walletPluginReward.isPoolsUsed()) {
                label = WalletUtils.getResourceBundleKey((Locale)locale, (String)"exoplatform.wallet.label.rewardTransactionMessageWithPool");
                if (StringUtils.isBlank((String)label)) continue;
                transactionMessagePart = label.replace("{0}", WalletUtils.formatNumber((Object)walletPluginReward.getAmount(), (String)locale.getLanguage())).replace("{1}", contractDetail.getSymbol()).replace("{2}", WalletUtils.formatNumber((Object)walletPluginReward.getPoints(), (String)locale.getLanguage())).replace("{3}", walletPluginReward.getPluginId()).replace("{4}", walletReward.getPoolName()).replace("{5}", RewardUtils.formatTime((long)periodOfTime.getStartDateInSeconds())).replace("{6}", RewardUtils.formatTime((long)(periodOfTime.getEndDateInSeconds() - 1L)));
            } else {
                label = WalletUtils.getResourceBundleKey((Locale)locale, (String)"exoplatform.wallet.label.rewardTransactionMessageNoPool");
                if (StringUtils.isBlank((String)label)) continue;
                transactionMessagePart = label.replace("{0}", WalletUtils.formatNumber((Object)walletPluginReward.getAmount(), (String)locale.getLanguage())).replace("{1}", contractDetail.getSymbol()).replace("{2}", WalletUtils.formatNumber((Object)walletPluginReward.getPoints(), (String)locale.getLanguage())).replace("{3}", walletPluginReward.getPluginId()).replace("{4}", RewardUtils.formatTime((long)periodOfTime.getStartDateInSeconds())).replace("{5}", RewardUtils.formatTime((long)(periodOfTime.getEndDateInSeconds() - 1L)));
            }
            transactionMessage.append(transactionMessagePart);
            transactionMessage.append("\r\n");
        }
        return transactionMessage.toString();
    }

    private void addTeamRewardRepartition(RewardTeam rewardTeam, double totalTeamBudget, double totalTeamPoints, String pluginId, Map<Long, Double> earnedPoints, Set<WalletPluginReward> rewardMemberDetails) {
        if (rewardTeam.getMembers() == null || rewardTeam.getMembers().isEmpty() || totalTeamBudget <= 0.0 || totalTeamPoints <= 0.0) {
            return;
        }
        double amountPerPoint = totalTeamBudget / totalTeamPoints;
        rewardTeam.getMembers().forEach(member -> {
            Long identityId = member.getIdentityId();
            Double points = (Double)earnedPoints.get(identityId);
            WalletPluginReward rewardMemberDetail = new WalletPluginReward();
            rewardMemberDetail.setIdentityId(identityId.longValue());
            rewardMemberDetail.setPluginId(pluginId);
            rewardMemberDetail.setPoints(points.doubleValue());
            rewardMemberDetail.setAmount(points * amountPerPoint);
            rewardMemberDetail.setPoolsUsed(true);
            rewardMemberDetails.add(rewardMemberDetail);
        });
    }

    private WalletTokenAdminService getTokenAdminService() {
        if (this.walletTokenAdminService == null) {
            this.walletTokenAdminService = (WalletTokenAdminService)CommonsUtils.getService(WalletTokenAdminService.class);
        }
        return this.walletTokenAdminService;
    }
}

