/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.wallet.reward.job;

import org.exoplatform.addon.wallet.model.reward.RewardReport;
import org.exoplatform.addon.wallet.model.reward.RewardSettings;
import org.exoplatform.addon.wallet.reward.service.RewardReportService;
import org.exoplatform.addon.wallet.utils.RewardUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

@DisallowConcurrentExecution
public class RewardCurrentPeriodStatusUpdaterJob
implements Job {
    private static final Log LOG = ExoLogger.getLogger(RewardCurrentPeriodStatusUpdaterJob.class);
    private ExoContainer container = PortalContainer.getInstance();
    private RewardReportService rewardReportService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext context) throws JobExecutionException {
        ExoContainer currentContainer = ExoContainerContext.getCurrentContainer();
        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
        RequestLifeCycle.begin((ExoContainer)this.container);
        try {
            RewardSettings rewardSettings = RewardUtils.getRewardSettings();
            if (rewardSettings != null && rewardSettings.getPeriodType() != null) {
                long currentTimeInSeconds = System.currentTimeMillis() / 1000L;
                RewardReport rewardReport = this.getRewardReportService().computeRewards(currentTimeInSeconds);
                if (rewardReport != null) {
                    this.getRewardReportService().saveRewardReport(rewardReport);
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while checking pending rewards", (Throwable)e);
        }
        finally {
            RequestLifeCycle.end();
            ExoContainerContext.setCurrentContainer((ExoContainer)currentContainer);
        }
    }

    private RewardReportService getRewardReportService() {
        if (this.rewardReportService == null) {
            this.rewardReportService = (RewardReportService)CommonsUtils.getService(RewardReportService.class);
        }
        return this.rewardReportService;
    }
}

