/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.wallet.reward.dao;

import java.util.List;
import javax.persistence.TypedQuery;
import org.exoplatform.addon.wallet.reward.entity.WalletRewardEntity;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class RewardDAO
extends GenericDAOJPAImpl<WalletRewardEntity, Long> {
    private static final Log LOG = ExoLogger.getLogger(RewardDAO.class);

    public List<WalletRewardEntity> findRewardsByPeriodId(long periodId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("Reward.findRewardsByPeriodId", WalletRewardEntity.class);
        query.setParameter("periodId", (Object)periodId);
        return query.getResultList();
    }

    public List<WalletRewardEntity> findRewardsByIdentityId(long identityId, int limit) {
        TypedQuery query = this.getEntityManager().createNamedQuery("Reward.findRewardsByIdentityId", WalletRewardEntity.class);
        query.setParameter("identityId", (Object)identityId);
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        return query.getResultList();
    }

    public WalletRewardEntity findRewardByIdentityIdAndPeriodId(long identityId, long periodId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("Reward.findRewardByIdentityIdAndPeriodId", WalletRewardEntity.class);
        query.setParameter("periodId", (Object)periodId);
        query.setParameter("identityId", (Object)identityId);
        List result = query.getResultList();
        if (result == null || result.isEmpty()) {
            return null;
        }
        if (result.size() > 1) {
            LOG.warn("More than one reward was found for identityId {} and periodId {}", new Object[]{identityId, periodId});
        }
        return (WalletRewardEntity)result.get(0);
    }
}

