/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wallet.reward.dao;

import java.util.List;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.exoplatform.commons.api.persistence.ExoTransactional;
import org.exoplatform.commons.persistence.impl.ExoTransactionalAspect;
import org.exoplatform.commons.persistence.impl.GenericDAOJPAImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.wallet.reward.dao.RewardDAO$AjcClosure1;
import org.exoplatform.wallet.reward.entity.WalletRewardEntity;

public class RewardDAO
extends GenericDAOJPAImpl<WalletRewardEntity, Long> {
    private static final Log LOG;
    private static final String IDENTITY_ID = "identityId";
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    public List<WalletRewardEntity> findRewardsByPeriodId(long periodId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("Reward.findRewardsByPeriodId", WalletRewardEntity.class);
        query.setParameter("periodId", (Object)periodId);
        return query.getResultList();
    }

    public List<WalletRewardEntity> findRewardsByIdentityId(long identityId, int limit) {
        TypedQuery query = this.getEntityManager().createNamedQuery("Reward.findRewardsByIdentityId", WalletRewardEntity.class);
        query.setParameter(IDENTITY_ID, (Object)identityId);
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        return query.getResultList();
    }

    public double countRewardsByIdentityId(long identityId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("Reward.countRewardsByIdentityId", Double.class);
        query.setParameter(IDENTITY_ID, (Object)identityId);
        return (Double)query.getSingleResult();
    }

    public WalletRewardEntity findRewardByIdentityIdAndPeriodId(long identityId, long periodId) {
        TypedQuery query = this.getEntityManager().createNamedQuery("Reward.findRewardByIdentityIdAndPeriodId", WalletRewardEntity.class);
        query.setParameter("periodId", (Object)periodId);
        query.setParameter(IDENTITY_ID, (Object)identityId);
        List result = query.getResultList();
        if (result == null || result.isEmpty()) {
            return null;
        }
        if (result.size() > 1) {
            LOG.warn("More than one reward was found for identityId {} and periodId {}", new Object[]{identityId, periodId});
        }
        return (WalletRewardEntity)result.get(0);
    }

    @ExoTransactional
    public void replaceRewardTransactions(String oldHash, String newHash) {
        String string = oldHash;
        String string2 = newHash;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)string, (Object)string2);
        Object[] objectArray = new Object[]{this, string, string2, joinPoint};
        RewardDAO$AjcClosure1 rewardDAO$AjcClosure1 = new RewardDAO$AjcClosure1(objectArray);
        ExoTransactionalAspect.aspectOf().around(rewardDAO$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    static {
        RewardDAO.ajc$preClinit();
        LOG = ExoLogger.getLogger(RewardDAO.class);
    }

    static /* synthetic */ void replaceRewardTransactions_aroundBody0(RewardDAO ajc$this, String oldHash, String newHash, JoinPoint joinPoint) {
        Query query = ajc$this.getEntityManager().createNamedQuery("Reward.updateTransactionHash");
        query.setParameter("oldHash", (Object)oldHash);
        query.setParameter("newHash", (Object)newHash);
        query.executeUpdate();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("RewardDAO.java", RewardDAO.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "replaceRewardTransactions", "org.exoplatform.wallet.reward.dao.RewardDAO", "java.lang.String:java.lang.String", "oldHash:newHash", "", "void"), 75);
    }
}

