/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wallet.reward;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.exoplatform.commons.utils.MapResourceBundle;
import org.exoplatform.component.test.AbstractKernelTest;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.wallet.dao.AddressLabelDAO;
import org.exoplatform.wallet.dao.WalletAccountDAO;
import org.exoplatform.wallet.dao.WalletBlockchainStateDAO;
import org.exoplatform.wallet.dao.WalletPrivateKeyDAO;
import org.exoplatform.wallet.dao.WalletTransactionDAO;
import org.exoplatform.wallet.entity.AddressLabelEntity;
import org.exoplatform.wallet.entity.TransactionEntity;
import org.exoplatform.wallet.entity.WalletEntity;
import org.exoplatform.wallet.entity.WalletPrivateKeyEntity;
import org.exoplatform.wallet.model.ContractDetail;
import org.exoplatform.wallet.model.Wallet;
import org.exoplatform.wallet.model.WalletAddressLabel;
import org.exoplatform.wallet.model.WalletProvider;
import org.exoplatform.wallet.model.WalletState;
import org.exoplatform.wallet.model.reward.RewardBudgetType;
import org.exoplatform.wallet.model.reward.RewardPluginSettings;
import org.exoplatform.wallet.model.reward.RewardSettings;
import org.exoplatform.wallet.model.reward.RewardTeam;
import org.exoplatform.wallet.model.reward.RewardTeamMember;
import org.exoplatform.wallet.model.transaction.TransactionDetail;
import org.exoplatform.wallet.reward.api.RewardPlugin;
import org.exoplatform.wallet.reward.dao.RewardDAO;
import org.exoplatform.wallet.reward.dao.RewardPeriodDAO;
import org.exoplatform.wallet.reward.dao.RewardPluginDAO;
import org.exoplatform.wallet.reward.dao.RewardTeamDAO;
import org.exoplatform.wallet.reward.entity.RewardTeamEntity;
import org.exoplatform.wallet.reward.service.WalletRewardSettingsService;
import org.exoplatform.wallet.reward.service.WalletRewardSettingsServiceTest;
import org.exoplatform.wallet.reward.test.mock.IdentityManagerMock;
import org.exoplatform.wallet.reward.test.mock.SpaceServiceMock;
import org.exoplatform.wallet.service.WalletService;
import org.exoplatform.wallet.utils.WalletUtils;
import org.junit.After;
import org.junit.Before;
import org.mockito.Mockito;

public abstract class BaseWalletRewardTest
extends AbstractKernelTest {
    private static final Log LOG = ExoLogger.getLogger(BaseWalletRewardTest.class);
    protected static final long IDENTITY_ID = 1L;
    protected static final String ADDRESS = "walletAddress";
    protected static final String PHRASE = "passphrase";
    protected static final String INITIALIZATION_STATE = WalletState.INITIALIZED.name();
    protected static final boolean IS_ENABLED = true;
    protected static final String CURRENT_USER = "root1";
    protected static final long MANAGER_IDENTITY_ID = 1L;
    protected static final long MEMBER_IDENTITY_ID = 2L;
    protected static final long SPACE_ID = 5L;
    protected static final String TEAM_NAME = "name";
    protected static final String TEAM_DESCRIPTION = "Team description";
    protected static final double TEAM_BUDGET = 2.0;
    protected static final RewardBudgetType TEAM_BUDGET_TYPE = RewardBudgetType.COMPUTED;
    protected static final String CUSTOM_PLUGIN_NAME = "plugin name";
    protected static final String CUSTOM_PLUGIN_ID = "custom";
    protected static final String PROVIDER = WalletProvider.INTERNAL_WALLET.name();
    protected static final RewardPlugin CUSTOM_REWARD_PLUGIN = new RewardPlugin(){

        public String getName() {
            return BaseWalletRewardTest.CUSTOM_PLUGIN_NAME;
        }

        public String getPluginId() {
            return BaseWalletRewardTest.CUSTOM_PLUGIN_ID;
        }

        public Map<Long, Double> getEarnedPoints(Set<Long> identityIds, long startDateInSeconds, long endDateInSeconds) {
            return WalletRewardSettingsServiceTest.getEarnedPoints(identityIds);
        }
    };
    protected PortalContainer container;
    private static RewardSettings defaultSettings = null;
    private Random random = new Random(1L);
    protected List<Serializable> entitiesToClean = new ArrayList<Serializable>();

    public static Map<Long, Double> getEarnedPoints(Set<Long> identityIds) {
        return identityIds.stream().collect(Collectors.toMap(Function.identity(), x -> x.doubleValue()));
    }

    @Before
    public void setUp() throws Exception {
        super.setUp();
        if (this.container == null) {
            BaseWalletRewardTest.assertNotNull((String)"Container shouldn't be null", (Object)this.getContainer());
            BaseWalletRewardTest.assertTrue((String)"Container should have been started", (boolean)this.getContainer().isStarted());
            IdentityManager identityManager = (IdentityManager)this.getContainer().getComponentInstanceOfType(IdentityManager.class);
            BaseWalletRewardTest.assertTrue((String)("Identity Manager should be mocked, found: " + identityManager.getClass().getName()), (boolean)(identityManager instanceof IdentityManagerMock));
            SpaceService spaceService = (SpaceService)this.getContainer().getComponentInstanceOfType(SpaceService.class);
            BaseWalletRewardTest.assertTrue((String)("SpaceService should be mocked, found: " + spaceService.getClass().getName()), (boolean)(spaceService instanceof SpaceServiceMock));
            this.container = this.getContainer();
            this.registerResourceBundleService();
            WalletRewardSettingsService rewardSettingsService = this.getService(WalletRewardSettingsService.class);
            defaultSettings = rewardSettingsService.getSettings();
            this.setContractDetails();
        }
        this.begin();
    }

    @After
    public void tearDown() throws Exception {
        super.tearDown();
        RewardDAO rewardDAO = this.getService(RewardDAO.class);
        RewardPeriodDAO rewardPeriodDAO = this.getService(RewardPeriodDAO.class);
        RewardPluginDAO rewardPluginDAO = this.getService(RewardPluginDAO.class);
        WalletAccountDAO walletAccountDAO = this.getService(WalletAccountDAO.class);
        AddressLabelDAO addressLabelDAO = this.getService(AddressLabelDAO.class);
        WalletPrivateKeyDAO walletPrivateKeyDAO = this.getService(WalletPrivateKeyDAO.class);
        WalletTransactionDAO walletTransactionDAO = this.getService(WalletTransactionDAO.class);
        RewardTeamDAO rewardTeamDAO = this.getService(RewardTeamDAO.class);
        WalletBlockchainStateDAO walletBlockchainStateDAO = this.getService(WalletBlockchainStateDAO.class);
        WalletRewardSettingsService rewardSettingsService = this.getService(WalletRewardSettingsService.class);
        RewardSettings storedSettings = rewardSettingsService.getSettings();
        BaseWalletRewardTest.assertEquals((Object)defaultSettings, (Object)storedSettings);
        this.restartTransaction();
        rewardPluginDAO.deleteAll();
        rewardDAO.deleteAll();
        rewardPeriodDAO.deleteAll();
        walletBlockchainStateDAO.deleteAll();
        if (!this.entitiesToClean.isEmpty()) {
            for (Serializable entity : this.entitiesToClean) {
                if (entity instanceof WalletEntity) {
                    walletAccountDAO.delete((Object)((WalletEntity)entity));
                    continue;
                }
                if (entity instanceof WalletPrivateKeyEntity) {
                    walletPrivateKeyDAO.delete((Object)((WalletPrivateKeyEntity)entity));
                    continue;
                }
                if (entity instanceof TransactionEntity) {
                    walletTransactionDAO.delete((Object)((TransactionEntity)entity));
                    continue;
                }
                if (entity instanceof AddressLabelEntity) {
                    addressLabelDAO.delete((Object)((AddressLabelEntity)entity));
                    continue;
                }
                if (entity instanceof WalletAddressLabel) {
                    AddressLabelEntity labelEntity = (AddressLabelEntity)addressLabelDAO.find((Serializable)Long.valueOf(((WalletAddressLabel)entity).getId()));
                    addressLabelDAO.delete((Object)labelEntity);
                    continue;
                }
                if (entity instanceof TransactionDetail) {
                    TransactionEntity transactionEntity = (TransactionEntity)walletTransactionDAO.find((Serializable)Long.valueOf(((TransactionDetail)entity).getId()));
                    walletTransactionDAO.delete((Object)transactionEntity);
                    continue;
                }
                if (entity instanceof Wallet) {
                    long walletId = ((Wallet)entity).getTechnicalId();
                    WalletEntity walletEntity = (WalletEntity)walletAccountDAO.find((Serializable)Long.valueOf(walletId));
                    walletAccountDAO.delete((Object)walletEntity);
                    WalletPrivateKeyEntity walletPrivateKey = (WalletPrivateKeyEntity)walletPrivateKeyDAO.find((Serializable)Long.valueOf(walletId));
                    if (walletPrivateKey == null) continue;
                    walletPrivateKeyDAO.delete((Object)walletPrivateKey);
                    continue;
                }
                if (entity instanceof RewardTeamEntity) {
                    rewardTeamDAO.delete((Object)((RewardTeamEntity)entity));
                    continue;
                }
                if (entity instanceof RewardTeam) {
                    RewardTeamEntity teamEntity = (RewardTeamEntity)rewardTeamDAO.find((Serializable)((RewardTeam)entity).getId());
                    rewardTeamDAO.delete((Object)teamEntity);
                    continue;
                }
                throw new IllegalStateException("Entity not managed" + entity);
            }
        }
        int walletCount = walletAccountDAO.findAll().size();
        int walletPrivateKeyCount = walletPrivateKeyDAO.findAll().size();
        int walletAddressLabelsCount = addressLabelDAO.findAll().size();
        int walletTransactionsCount = walletTransactionDAO.findAll().size();
        LOG.info("objects count wallets = {}, private keys = {}, address labels = {}, transactions count = {}", new Object[]{walletCount, walletPrivateKeyCount, walletAddressLabelsCount, walletTransactionsCount});
        BaseWalletRewardTest.assertEquals((String)"The previous test didn't cleaned wallets entities correctly, should add entities to clean into 'entitiesToClean' list.", (int)0, (int)walletCount);
        BaseWalletRewardTest.assertEquals((String)"The previous test didn't cleaned wallet addresses labels correctly, should add entities to clean into 'entitiesToClean' list.", (int)0, (int)walletAddressLabelsCount);
        BaseWalletRewardTest.assertEquals((String)"The previous test didn't cleaned wallets private keys entities correctly, should add entities to clean into 'entitiesToClean' list.", (int)0, (int)walletPrivateKeyCount);
        BaseWalletRewardTest.assertEquals((String)"The previous test didn't cleaned wallets transactions entities correctly, should add entities to clean into 'entitiesToClean' list.", (int)0, (int)walletTransactionsCount);
        this.end();
    }

    protected <T> T getService(Class<T> componentType) {
        return (T)this.container.getComponentInstanceOfType(componentType);
    }

    protected RewardTeam newRewardTeam() {
        long[] memberIdentityIds = new long[]{2L};
        return this.newRewardTeam(memberIdentityIds);
    }

    protected RewardTeam newRewardTeam(long[] memberIdentityIds) {
        RewardTeam rewardTeam = new RewardTeam();
        rewardTeam.setBudget(Double.valueOf(2.0));
        rewardTeam.setDescription(TEAM_DESCRIPTION);
        rewardTeam.setDisabled(false);
        RewardTeamMember manager = new RewardTeamMember();
        manager.setIdentityId(Long.valueOf(1L));
        rewardTeam.setManager(manager);
        ArrayList<RewardTeamMember> members = new ArrayList<RewardTeamMember>();
        for (long memberIdentityId : memberIdentityIds) {
            RewardTeamMember member = new RewardTeamMember();
            member.setIdentityId(Long.valueOf(memberIdentityId));
            members.add(member);
        }
        rewardTeam.setMembers(members);
        rewardTeam.setName(TEAM_NAME);
        rewardTeam.setRewardType(TEAM_BUDGET_TYPE);
        rewardTeam.setSpaceId(Long.valueOf(5L));
        return rewardTeam;
    }

    protected Wallet newWallet(long identityId) {
        Wallet wallet = new Wallet();
        wallet.setTechnicalId(identityId);
        wallet.setAddress(ADDRESS + identityId);
        wallet.setPassPhrase(PHRASE);
        wallet.setEnabled(true);
        wallet.setIsInitialized(Boolean.valueOf(true));
        wallet.setEtherBalance(Double.valueOf(0.0));
        wallet.setTokenBalance(Double.valueOf(0.0));
        wallet.setInitializationState(INITIALIZATION_STATE);
        return wallet;
    }

    protected void updateWalletBlockchainState(Wallet wallet) {
        wallet.setIsInitialized(Boolean.valueOf(true));
        wallet.setEtherBalance(Double.valueOf(0.0));
        wallet.setTokenBalance(Double.valueOf(0.0));
        wallet.setInitializationState(INITIALIZATION_STATE);
    }

    protected String generateTransactionHash() {
        StringBuilder hashStringBuffer = new StringBuilder("0x");
        for (int i = 0; i < 64; ++i) {
            hashStringBuffer.append(Integer.toHexString(this.random.nextInt(16)));
        }
        return hashStringBuffer.toString();
    }

    protected RewardSettings cloneSettings(RewardSettings defaultSettings) {
        RewardSettings newSettings = defaultSettings.clone();
        HashSet defaultPluginSettings = new HashSet(newSettings.getPluginSettings());
        HashSet<RewardPluginSettings> pluginSettings = new HashSet<RewardPluginSettings>();
        for (RewardPluginSettings rewardPluginSetting : defaultPluginSettings) {
            pluginSettings.add(rewardPluginSetting.clone());
        }
        newSettings.setPluginSettings(pluginSettings);
        return newSettings;
    }

    private void registerResourceBundleService() {
        ResourceBundleService resourceBundleService = (ResourceBundleService)Mockito.mock(ResourceBundleService.class);
        MapResourceBundle resourceBundle = new MapResourceBundle(Locale.getDefault());
        resourceBundle.add("exoplatform.wallet.label.rewardTransactionLabel", (Object)"{0} is rewarded {1} {2} for period: {3} to {4}");
        resourceBundle.add("exoplatform.wallet.label.rewardTransactionMessageWithPool", (Object)"You have earned {0} {1} in reward for your {2} {3} earned in pool {4} for period: {5} to {6}");
        resourceBundle.add("exoplatform.wallet.label.rewardTransactionMessageNoPool", (Object)"You have earned {0} {1} in reward for your {2} {3} for period: {4} to {5}");
        Mockito.when((Object)resourceBundleService.getResourceBundle(Mockito.anyString(), (Locale)Mockito.any())).thenReturn((Object)resourceBundle);
        if (this.container.getComponentInstanceOfType(ResourceBundleService.class) != null) {
            this.container.unregisterComponent(ResourceBundleService.class);
        }
        this.container.registerComponentInstance(ResourceBundleService.class, (Object)resourceBundleService);
    }

    private void setContractDetails() {
        WalletService walletService = this.getService(WalletService.class);
        ContractDetail contractDetail = new ContractDetail();
        contractDetail.setName(TEAM_NAME);
        contractDetail.setSymbol("symbol");
        contractDetail.setDecimals(Integer.valueOf(12));
        contractDetail.setAddress(WalletUtils.getContractAddress());
        contractDetail.setContractType("3");
        contractDetail.setNetworkId(Long.valueOf(1L));
        walletService.setConfiguredContractDetail(contractDetail);
    }
}

