/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.wallet.scheduled;

import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.addon.wallet.model.ContractDetail;
import org.exoplatform.addon.wallet.model.settings.GlobalSettings;
import org.exoplatform.addon.wallet.model.transaction.TransactionDetail;
import org.exoplatform.addon.wallet.service.EthereumClientConnector;
import org.exoplatform.addon.wallet.service.EthereumTransactionDecoder;
import org.exoplatform.addon.wallet.service.WalletTransactionService;
import org.exoplatform.addon.wallet.utils.WalletUtils;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.quartz.DisallowConcurrentExecution;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.web3j.protocol.core.methods.response.TransactionReceipt;

@DisallowConcurrentExecution
public class ContractTransactionVerifierJob
implements Job {
    private static final Log LOG = ExoLogger.getLogger(ContractTransactionVerifierJob.class);
    private ExoContainer container;
    private EthereumClientConnector ethereumClientConnector;
    private EthereumTransactionDecoder ethereumTransactionDecoder;
    private WalletTransactionService transactionService;
    private SettingService settingService;

    public ContractTransactionVerifierJob() {
        this((ExoContainer)PortalContainer.getInstance());
    }

    public ContractTransactionVerifierJob(ExoContainer container) {
        this.container = container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(JobExecutionContext context) throws JobExecutionException {
        ExoContainer currentContainer = ExoContainerContext.getCurrentContainer();
        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
        RequestLifeCycle.begin((ExoContainer)this.container);
        try {
            long lastWatchedBlockNumber;
            GlobalSettings settings = WalletUtils.getSettings();
            if (settings == null) {
                LOG.debug((Object)"Empty settings, skip contract transaction verification");
                return;
            }
            long networkId = settings.getNetwork().getId();
            if (settings.getNetwork().getId() == 0L) {
                LOG.debug((Object)"Empty network id in settings, skip contract transaction verification");
                return;
            }
            String wsURL = settings.getNetwork().getWebsocketProviderURL();
            if (StringUtils.isBlank((CharSequence)wsURL)) {
                LOG.debug((Object)"Empty Websocket URL in settings, skip contract transaction verification");
                return;
            }
            ContractDetail contractDetail = settings.getContractDetail();
            if (contractDetail == null || StringUtils.isBlank((CharSequence)contractDetail.getAddress())) {
                LOG.debug((Object)"Empty token address in settings, skip contract transaction verification");
                return;
            }
            long lastEthereumBlockNumber = this.getEthereumClientConnector().getLastestBlockNumber();
            if (lastEthereumBlockNumber <= (lastWatchedBlockNumber = this.getLastWatchedBlockNumber(networkId))) {
                LOG.debug("No new blocks to verify. last watched = {}. last blockchain block = {}", new Object[]{lastWatchedBlockNumber, lastEthereumBlockNumber});
                return;
            }
            boolean processed = true;
            String contractAddress = contractDetail.getAddress();
            Set<String> transactionHashes = this.getEthereumClientConnector().getContractTransactions(contractAddress, lastWatchedBlockNumber, lastEthereumBlockNumber);
            LOG.debug("{} transactions has been found on contract {} between block {} and {}", new Object[]{transactionHashes.size(), contractAddress, lastWatchedBlockNumber, lastEthereumBlockNumber});
            int addedTransactionsCount = 0;
            int modifiedTransactionsCount = 0;
            for (String transactionHash : transactionHashes) {
                TransactionDetail transactionDetail = this.getTransactionService().getTransactionByHash(transactionHash);
                if (transactionDetail == null) {
                    processed = this.processTransaction(networkId, transactionHash, contractDetail) && processed;
                    if (!processed) continue;
                    ++addedTransactionsCount;
                    continue;
                }
                LOG.debug(" - transaction {} already exists on database, ignore it.", new Object[]{transactionDetail});
                boolean changed = false;
                if (StringUtils.isBlank((CharSequence)transactionDetail.getContractAddress()) || StringUtils.isBlank((CharSequence)transactionDetail.getContractMethodName())) {
                    transactionDetail.setContractAddress(contractAddress);
                    this.getEthereumTransactionDecoder().computeTransactionDetail(transactionDetail, contractDetail);
                    changed = true;
                }
                boolean braodcastSavingTransaction = transactionDetail.isPending();
                transactionDetail.setPending(false);
                boolean bl = changed = changed || braodcastSavingTransaction;
                if (!transactionDetail.isSucceeded()) {
                    TransactionReceipt transactionReceipt = this.ethereumClientConnector.getTransactionReceipt(transactionHash);
                    transactionDetail.setSucceeded(transactionReceipt != null && transactionReceipt.isStatusOK());
                    changed = true;
                }
                if (!changed || !WalletUtils.hasKnownWalletInTransaction((TransactionDetail)transactionDetail)) continue;
                this.getTransactionService().saveTransactionDetail(transactionDetail, braodcastSavingTransaction);
                ++modifiedTransactionsCount;
            }
            LOG.debug("{} added and {} modified transactions has been stored using contract {} between block {} and {}", new Object[]{addedTransactionsCount, modifiedTransactionsCount, contractAddress, lastWatchedBlockNumber, lastEthereumBlockNumber});
            if (processed) {
                this.saveLastWatchedBlockNumber(networkId, lastEthereumBlockNumber);
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Error while checking pending transactions", (Throwable)e);
        }
        finally {
            RequestLifeCycle.end();
            ExoContainerContext.setCurrentContainer((ExoContainer)currentContainer);
        }
    }

    private boolean processTransaction(Long networkId, String transactionHash, ContractDetail contractDetail) {
        boolean processed = true;
        try {
            LOG.debug(" - treating transaction {} that doesn't exist on database.", new Object[]{transactionHash});
            TransactionDetail transactionDetail = this.getEthereumTransactionDecoder().computeTransactionDetail(networkId, transactionHash, contractDetail);
            if (transactionDetail == null) {
                throw new IllegalStateException("Empty transaction detail is returned");
            }
            if (WalletUtils.hasKnownWalletInTransaction((TransactionDetail)transactionDetail)) {
                LOG.info("Saving new transaction that wasn't managed by UI: {}", new Object[]{transactionDetail});
                this.getTransactionService().saveTransactionDetail(transactionDetail, true);
            }
        }
        catch (Exception e) {
            processed = false;
            LOG.warn("Error processing transaction {}. It will be retried next time.", new Object[]{transactionHash, e});
        }
        return processed;
    }

    private long getLastWatchedBlockNumber(long networkId) {
        SettingValue lastBlockNumberValue = this.getSettingService().get(WalletUtils.WALLET_CONTEXT, WalletUtils.WALLET_SCOPE, "ADDONS_ETHEREUM_LAST_BLOCK_NUMBER" + networkId);
        if (lastBlockNumberValue != null && lastBlockNumberValue.getValue() != null) {
            return Long.valueOf(lastBlockNumberValue.getValue().toString());
        }
        return 0L;
    }

    private void saveLastWatchedBlockNumber(long networkId, long lastWatchedBlockNumber) {
        LOG.debug("Save watched block number {} on network {}", new Object[]{lastWatchedBlockNumber, networkId});
        this.getSettingService().set(WalletUtils.WALLET_CONTEXT, WalletUtils.WALLET_SCOPE, "ADDONS_ETHEREUM_LAST_BLOCK_NUMBER" + networkId, SettingValue.create((Long)lastWatchedBlockNumber));
    }

    private WalletTransactionService getTransactionService() {
        if (this.transactionService == null) {
            this.transactionService = (WalletTransactionService)CommonsUtils.getService(WalletTransactionService.class);
        }
        return this.transactionService;
    }

    private EthereumTransactionDecoder getEthereumTransactionDecoder() {
        if (this.ethereumTransactionDecoder == null) {
            this.ethereumTransactionDecoder = (EthereumTransactionDecoder)CommonsUtils.getService(EthereumTransactionDecoder.class);
        }
        return this.ethereumTransactionDecoder;
    }

    private EthereumClientConnector getEthereumClientConnector() {
        if (this.ethereumClientConnector == null) {
            this.ethereumClientConnector = (EthereumClientConnector)CommonsUtils.getService(EthereumClientConnector.class);
        }
        return this.ethereumClientConnector;
    }

    private SettingService getSettingService() {
        if (this.settingService == null) {
            this.settingService = (SettingService)CommonsUtils.getService(SettingService.class);
        }
        return this.settingService;
    }
}

