/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.wallet.storage;

import java.math.BigInteger;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.addon.wallet.dao.WalletTransactionDAO;
import org.exoplatform.addon.wallet.entity.TransactionEntity;
import org.exoplatform.addon.wallet.model.transaction.TransactionDetail;
import org.exoplatform.addon.wallet.utils.WalletUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class TransactionStorage {
    private static final Log LOG = ExoLogger.getLogger(TransactionStorage.class);
    private static final long MINIMUM_CREATED_DATE_MILLIS = LocalDate.of(2018, 1, 1).atStartOfDay(ZoneOffset.systemDefault()).toEpochSecond() * 1000L;
    private WalletTransactionDAO walletTransactionDAO;

    public TransactionStorage(WalletTransactionDAO walletTransactionDAO) {
        this.walletTransactionDAO = walletTransactionDAO;
    }

    public List<TransactionDetail> getPendingTransactions(long networkId) {
        List<TransactionEntity> transactions = this.walletTransactionDAO.getPendingTransactions(networkId);
        return transactions == null ? Collections.emptyList() : transactions.stream().map(this::fromEntity).collect(Collectors.toList());
    }

    public List<TransactionDetail> getContractTransactions(String contractAddress, String contractMethodName, int limit) {
        List<TransactionEntity> transactions = this.walletTransactionDAO.getContractTransactions(StringUtils.lowerCase((String)contractAddress), contractMethodName, limit);
        return transactions == null ? Collections.emptyList() : transactions.stream().map(this::fromEntity).collect(Collectors.toList());
    }

    public List<TransactionDetail> getWalletTransactions(long networkId, String address, String contractAddress, String contractMethodName, String hash, int limit, boolean pending, boolean administration) {
        boolean limitNotReached;
        List<TransactionEntity> transactions = this.walletTransactionDAO.getWalletTransactions(networkId, address = StringUtils.lowerCase((String)address), contractAddress, contractMethodName, limit, pending, administration);
        boolean bl = limitNotReached = transactions != null && transactions.size() == limit;
        if (StringUtils.isNotBlank((CharSequence)hash) && limitNotReached && transactions.stream().noneMatch(transaction -> StringUtils.equalsIgnoreCase((CharSequence)transaction.getHash(), (CharSequence)hash))) {
            return this.getWalletTransactions(networkId, address, contractAddress, contractMethodName, hash, limit * 2, pending, administration);
        }
        return transactions == null ? Collections.emptyList() : transactions.stream().map(this::fromEntity).collect(Collectors.toList());
    }

    public void saveTransactionDetail(TransactionDetail transactionDetail) {
        TransactionEntity transactionEntity = this.toEntity(transactionDetail);
        if (transactionEntity.getId() == 0L) {
            transactionEntity = (TransactionEntity)this.walletTransactionDAO.create(transactionEntity);
            transactionDetail.setId(transactionEntity.getId());
        } else {
            this.walletTransactionDAO.update(transactionEntity);
        }
    }

    public TransactionDetail getAddressLastPendingTransactionSent(long networkId, String address) {
        TransactionEntity transactionEntity = this.walletTransactionDAO.getAddressLastPendingTransactionSent(networkId, address);
        return this.fromEntity(transactionEntity);
    }

    public TransactionDetail getTransactionByHash(String hash) {
        hash = WalletUtils.formatTransactionHash((String)hash);
        TransactionEntity transactionEntity = this.walletTransactionDAO.getTransactionByHash(hash);
        return this.fromEntity(transactionEntity);
    }

    public double countReceivedContractAmount(String contractAddress, String address, ZonedDateTime startDate, ZonedDateTime endDate) {
        return this.walletTransactionDAO.countReceivedContractAmount(contractAddress, address, startDate, endDate);
    }

    public double countSentContractAmount(String contractAddress, String address, ZonedDateTime startDate, ZonedDateTime endDate) {
        return this.walletTransactionDAO.countSentContractAmount(contractAddress, address, startDate, endDate);
    }

    private TransactionDetail fromEntity(TransactionEntity entity) {
        if (entity == null) {
            return null;
        }
        TransactionDetail detail = new TransactionDetail();
        detail.setId(entity.getId());
        detail.setAdminOperation(entity.isAdminOperation());
        detail.setContractAddress(entity.getContractAddress());
        detail.setContractAmount(entity.getContractAmount());
        detail.setContractMethodName(entity.getContractMethodName());
        if (entity.getCreatedDate() > 0L && entity.getCreatedDate() < MINIMUM_CREATED_DATE_MILLIS) {
            LOG.debug("Transaction {} has a 'CreatedDate' in seconds, converting it to milliseconds.", new Object[]{entity.getHash()});
            entity.setCreatedDate(entity.getCreatedDate() * 1000L);
            this.walletTransactionDAO.update(entity);
        }
        if (entity.getValue() > 10000.0 && (StringUtils.isBlank((CharSequence)entity.getContractAddress()) || StringUtils.isBlank((CharSequence)entity.getContractMethodName()) || StringUtils.equals((CharSequence)entity.getContractMethodName(), (CharSequence)"initializeAccount") || StringUtils.equals((CharSequence)entity.getContractMethodName(), (CharSequence)"setSellPrice"))) {
            LOG.debug("[from DB] Transaction {} has a value in WEI, converting it to ether.", new Object[]{entity.getHash()});
            entity.setValue(WalletUtils.convertFromDecimals((BigInteger)new BigInteger(String.valueOf(entity.getValue())), (int)18));
            this.walletTransactionDAO.update(entity);
        }
        detail.setTimestamp(entity.getCreatedDate());
        detail.setValue(entity.getValue());
        detail.setIssuerId(entity.getIssuerIdentityId());
        detail.setHash(entity.getHash());
        detail.setFrom(entity.getFromAddress());
        detail.setTo(entity.getToAddress());
        detail.setBy(entity.getByAddress());
        detail.setLabel(entity.getLabel());
        detail.setMessage(entity.getMessage());
        detail.setNetworkId(entity.getNetworkId());
        detail.setPending(entity.isPending());
        detail.setSucceeded(entity.isSuccess());
        return detail;
    }

    private TransactionEntity toEntity(TransactionDetail detail) {
        TransactionEntity entity = new TransactionEntity();
        if (detail.getId() > 0L) {
            entity.setId(detail.getId());
        }
        entity.setNetworkId(detail.getNetworkId());
        entity.setHash(WalletUtils.formatTransactionHash((String)detail.getHash()));
        entity.setFromAddress(StringUtils.lowerCase((String)detail.getFrom()));
        entity.setToAddress(StringUtils.lowerCase((String)detail.getTo()));
        entity.setByAddress(StringUtils.lowerCase((String)detail.getBy()));
        entity.setContractAddress(StringUtils.lowerCase((String)detail.getContractAddress()));
        entity.setContractAmount(detail.getContractAmount());
        entity.setContractMethodName(detail.getContractMethodName());
        entity.setAdminOperation(detail.isAdminOperation());
        entity.setLabel(detail.getLabel());
        entity.setMessage(detail.getMessage());
        entity.setPending(detail.isPending());
        entity.setSuccess(detail.isSucceeded());
        entity.setValue(detail.getValue());
        if (detail.getTimestamp() == 0L) {
            entity.setCreatedDate(System.currentTimeMillis());
        } else if (detail.getTimestamp() < MINIMUM_CREATED_DATE_MILLIS) {
            LOG.debug("[to store on DB] Transaction {} has a 'CreatedDate' in seconds, converting it to milliseconds.", new Object[]{entity.getHash()});
            detail.setTimestamp(entity.getCreatedDate() * 1000L);
        }
        entity.setCreatedDate(detail.getTimestamp());
        if (detail.getIssuer() != null) {
            entity.setIssuerIdentityId(detail.getIssuer().getTechnicalId());
        } else if (detail.getIssuerId() > 0L) {
            entity.setIssuerIdentityId(detail.getIssuerId());
        }
        return entity;
    }
}

