/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.wallet.listener;

import org.apache.commons.lang3.StringUtils;
import org.exoplatform.addon.wallet.model.Wallet;
import org.exoplatform.addon.wallet.model.WalletInitializationState;
import org.exoplatform.addon.wallet.service.WalletAccountService;
import org.exoplatform.addon.wallet.service.WalletTokenAdminService;
import org.exoplatform.addon.wallet.utils.WalletUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;

@Asynchronous
public class ModifiedWalletListener
extends Listener<Wallet, Wallet> {
    private WalletAccountService walletAccountService;
    private WalletTokenAdminService tokenTransactionService;
    private ExoContainer container;

    public ModifiedWalletListener(PortalContainer container) {
        this.container = container;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(Event<Wallet, Wallet> event) throws Exception {
        ExoContainerContext.setCurrentContainer((ExoContainer)this.container);
        RequestLifeCycle.begin((ExoContainer)this.container);
        try {
            boolean initializedWallet;
            String contractAddress = WalletUtils.getContractAddress();
            if (StringUtils.isBlank((CharSequence)contractAddress)) {
                return;
            }
            Wallet wallet = (Wallet)event.getData();
            Wallet oldWallet = (Wallet)event.getSource();
            if (oldWallet == null || wallet == null || StringUtils.isBlank((CharSequence)wallet.getAddress()) || StringUtils.isBlank((CharSequence)oldWallet.getAddress()) || StringUtils.equalsIgnoreCase((CharSequence)wallet.getAddress(), (CharSequence)oldWallet.getAddress())) {
                return;
            }
            String walletAddress = wallet.getAddress();
            boolean bl = initializedWallet = this.getTokenTransactionService().isInitializedAccount(walletAddress) || this.getTokenTransactionService().isApprovedAccount(walletAddress);
            if (initializedWallet) {
                wallet.setInitializationState(WalletInitializationState.INITIALIZED.name());
            } else {
                wallet.setInitializationState(WalletInitializationState.MODIFIED.name());
            }
            this.getWalletAccountService().saveWallet(wallet);
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    private WalletAccountService getWalletAccountService() {
        if (this.walletAccountService == null) {
            this.walletAccountService = (WalletAccountService)CommonsUtils.getService(WalletAccountService.class);
        }
        return this.walletAccountService;
    }

    private WalletTokenAdminService getTokenTransactionService() {
        if (this.tokenTransactionService == null) {
            this.tokenTransactionService = (WalletTokenAdminService)CommonsUtils.getService(WalletTokenAdminService.class);
        }
        return this.tokenTransactionService;
    }
}

