/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.wallet.service;

import java.time.LocalDate;
import java.time.Month;
import java.time.MonthDay;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.TextStyle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.addon.wallet.model.ContractDetail;
import org.exoplatform.addon.wallet.model.Wallet;
import org.exoplatform.addon.wallet.model.WalletType;
import org.exoplatform.addon.wallet.model.transaction.TransactionDetail;
import org.exoplatform.addon.wallet.model.transaction.TransactionStatistics;
import org.exoplatform.addon.wallet.service.WalletAccountService;
import org.exoplatform.addon.wallet.service.WalletContractService;
import org.exoplatform.addon.wallet.service.WalletTransactionService;
import org.exoplatform.addon.wallet.storage.TransactionStorage;
import org.exoplatform.addon.wallet.utils.WalletUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

public class WalletTransactionServiceImpl
implements WalletTransactionService {
    private static final Log LOG = ExoLogger.getLogger(WalletTransactionServiceImpl.class);
    private static final String YEAR_PERIODICITY = "year";
    private static final String MONTH_PERIODICITY = "month";
    private WalletAccountService accountService;
    private WalletContractService contractService;
    private TransactionStorage transactionStorage;
    private SpaceService spaceService;
    private ListenerService listenerService;
    private long pendingTransactionMaxDays;

    public WalletTransactionServiceImpl(WalletAccountService accountService, TransactionStorage transactionStorage, WalletContractService contractService, InitParams params) {
        this.transactionStorage = transactionStorage;
        this.accountService = accountService;
        this.contractService = contractService;
        if (params != null && params.containsKey((Object)"transaction.pending.maxDays")) {
            String value = params.getValueParam("transaction.pending.maxDays").getValue();
            this.pendingTransactionMaxDays = Long.parseLong(value);
        }
    }

    public Set<String> getPendingTransactionHashes() {
        return this.transactionStorage.getPendingTransactionHashes(WalletUtils.getNetworkId());
    }

    public List<TransactionDetail> getTransactions(String address, String contractAddress, String contractMethodName, String hash, int limit, boolean onlyPending, boolean administration, String currentUser) throws IllegalAccessException {
        if (this.contractService.isContract(address)) {
            return this.getContractTransactions(address, contractMethodName, limit, currentUser);
        }
        return this.getWalletTransactions(address, contractAddress, contractMethodName, hash, limit, onlyPending, administration, currentUser);
    }

    public TransactionStatistics getTransactionStatistics(String address, String periodicity, Locale locale) {
        Locale userLocale;
        if (StringUtils.isBlank((String)address)) {
            throw new IllegalArgumentException("Wallet address is mandatory");
        }
        if (StringUtils.isBlank((String)periodicity)) {
            throw new IllegalArgumentException("Periodicity is mandatory");
        }
        TransactionStatistics transactionStatistics = new TransactionStatistics();
        List periodList = null;
        Locale locale2 = userLocale = locale == null ? Locale.getDefault() : locale;
        if (StringUtils.equalsIgnoreCase((String)periodicity, (String)YEAR_PERIODICITY)) {
            ArrayList<YearMonth> monthsList = new ArrayList<YearMonth>();
            for (long i = 11L; i >= 1L; --i) {
                monthsList.add(YearMonth.now().minusMonths(i));
            }
            monthsList.add(YearMonth.now());
            transactionStatistics.setPeriodicityLabel(String.valueOf(Year.now().getValue()));
            transactionStatistics.setLabels(monthsList.stream().map(month -> StringUtils.capitalize((String)month.getMonth().getDisplayName(TextStyle.FULL, userLocale))).collect(Collectors.toList()));
            periodList = monthsList.stream().map(yearMonth -> yearMonth.atDay(1)).collect(Collectors.toList());
        } else if (StringUtils.equalsIgnoreCase((String)periodicity, (String)MONTH_PERIODICITY)) {
            Month currentMonth = MonthDay.now().getMonth();
            int maxDayOfMonth = currentMonth.maxLength();
            List dayList = IntStream.rangeClosed(1, maxDayOfMonth).boxed().collect(Collectors.toList());
            String monthLabel = StringUtils.capitalize((String)currentMonth.getDisplayName(TextStyle.FULL, userLocale));
            transactionStatistics.setPeriodicityLabel(monthLabel);
            transactionStatistics.setLabels(dayList.stream().map(day -> String.format("%02d", day)).collect(Collectors.toList()));
            periodList = dayList.stream().map(dayOfMonth -> YearMonth.now().atDay((int)dayOfMonth)).collect(Collectors.toList());
        } else {
            throw new IllegalArgumentException("Uknown periodicity parameter: " + periodicity);
        }
        for (LocalDate startDate : periodList) {
            ZonedDateTime startDateTime = startDate.atStartOfDay(ZoneOffset.systemDefault());
            ZonedDateTime endDateTime = this.getEndDate(startDate, periodicity);
            String contractAddress = WalletUtils.getContractAddress();
            double receivedContractAmount = this.transactionStorage.countReceivedContractAmount(contractAddress, address, startDateTime, endDateTime);
            transactionStatistics.getIncome().add(String.valueOf(receivedContractAmount));
            double sentContractAmount = this.transactionStorage.countSentContractAmount(contractAddress, address, startDateTime, endDateTime);
            transactionStatistics.getOutcome().add(String.valueOf(sentContractAmount));
        }
        return transactionStatistics;
    }

    public TransactionDetail getTransactionByHash(String hash, String currentUser) {
        TransactionDetail transactionDetail = this.transactionStorage.getTransactionByHash(hash);
        if (transactionDetail != null) {
            this.retrieveWalletsDetails(transactionDetail, currentUser);
        }
        return transactionDetail;
    }

    public TransactionDetail getTransactionByHash(String hash) {
        TransactionDetail transactionDetail = this.transactionStorage.getTransactionByHash(hash);
        if (transactionDetail != null) {
            this.retrieveWalletsDetails(transactionDetail);
        }
        return transactionDetail;
    }

    public void saveTransactionDetail(TransactionDetail transactionDetail, boolean broadcastMinedTransaction) {
        this.transactionStorage.saveTransactionDetail(transactionDetail);
        if (broadcastMinedTransaction) {
            this.broadcastTransactionMinedEvent(transactionDetail);
        }
    }

    public void saveTransactionDetail(TransactionDetail transactionDetail, String currentUser, boolean broadcastMinedTransaction) throws IllegalAccessException {
        String senderAddress;
        Wallet senderWallet;
        if (StringUtils.isBlank((String)currentUser)) {
            throw new IllegalArgumentException("username is mandatory");
        }
        if (!(broadcastMinedTransaction || (senderWallet = this.accountService.getWalletByAddress(senderAddress = StringUtils.isBlank((String)transactionDetail.getBy()) ? transactionDetail.getFrom() : transactionDetail.getBy())) != null && this.accountService.isWalletOwner(senderWallet, currentUser))) {
            throw new IllegalAccessException("User '" + currentUser + "' is attempting to save a new transaction for another wallet");
        }
        Wallet issuerWallet = this.accountService.getWalletByTypeAndId(WalletType.USER.getId(), currentUser);
        transactionDetail.setIssuer(issuerWallet);
        this.transactionStorage.saveTransactionDetail(transactionDetail);
        this.retrieveWalletsDetails(transactionDetail);
        if (broadcastMinedTransaction) {
            this.broadcastTransactionMinedEvent(transactionDetail);
        }
    }

    public long getPendingTransactionMaxDays() {
        return this.pendingTransactionMaxDays;
    }

    private List<TransactionDetail> getContractTransactions(String contractAddress, String contractMethodName, int limit, String currentUser) throws IllegalAccessException {
        ContractDetail contractDetail = this.contractService.getContractDetail(contractAddress);
        if (contractDetail == null) {
            throw new IllegalStateException("Can't find contract with address " + contractAddress);
        }
        if (!WalletUtils.isUserRewardingAdmin((String)currentUser)) {
            throw new IllegalAccessException("User " + currentUser + " attempts to access contract transactions with address " + contractAddress);
        }
        List<TransactionDetail> transactionDetails = this.transactionStorage.getContractTransactions(contractAddress, contractMethodName, limit);
        transactionDetails.stream().forEach(transactionDetail -> this.retrieveWalletsDetails((TransactionDetail)transactionDetail, currentUser));
        return transactionDetails;
    }

    private List<TransactionDetail> getWalletTransactions(String address, String contractAddress, String contractMethodName, String hash, int limit, boolean pending, boolean administration, String currentUser) throws IllegalAccessException {
        Wallet wallet = this.accountService.getWalletByAddress(address);
        if (wallet == null) {
            return Collections.emptyList();
        }
        if (!WalletUtils.canAccessWallet((Wallet)wallet, (String)currentUser)) {
            throw new IllegalAccessException("Can't access wallet with address " + address);
        }
        List<TransactionDetail> transactionDetails = this.transactionStorage.getWalletTransactions(WalletUtils.getNetworkId(), address, contractAddress, contractMethodName, hash, limit, pending, administration);
        transactionDetails.stream().forEach(transactionDetail -> this.retrieveWalletsDetails((TransactionDetail)transactionDetail, currentUser));
        return transactionDetails;
    }

    private void retrieveWalletsDetails(TransactionDetail transactionDetail) {
        if (transactionDetail == null || StringUtils.isBlank((String)transactionDetail.getFrom())) {
            return;
        }
        if (transactionDetail.getFromWallet() == null) {
            Wallet senderWallet = this.accountService.getWalletByAddress(transactionDetail.getFrom());
            transactionDetail.setFromWallet(senderWallet);
            WalletUtils.hideWalletOwnerPrivateInformation((Wallet)senderWallet);
        }
        if (transactionDetail.getToWallet() == null && StringUtils.isNotBlank((String)transactionDetail.getTo())) {
            Wallet receiverWallet = this.accountService.getWalletByAddress(transactionDetail.getTo());
            WalletUtils.hideWalletOwnerPrivateInformation((Wallet)receiverWallet);
            transactionDetail.setToWallet(receiverWallet);
        }
        if (transactionDetail.getByWallet() == null && StringUtils.isNotBlank((String)transactionDetail.getBy())) {
            Wallet senderWalletBy = this.accountService.getWalletByAddress(transactionDetail.getBy());
            WalletUtils.hideWalletOwnerPrivateInformation((Wallet)senderWalletBy);
            transactionDetail.setByWallet(senderWalletBy);
        }
        if (transactionDetail.getIssuer() == null && transactionDetail.getIssuerId() > 0L) {
            Wallet issuerWallet = this.accountService.getWalletByIdentityId(transactionDetail.getIssuerId());
            transactionDetail.setIssuer(issuerWallet);
        }
    }

    private void retrieveWalletsDetails(TransactionDetail transactionDetail, String currentUser) {
        if (transactionDetail == null || StringUtils.isBlank((String)transactionDetail.getFrom())) {
            return;
        }
        this.retrieveWalletsDetails(transactionDetail);
        if (StringUtils.isNotBlank((String)transactionDetail.getBy())) {
            if (!this.displayTransactionsLabel(transactionDetail.getByWallet(), currentUser)) {
                transactionDetail.setLabel(null);
            }
        } else if (!this.displayTransactionsLabel(transactionDetail.getFromWallet(), currentUser)) {
            transactionDetail.setLabel(null);
        }
    }

    private boolean displayTransactionsLabel(Wallet senderWallet, String currentUserId) {
        if (senderWallet == null || WalletUtils.isAdminAccount((String)senderWallet.getAddress())) {
            return WalletUtils.isUserRewardingAdmin((String)currentUserId);
        }
        String accountId = senderWallet.getId();
        String accountType = senderWallet.getType();
        if (StringUtils.isBlank((String)accountId) || StringUtils.isBlank((String)accountType)) {
            return WalletUtils.isUserRewardingAdmin((String)currentUserId);
        }
        if (WalletType.isSpace((String)senderWallet.getType())) {
            if (this.getSpaceService().isSuperManager(currentUserId)) {
                return true;
            }
            Space space = WalletUtils.getSpace((String)accountId);
            return space != null && this.getSpaceService().isManager(space, currentUserId);
        }
        return StringUtils.equalsIgnoreCase((String)accountId, (String)currentUserId);
    }

    private void broadcastTransactionMinedEvent(TransactionDetail transactionDetail) {
        try {
            HashMap<String, Object> transaction = new HashMap<String, Object>();
            transaction.put("hash", transactionDetail.getHash());
            transaction.put("from", transactionDetail.getFromWallet() == null ? 0L : transactionDetail.getFromWallet().getTechnicalId());
            transaction.put("to", transactionDetail.getToWallet() == null ? 0L : transactionDetail.getToWallet().getTechnicalId());
            transaction.put("contractAddress", transactionDetail.getContractAddress());
            transaction.put("contractAmount", transactionDetail.getContractAmount());
            transaction.put("contractMethodName", transactionDetail.getContractMethodName());
            transaction.put("etherAmount", transactionDetail.getValue());
            transaction.put("status", transactionDetail.isSucceeded());
            transaction.put("issuerId", transactionDetail.getIssuerId());
            this.getListenerService().broadcast("exo.addon.wallet.transaction.mined", null, transaction);
        }
        catch (Exception e) {
            LOG.warn("Error while broadcasting transaction mined event: {}", new Object[]{transactionDetail, e});
        }
    }

    private SpaceService getSpaceService() {
        if (this.spaceService == null) {
            this.spaceService = (SpaceService)CommonsUtils.getService(SpaceService.class);
        }
        return this.spaceService;
    }

    private ListenerService getListenerService() {
        if (this.listenerService == null) {
            this.listenerService = (ListenerService)CommonsUtils.getService(ListenerService.class);
        }
        return this.listenerService;
    }

    private ZonedDateTime getEndDate(LocalDate selectedDay, String periodicity) {
        return StringUtils.equalsIgnoreCase((String)periodicity, (String)YEAR_PERIODICITY) ? YearMonth.of(selectedDay.getYear(), selectedDay.getMonthValue()).atEndOfMonth().plusDays(1L).atStartOfDay(ZoneOffset.systemDefault()) : selectedDay.plusDays(1L).atStartOfDay(ZoneOffset.systemDefault());
    }
}

