/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.addon.wallet.storage.cached;

import java.io.Serializable;
import org.exoplatform.addon.wallet.dao.WalletTransactionDAO;
import org.exoplatform.addon.wallet.model.transaction.TransactionDetail;
import org.exoplatform.addon.wallet.storage.TransactionStorage;
import org.exoplatform.commons.cache.future.FutureExoCache;
import org.exoplatform.commons.cache.future.Loader;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;

public class CachedTransactionStorage
extends TransactionStorage {
    private FutureExoCache<String, TransactionDetail, Object> transactionFutureCache = null;

    public CachedTransactionStorage(CacheService cacheService, WalletTransactionDAO walletTransactionDAO) {
        super(walletTransactionDAO);
        ExoCache transactionCache = cacheService.getCacheInstance("wallet.transaction");
        this.transactionFutureCache = new FutureExoCache((Loader)new Loader<String, TransactionDetail, Object>(){

            public TransactionDetail retrieve(Object context, String hash) throws Exception {
                return CachedTransactionStorage.super.getTransactionByHash(hash);
            }
        }, transactionCache);
    }

    @Override
    public TransactionDetail getTransactionByHash(String hash) {
        TransactionDetail transactionDetail = (TransactionDetail)this.transactionFutureCache.get(null, (Object)hash.toLowerCase());
        return transactionDetail == null ? null : transactionDetail.clone();
    }

    @Override
    public void saveTransactionDetail(TransactionDetail transactionDetail) {
        super.saveTransactionDetail(transactionDetail);
        this.transactionFutureCache.remove((Serializable)((Object)transactionDetail.getHash().toLowerCase()));
    }

    public void clearCache() {
        this.transactionFutureCache.clear();
    }
}

