/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wallet.storage;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.exoplatform.wallet.dao.AddressLabelDAO;
import org.exoplatform.wallet.entity.AddressLabelEntity;
import org.exoplatform.wallet.model.WalletAddressLabel;

public class AddressLabelStorage {
    private AddressLabelDAO addressLabelDAO;
    private Set<WalletAddressLabel> allLabels;

    public AddressLabelStorage(AddressLabelDAO addressLabelDAO) {
        this.addressLabelDAO = addressLabelDAO;
    }

    public Set<WalletAddressLabel> getAllLabels() {
        if (this.allLabels != null) {
            return this.allLabels;
        }
        List allLabelsEntities = this.addressLabelDAO.findAll();
        if (allLabelsEntities == null || allLabelsEntities.isEmpty()) {
            return Collections.emptySet();
        }
        this.allLabels = Collections.unmodifiableSet(allLabelsEntities.stream().map(this::fromEntity).collect(Collectors.toSet()));
        return this.allLabels;
    }

    public WalletAddressLabel saveLabel(WalletAddressLabel label) {
        if (label == null) {
            throw new IllegalArgumentException("label is mandatory");
        }
        AddressLabelEntity entity = this.toEntity(label);
        entity = entity.getId() == null ? (AddressLabelEntity)this.addressLabelDAO.create(entity) : (AddressLabelEntity)this.addressLabelDAO.update(entity);
        this.clearCache();
        return this.fromEntity(entity);
    }

    public WalletAddressLabel getLabel(long id) {
        return this.fromEntity((AddressLabelEntity)this.addressLabelDAO.find(Long.valueOf(id)));
    }

    public void removeLabel(WalletAddressLabel label) {
        if (label.getId() > 0L) {
            this.addressLabelDAO.delete(this.toEntity(label));
        }
        this.clearCache();
    }

    public void clearCache() {
        this.allLabels = null;
    }

    private AddressLabelEntity toEntity(WalletAddressLabel label) {
        AddressLabelEntity entity = new AddressLabelEntity();
        entity.setId(label.getId() == 0L ? null : Long.valueOf(label.getId()));
        entity.setIdentityId(label.getIdentityId());
        entity.setAddress(label.getAddress());
        entity.setLabel(label.getLabel());
        return entity;
    }

    private WalletAddressLabel fromEntity(AddressLabelEntity entity) {
        if (entity == null) {
            return null;
        }
        return new WalletAddressLabel(entity.getId().longValue(), entity.getIdentityId().longValue(), entity.getLabel(), entity.getAddress());
    }
}

