/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wallet.listener;

import org.apache.commons.lang.StringUtils;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.listener.Asynchronous;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.wallet.model.Wallet;
import org.exoplatform.wallet.model.settings.InitialFundsSettings;
import org.exoplatform.wallet.model.transaction.TransactionDetail;
import org.exoplatform.wallet.service.WalletAccountService;
import org.exoplatform.wallet.service.WalletService;
import org.exoplatform.wallet.service.WalletTokenAdminService;

@Asynchronous
public class AutoTransactionListener
extends Listener<Object, String> {
    private static final Log LOG = ExoLogger.getLogger(AutoTransactionListener.class);
    private WalletAccountService walletAccountService;
    private WalletTokenAdminService walletTokenAdminService;
    private WalletService walletService;
    private static final String BAD_REQUEST_SENT_TO_SERVER_BY = "Bad request sent to server by '";
    private static final String WALLET_TYPE = "user";

    public void onEvent(Event<Object, String> event) throws Exception {
        Wallet wallet = (Wallet)event.getSource();
        InitialFundsSettings initialFundsSettings = this.getWalletService().getInitialFundsSettings();
        double tokenAmount = initialFundsSettings.getTokenAmount();
        double etherAmount = initialFundsSettings.getEtherAmount();
        String transactionLabel = initialFundsSettings.getRequestMessage();
        String transactionMessage = initialFundsSettings.getRequestMessage();
        if (tokenAmount == 0.0 || etherAmount == 0.0 || !WALLET_TYPE.equals(wallet.getType())) {
            return;
        }
        if (StringUtils.isBlank((String)wallet.getAddress())) {
            LOG.warn((Object)(BAD_REQUEST_SENT_TO_SERVER_BY + wallet.getId() + "' with empty address"));
            return;
        }
        try {
            TransactionDetail transactionDetail = new TransactionDetail();
            transactionDetail.setTo(wallet.getAddress());
            transactionDetail.setContractAmount(tokenAmount);
            transactionDetail.setValue(etherAmount);
            transactionDetail.setLabel(transactionLabel);
            transactionDetail.setMessage(transactionMessage);
            transactionDetail = this.getWalletTokenAdminService().initialize(transactionDetail, wallet.getId());
            LOG.info("wallet {} is initialized, the  transaction hash is {}", new Object[]{wallet.getId(), transactionDetail.getHash()});
        }
        catch (Exception e) {
            LOG.error("Error initializing wallet {}", new Object[]{wallet.getId(), e});
        }
    }

    private WalletAccountService getWalletAccountService() {
        if (this.walletAccountService == null) {
            this.walletAccountService = (WalletAccountService)CommonsUtils.getService(WalletAccountService.class);
        }
        return this.walletAccountService;
    }

    private WalletTokenAdminService getWalletTokenAdminService() {
        if (this.walletTokenAdminService == null) {
            this.walletTokenAdminService = (WalletTokenAdminService)CommonsUtils.getService(WalletTokenAdminService.class);
        }
        return this.walletTokenAdminService;
    }

    private WalletService getWalletService() {
        if (this.walletService == null) {
            this.walletService = (WalletService)CommonsUtils.getService(WalletService.class);
        }
        return this.walletService;
    }
}

